/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.persister;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.springframework.extensions.surf.ModelHelper;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.cache.ContentCache;
import org.springframework.extensions.surf.cache.ModelObjectCache;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.persister.AbstractCachedObjectPersister;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.PageAssociation;
import org.springframework.extensions.surf.util.ReflectionHelper;
import org.springframework.extensions.surf.util.XMLUtil;
import org.springframework.extensions.webscripts.PathUtil;
import org.springframework.extensions.webscripts.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyStoreObjectPersister
extends AbstractCachedObjectPersister {
    private static Log logger = LogFactory.getLog(ReadOnlyStoreObjectPersister.class);
    protected Store store;
    protected String pathPrefix = null;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    public void setStore(Store store) {
        this.store = store;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    protected String generatePath(String objectTypeId, String objectId) {
        String path = null;
        String prefix = this.getPathPrefix();
        path = prefix == null ? new StringBuilder(objectId.length() + 4).append(objectId).append(".xml").toString() : new StringBuilder(prefix.length() + objectId.length() + 5).append(prefix).append('/').append(objectId).append(".xml").toString();
        return path;
    }

    @Override
    public boolean saveObject(ModelPersistenceContext context, ModelObject modelObject) throws ModelObjectPersisterException {
        return false;
    }

    @Override
    public ModelObject newObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        if (objectId == null) {
            throw new ModelObjectPersisterException("Cannot create object with null object id");
        }
        String xml = "<" + objectTypeId + "></" + objectTypeId + ">";
        ModelObject obj = null;
        try {
            Document document = XMLUtil.parse(xml);
            String path = this.generatePath(objectTypeId, objectId);
            ModelPersisterInfo info = new ModelPersisterInfo(this.getId(), path, false);
            String implClassName = this.getWebFrameworkConfiguration().getTypeDescriptor(objectTypeId).getImplementationClass();
            obj = (ModelObject)ReflectionHelper.newObject((String)implClassName, (Class[])MODELOBJECT_CLASSES, (Object[])new Object[]{objectId, info, document});
            if (obj == null) {
                throw new ModelObjectPersisterException("Unable to construct object of class: " + implClassName + " for path: " + path);
            }
            obj.touch();
            this.cachePut(context, obj);
        }
        catch (DocumentException de) {
            throw new ModelObjectPersisterException("Failed to load objectId: " + objectId, (Exception)((Object)de));
        }
        return obj;
    }

    @Override
    public boolean removeObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        return false;
    }

    @Override
    public ModelObject getObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        ModelObject mo = null;
        if (this.isEnabled()) {
            mo = this.cacheGet(context, objectTypeId, objectId);
        }
        return mo;
    }

    @Override
    public boolean hasObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        if (!this.isEnabled()) {
            return false;
        }
        return this.cacheGet(context, objectTypeId, objectId) != null;
    }

    @Override
    public long getTimestamp(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        long timestamp = -1L;
        ModelObject obj = this.cacheGet(context, objectTypeId, objectId);
        if (obj != null) {
            timestamp = obj.getModificationTime();
        }
        return timestamp;
    }

    @Override
    public Map<String, ModelObject> getAllObjects(ModelPersistenceContext context, String objectTypeId) throws ModelObjectPersisterException {
        return this.getAllObjectsByFilter(context, objectTypeId, null);
    }

    @Override
    public Map<String, ModelObject> getAllObjectsByFilter(ModelPersistenceContext context, String objectTypeId, String objectIdPattern) throws ModelObjectPersisterException {
        if (!this.isEnabled()) {
            return new HashMap<String, ModelObject>();
        }
        HashMap<String, ModelObject> objects = new HashMap<String, ModelObject>(256);
        for (String key : this.caches.keySet()) {
            if (!key.startsWith(objectTypeId + ":")) continue;
            ModelObjectCache cache = (ModelObjectCache)this.caches.get(key);
            Iterator<String> it2 = cache.keys().iterator();
            while (it2.hasNext()) {
                boolean proceed = false;
                String key2 = it2.next();
                if (objectIdPattern == null) {
                    proceed = true;
                }
                if (!proceed) continue;
                objects.put(key2, cache.get(key2));
            }
        }
        return objects;
    }

    @Override
    public void init(ModelPersistenceContext context) {
        if (!this.store.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Store missing for persister: " + this.getId()));
            }
            this.disable();
            return;
        }
        this.reset();
        if (context == null) {
            context = new ModelPersistenceContext(null);
        }
        int count = 0;
        ArrayList<String> failedPaths = new ArrayList<String>();
        String[] paths = this.store.getAllDocumentPaths();
        for (int i = 0; i < paths.length; ++i) {
            boolean candidate = true;
            String path = paths[i];
            String lowerCasePath = path.toLowerCase();
            if (lowerCasePath.endsWith(".desc.xml")) {
                candidate = false;
            } else if (!lowerCasePath.endsWith(".xml")) {
                candidate = false;
            }
            if (!candidate) continue;
            try {
                ModelObject obj = this.getObjectByPath(context, path);
                if (obj == null) continue;
                ++count;
                continue;
            }
            catch (ModelObjectPersisterException mope) {
                if (!logger.isDebugEnabled()) continue;
                failedPaths.add(path);
            }
        }
        if (logger.isDebugEnabled()) {
            if (count > 0) {
                logger.debug((Object)("Store Persister '" + this.getId() + "' preload count: " + count));
            }
            if (failedPaths.size() != 0) {
                logger.debug((Object)("Store Persister '" + this.getId() + "' failed to load the following paths:"));
                for (String p : failedPaths) {
                    logger.debug((Object)("   " + p));
                }
            }
        }
    }

    @Override
    public void reset() {
        this.invalidateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ContentCache<ModelObject> getCache(ModelPersistenceContext context, String bucket) {
        ContentCache<ModelObject> cache;
        block7: {
            int idx;
            String userId;
            String storeId = (String)context.getValue(ModelPersistenceContext.REPO_STOREID);
            if (storeId == null && (userId = context.getUserId()) != null && (idx = userId.indexOf(64)) != -1) {
                storeId = userId.substring(idx);
            }
            String key = storeId != null ? new StringBuilder(100).append(bucket).append(':').append(storeId).toString() : new StringBuilder(64).append(bucket).append(":_global").toString();
            cache = null;
            this.cacheLock.readLock().lock();
            try {
                cache = (ContentCache<ModelObject>)this.caches.get(key);
                if (cache != null) break block7;
                this.cacheLock.readLock().unlock();
                this.cacheLock.writeLock().lock();
                try {
                    cache = this.createCache();
                    this.caches.put(key, cache);
                }
                finally {
                    this.cacheLock.readLock().lock();
                    this.cacheLock.writeLock().unlock();
                }
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
        }
        return cache;
    }

    @Override
    protected ContentCache<ModelObject> createCache() {
        return new ModelObjectCache(this.store, -1L, -1L);
    }

    protected ModelObject cacheGet(ModelPersistenceContext context, String objectTypeId, String objectId) {
        ContentCache<ModelObject> cc = this.getCache(context, objectTypeId);
        ModelObject mo = cc.get(objectId);
        return mo;
    }

    protected void cacheRemove(ModelPersistenceContext context, String objectTypeId, String objectId) {
        if (this.useCache) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Remove from cache: " + objectId));
            }
            this.getCache(context, objectTypeId).remove(objectId);
        }
    }

    protected ModelObject getObjectByPath(ModelPersistenceContext context, String path) throws ModelObjectPersisterException {
        if (!this.isEnabled()) {
            return null;
        }
        if (PathUtil.isDevelopmentEnvironmentPath((String)path)) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting object for path: " + path));
        }
        ModelObject obj = null;
        try {
            String objectId;
            Document document;
            String objectTypeId;
            if (this.store.hasDocument(path) && (objectTypeId = this.getObjectTypeId(document = XMLUtil.parse(this.store.getDocument(path)), path)) != null && (objectId = this.getObjectId(document, path)) != null) {
                Map<String, ModelObject> map = this.loadObjectAndDependants(context, document, objectTypeId, objectId, path);
                for (ModelObject o : map.values()) {
                    o.touch();
                    this.getCache(context, o.getTypeId()).put(o.getId(), o);
                }
                obj = map.get(objectId);
            }
        }
        catch (Exception ex) {
            throw new ModelObjectPersisterException("Failure to load model object for path: " + path, ex);
        }
        return obj;
    }

    protected Map<String, ModelObject> loadObjectAndDependants(ModelPersistenceContext context, Document document, String objectTypeId, String objectId, String path) throws ModelObjectPersisterException {
        Element associationsElement;
        LinkedHashMap<String, ModelObject> map = new LinkedHashMap<String, ModelObject>();
        ModelObject obj = this.createObject(document, objectTypeId, objectId, path);
        map.put(obj.getId(), obj);
        Element componentsElement = document.getRootElement().element("components");
        if (componentsElement != null) {
            List componentElements = componentsElement.elements("component");
            for (int i = 0; i < componentElements.size(); ++i) {
                Element componentElement = (Element)componentElements.get(i);
                String regionId = componentElement.elementText("region-id");
                String url = componentElement.elementText("url");
                String componentTypeId = componentElement.elementText("component-type-id");
                String chromeId = componentElement.elementText("chrome");
                String title = componentElement.elementText("title");
                String description = componentElement.elementText("description");
                String scope = null;
                if ("page".equals(objectTypeId)) {
                    scope = "page";
                }
                if ("template-instance".equals(objectTypeId)) {
                    scope = "template";
                }
                if (scope == null) continue;
                String componentObjectId = ModelHelper.newGUID();
                Component component = (Component)this.newObject(context, "component", componentObjectId);
                component.setRegionId(regionId);
                component.setSourceId(obj.getId());
                component.setScope(scope);
                component.setURL(url);
                component.setComponentTypeId(componentTypeId);
                component.setChrome(chromeId);
                component.setTitle(title);
                component.setDescription(description);
                Element properties = componentElement.element("properties");
                if (properties != null) {
                    Iterator itr = properties.elementIterator();
                    while (itr.hasNext()) {
                        Element prop = (Element)itr.next();
                        component.setCustomProperty(prop.getName(), prop.getText());
                    }
                }
                map.put(component.getId(), component);
            }
        }
        if ((associationsElement = document.getRootElement().element("associations")) != null && "page".equals(objectTypeId)) {
            List pageAssociationElements = associationsElement.elements("page-association");
            for (int i = 0; i < pageAssociationElements.size(); ++i) {
                Element pageAssociationElement = (Element)pageAssociationElements.get(i);
                String destId = pageAssociationElement.elementText("dest-id");
                String assocType = pageAssociationElement.elementText("assoc-type");
                String orderId = pageAssociationElement.elementText("order-id");
                String pageAssociationObjectId = ModelHelper.newGUID();
                PageAssociation pageAssociation = (PageAssociation)this.newObject(context, "page-association", pageAssociationObjectId);
                pageAssociation.setDestId(destId);
                pageAssociation.setAssociationType(assocType);
                pageAssociation.setSourceId(objectId);
                pageAssociation.setOrderId(orderId);
                map.put(pageAssociation.getId(), pageAssociation);
            }
        }
        return map;
    }

    protected ModelObject createObject(Document document, String objectTypeId, String objectId, String path) {
        ModelPersisterInfo info = new ModelPersisterInfo(this.getId(), path, true);
        String implClassName = this.getWebFrameworkConfiguration().getTypeDescriptor(objectTypeId).getImplementationClass();
        ModelObject obj = (ModelObject)ReflectionHelper.newObject((String)implClassName, (Class[])MODELOBJECT_CLASSES, (Object[])new Object[]{objectId, info, document});
        return obj;
    }

    protected String getObjectTypeId(Document doc, String path) {
        String objectTypeId = null;
        if (doc != null && doc.getRootElement() != null) {
            objectTypeId = doc.getRootElement().getName();
        }
        if (objectTypeId != null && this.getWebFrameworkConfiguration().getTypeDescriptor(objectTypeId) == null) {
            objectTypeId = null;
        }
        return objectTypeId;
    }

    protected String getObjectId(Document doc, String path) {
        String id = doc.getRootElement().elementText("id");
        if (id == null && path != null) {
            int i = (path = path.replace('\\', '/')).lastIndexOf(47);
            if (i > -1) {
                id = path.substring(i + 1);
            }
            if (id.endsWith(".xml")) {
                id = id.substring(0, id.length() - 4);
            }
        }
        return id;
    }

    protected boolean isModelObject(Document doc, String path) {
        return this.getObjectTypeId(doc, path) != null;
    }

    public String toString() {
        return this.getClass().getName() + " ID: " + this.getId() + " PathPrefix: " + this.pathPrefix + " Store: " + this.store.toString();
    }
}

