/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.LinkBuilder;
import org.springframework.extensions.surf.LinkBuilderFactory;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.PageRendererExecutionException;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.exception.RequestDispatchException;
import org.springframework.extensions.surf.exception.ResourceLoaderException;
import org.springframework.extensions.surf.render.Processor;
import org.springframework.extensions.surf.render.ProcessorContext;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderMode;
import org.springframework.extensions.surf.render.RenderUtil;
import org.springframework.extensions.surf.render.Renderable;
import org.springframework.extensions.surf.render.bean.ChromeRenderer;
import org.springframework.extensions.surf.render.bean.ComponentRenderer;
import org.springframework.extensions.surf.render.bean.PageRenderer;
import org.springframework.extensions.surf.render.bean.RegionRenderer;
import org.springframework.extensions.surf.render.bean.TemplateInstanceRenderer;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.resource.ResourceProvider;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Chrome;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.ComponentType;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.surf.types.TemplateType;
import org.springframework.extensions.surf.types.Theme;

public class RenderService
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(RenderService.class);
    public static final String CONTEXT_VALUE_ERROR_THROWABLE = "error-throwable";
    public static final String CONTEXT_VALUE_ERROR_PAGE_ID = "error-pageId";
    public static final String CONTEXT_VALUE_ERROR_TEMPLATE_ID = "error-templateId";
    public static final String CONTEXT_VALUE_ERROR_REGION_ID = "error-regionId";
    public static final String CONTEXT_VALUE_ERROR_REGION_SCOPE_ID = "error-regionScopeId";
    public static final String CONTEXT_VALUE_ERROR_REGION_SOURCE_ID = "error-regionSourceId";
    public static final String CONTEXT_VALUE_ERROR_COMPONENT_ID = "error-componentId";
    public static final String CONTEXT_VALUE_ERROR_TITLE = "errorTitle";
    public static final String CONTEXT_VALUE_ERROR_DESCRIPTION = "errorDescription";
    public static final String CONTEXT_VALUE_STACKTRACE = "stacktrace";
    private static final String PREFIX_WEBFRAMEWORK_RENDITION_PROCESSOR = "webframework.rendition.processor.";
    private static final String COMPONENT_TYPE_WEBSCRIPT = "webscript";
    private static final String TEMPLATE_TYPE_WEBTEMPLATE = "webtemplate";
    public static final String NEWLINE = "\r\n";
    private ModelObjectService modelObjectService;
    private WebFrameworkConfigElement webFrameworkConfiguration;
    private PageRenderer pageRenderer;
    private TemplateInstanceRenderer templateRenderer;
    private RegionRenderer regionRenderer;
    private ComponentRenderer componentRenderer;
    private ApplicationContext applicationContext;
    private ResourceService resourceService;
    private LinkBuilderFactory linkBuilderFactory;
    private LinkBuilder linkBuilder;
    private String beanName;

    public Processor getRenditionProcessorById(String id) {
        String processorId = PREFIX_WEBFRAMEWORK_RENDITION_PROCESSOR + id;
        return (Processor)this.applicationContext.getBean(processorId);
    }

    public Processor getRenditionProcessor(Renderable renderable) {
        return this.getRenditionProcessor(renderable, RenderMode.VIEW);
    }

    public Processor getRenditionProcessor(Renderable renderable, RenderMode renderMode) {
        Processor processor = null;
        if (renderable != null) {
            String processorId = renderable.getProcessorId(renderMode);
            if (processorId != null) {
                processor = this.getRenditionProcessorById(processorId);
            } else {
                logger.error((Object)("Unable to get processor for id: " + processorId));
            }
        } else {
            logger.error((Object)"Unable to get processor - renderable was null");
        }
        return processor;
    }

    public void processRenderable(RequestContext context, RenderFocus renderFocus, ModelObject object, Renderable renderable) throws RendererExecutionException {
        Processor processor = this.getRenditionProcessor(renderable);
        if (processor != null) {
            ProcessorContext processorContext = new ProcessorContext(context);
            processorContext.load(renderable);
            processor.execute(processorContext, object, renderFocus);
        }
    }

    public void processComponent(RequestContext context, RenderFocus renderFocus, Component component) throws RendererExecutionException {
        block15: {
            String uri = component.getURL();
            if (uri == null) {
                uri = component.getProperty("uri");
            }
            if (uri == null) {
                uri = component.getProperty("url");
            }
            ComponentType componentType = null;
            String componentTypeId = component.getComponentTypeId();
            if (componentTypeId != null) {
                componentType = this.modelObjectService.getComponentType(componentTypeId);
                if (componentType == null) {
                    uri = componentTypeId;
                    componentType = this.modelObjectService.getComponentType(COMPONENT_TYPE_WEBSCRIPT);
                }
            } else if (uri != null && componentTypeId == null) {
                componentType = this.modelObjectService.getComponentType(COMPONENT_TYPE_WEBSCRIPT);
            }
            if (componentType == null) {
                throw new RendererExecutionException("Cannot resolve component URL - may be missing from the definition: " + component.toString());
            }
            Processor processor = this.getRenditionProcessor((Renderable)((Object)componentType));
            if (processor != null) {
                ProcessorContext processorContext = new ProcessorContext(context);
                processorContext.load((Renderable)((Object)componentType));
                if (uri != null) {
                    ProcessorContext.ProcessorDescriptor viewDescriptor = processorContext.getDescriptor(RenderMode.VIEW);
                    viewDescriptor.put("uri", uri);
                }
                try {
                    processor.execute(processorContext, component, renderFocus);
                    if (!context.hasValue("alfStylesheet")) break block15;
                    LinkedList css = (LinkedList)context.getValue("alfStylesheet");
                    if (css != null) {
                        try {
                            Iterator iter = css.iterator();
                            PrintWriter writer = context.getResponse().getWriter();
                            ((Writer)writer).write("   <style type=\"text/css\" media=\"screen\">\n");
                            while (iter.hasNext()) {
                                ((Writer)writer).write("      @import \"" + iter.next() + "\";\n");
                            }
                            ((Writer)writer).write("   </style>");
                        }
                        catch (IOException ioe) {
                            throw new RendererExecutionException(ioe);
                        }
                    }
                    context.removeValue("alfStylesheet");
                }
                catch (RendererExecutionException ree) {
                    logger.error((Object)("Unable to process component: " + component.getId()));
                    throw ree;
                }
            }
        }
    }

    public void processTemplate(RequestContext context, RenderFocus renderFocus, TemplateInstance template) throws RendererExecutionException {
        String uri = null;
        TemplateType templateType = null;
        String templateTypeId = template.getTemplateTypeId();
        if (templateTypeId != null) {
            templateType = this.modelObjectService.getTemplateType(templateTypeId);
            if (templateType == null) {
                uri = templateTypeId;
                templateType = this.modelObjectService.getTemplateType(TEMPLATE_TYPE_WEBTEMPLATE);
            }
        } else {
            templateTypeId = template.getId();
            if (uri != null && templateTypeId == null) {
                templateTypeId = TEMPLATE_TYPE_WEBTEMPLATE;
            }
            templateType = this.modelObjectService.getTemplateType(templateTypeId);
        }
        if (templateType == null) {
            throw new RendererExecutionException("Cannot resolve template - may be missing from the definition: " + template.toString());
        }
        Processor processor = this.getRenditionProcessor((Renderable)((Object)templateType));
        if (processor != null) {
            ProcessorContext processorContext = new ProcessorContext(context);
            processorContext.load((Renderable)((Object)templateType));
            if (uri != null) {
                ProcessorContext.ProcessorDescriptor viewDescriptor = processorContext.getDescriptor(RenderMode.VIEW);
                viewDescriptor.put("uri", uri);
            }
            try {
                processor.execute(processorContext, template, renderFocus);
            }
            catch (RendererExecutionException ree) {
                logger.error((Object)("Unable to process template: " + template.getId()));
                throw ree;
            }
        }
    }

    public void renderPage(RequestContext context, RenderFocus renderFocus) {
        try {
            Page page = context.getPage();
            if (page == null) {
                throw new PageRendererExecutionException("Unable to locate current page in request context");
            }
            this.pageRenderer.render(context, page, renderFocus);
        }
        catch (RendererExecutionException e) {
            String pageId = context.getPageId();
            context.setValue(CONTEXT_VALUE_ERROR_THROWABLE, e);
            context.setValue(CONTEXT_VALUE_ERROR_PAGE_ID, (Serializable)((Object)pageId));
            this.handleRenderProblem(pageId, "page-error", context, e);
        }
    }

    public void renderTemplate(RequestContext context, RenderFocus renderFocus) {
        try {
            TemplateInstance template = context.getTemplate();
            this.templateRenderer.render(context, template, RenderFocus.BODY);
        }
        catch (RendererExecutionException e) {
            String templateId = context.getTemplateId();
            context.setValue(CONTEXT_VALUE_ERROR_THROWABLE, e);
            context.setValue(CONTEXT_VALUE_ERROR_PAGE_ID, (Serializable)((Object)templateId));
            this.handleRenderProblem(templateId, "template-error", context, e);
        }
    }

    public void renderRegion(RequestContext context, RenderFocus renderFocus, String templateId, String regionId, String regionScopeId, String overrideChromeId) {
        try {
            String regionSourceId = RenderUtil.getSourceId(context, regionScopeId);
            context.setValue("region-id", (Serializable)((Object)regionId));
            context.setValue("region-scope-id", (Serializable)((Object)regionScopeId));
            context.setValue("region-source-id", (Serializable)((Object)regionSourceId));
            Component component = this.getComponentBoundToRegion(context, regionId, regionScopeId, regionSourceId);
            if (component != null) {
                context.setValue("htmlid", (Serializable)((Object)RenderUtil.validHtmlId(component.getId())));
            } else {
                context.setValue("htmlid", (Serializable)((Object)("unbound-region-" + RenderUtil.validHtmlId(regionId))));
            }
            if (overrideChromeId != null) {
                context.setValue("region-chrome-id", (Serializable)((Object)overrideChromeId));
            }
            this.regionRenderer.render(context, component, renderFocus);
        }
        catch (RendererExecutionException e) {
            String regionSourceId = RenderUtil.getSourceId(context, regionScopeId);
            context.setValue(CONTEXT_VALUE_ERROR_THROWABLE, e);
            context.setValue(CONTEXT_VALUE_ERROR_TEMPLATE_ID, (Serializable)((Object)templateId));
            context.setValue(CONTEXT_VALUE_ERROR_REGION_ID, (Serializable)((Object)regionId));
            context.setValue(CONTEXT_VALUE_ERROR_REGION_SCOPE_ID, (Serializable)((Object)regionScopeId));
            context.setValue(CONTEXT_VALUE_ERROR_REGION_SOURCE_ID, (Serializable)((Object)regionSourceId));
            this.handleRenderProblem(regionId, "region-error", context, e);
        }
    }

    public void renderRegionComponents(RequestContext context, ModelObject object) throws RendererExecutionException {
        String regionSourceId;
        String regionScopeId;
        String regionId = (String)((Object)context.getValue("region-id"));
        Component component = this.getComponentBoundToRegion(context, regionId, regionScopeId = (String)((Object)context.getValue("region-scope-id")), regionSourceId = (String)((Object)context.getValue("region-source-id")));
        if (component != null) {
            if (context.isPassiveMode()) {
                context.setRenderingComponent(component);
            } else {
                context.setValue("component-id", (Serializable)((Object)component.getId()));
                this.renderComponent(context, RenderFocus.BODY, component, null, false);
            }
        } else {
            context.setValue("htmlid", (Serializable)((Object)("unbound-region-" + regionId)));
            boolean handled = this.renderErrorHandlerPage(context, "region-nocomponent");
            if (!handled) {
                // empty if block
            }
        }
    }

    public void renderComponent(RequestContext context, RenderFocus renderFocus, Component component, String chromeIdOverride, boolean chromeless) {
        try {
            context.setValue("component-id", (Serializable)((Object)component.getId()));
            if (chromeless) {
                this.processComponent(context, renderFocus, component);
            } else {
                String componentChromeId = null;
                componentChromeId = chromeIdOverride != null && chromeIdOverride.length() != 0 ? chromeIdOverride : (component.getChrome() != null ? component.getChrome() : this.webFrameworkConfiguration.getDefaultComponentChrome());
                Chrome chrome = this.modelObjectService.getChrome(componentChromeId);
                context.setValue("component-chrome", chrome);
                this.componentRenderer.render(context, component, renderFocus);
            }
        }
        catch (RendererExecutionException e) {
            context.setValue(CONTEXT_VALUE_ERROR_THROWABLE, e);
            context.setValue(CONTEXT_VALUE_ERROR_COMPONENT_ID, (Serializable)((Object)component.getId()));
            context.setRenderMode(RenderMode.VIEW);
            this.handleRenderProblem(component.getId(), "component-error", context, e);
        }
    }

    public void renderComponent(RequestContext context, RenderFocus renderFocus, String componentId, String overrideChromeId, boolean chromeless) {
        Component component = this.modelObjectService.getComponent(componentId);
        this.renderComponent(context, renderFocus, component, overrideChromeId, chromeless);
    }

    public Chrome getRegionChrome(String regionId, String chromeId) {
        Chrome chrome = null;
        if (chromeId == null || chromeId.length() == 0) {
            chromeId = this.webFrameworkConfiguration.getDefaultRegionChrome();
        }
        chrome = this.modelObjectService.getChrome(chromeId);
        return chrome;
    }

    public Component getComponentBoundToRegion(RequestContext context, String regionId, String regionScopeId, String regionSourceId) {
        Theme theme;
        Component component = this.modelObjectService.getComponent(regionScopeId, regionId, regionSourceId);
        if ((component == null || "theme".equals(regionScopeId)) && (theme = context.getTheme()) != null) {
            component = theme.getDefaultComponent(context, regionId);
        }
        return component;
    }

    public boolean renderErrorHandlerPage(RequestContext context, String errorHandlerPageId) throws RendererExecutionException {
        boolean handled = false;
        WebFrameworkConfigElement.ErrorHandlerDescriptor descriptor = this.webFrameworkConfiguration.getErrorHandlerDescriptor(errorHandlerPageId);
        if (descriptor != null) {
            String processorId = descriptor.getProcessorId();
            Map<String, String> descriptorProperties = descriptor.map();
            Processor processor = this.getRenditionProcessorById(processorId);
            ProcessorContext processorContext = new ProcessorContext(context);
            processorContext.addDescriptor(RenderMode.VIEW, descriptorProperties);
            processor.executeBody(processorContext, null);
            handled = true;
        }
        return handled;
    }

    public boolean renderSystemPage(RequestContext context, String systemPageId) throws RendererExecutionException {
        boolean handled = false;
        WebFrameworkConfigElement.SystemPageDescriptor descriptor = this.webFrameworkConfiguration.getSystemPageDescriptor(systemPageId);
        if (descriptor != null) {
            String processorId = descriptor.getProcessorId();
            Map<String, String> descriptorProperties = descriptor.map();
            Processor processor = this.getRenditionProcessorById(processorId);
            ProcessorContext processorContext = new ProcessorContext(context);
            processorContext.addDescriptor(RenderMode.VIEW, descriptorProperties);
            processor.executeBody(processorContext, null);
            handled = true;
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderTemplateHeaderAsString(RequestContext context, ModelObject object) throws RendererExecutionException, UnsupportedEncodingException {
        String headTags = "";
        if (!context.isPassiveMode()) {
            try {
                context.setPassiveMode(true);
                this.templateRenderer.header(context, object);
                headTags = context.getContentAsString();
                if (headTags == null) {
                    headTags = "";
                }
            }
            finally {
                context.setPassiveMode(false);
            }
        }
        return headTags;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setLinkBuilderFactory(LinkBuilderFactory linkBuilderFactory) {
        this.linkBuilderFactory = linkBuilderFactory;
        this.linkBuilder = this.linkBuilderFactory.newInstance();
    }

    public void renderChromeInclude(RequestContext context, ModelObject object) throws RequestDispatchException {
        Serializable value = context.getValue("tagLibRenderType");
        if (value != null && value instanceof String) {
            String renderType = (String)((Object)value);
            if (renderType.equals("tagLibComponentRendering")) {
                String componentId = (String)((Object)context.getValue("component-id"));
                if (componentId != null) {
                    this.renderComponent(context, RenderFocus.BODY, componentId, null, true);
                } else {
                    this.handleError(context, "Could not find a component id to render", "The id of the component was expected to be stored in the RequestContext as the \"component-id\" attribute.", null);
                }
            } else if (renderType.equals("tagLibRegionRendering")) {
                try {
                    this.renderRegionComponents(context, object);
                }
                catch (Throwable t) {
                    String regionId = (String)((Object)context.getValue("region-id"));
                    String regionScopeId = (String)((Object)context.getValue("region-scope-id"));
                    String regionSourceId = (String)((Object)context.getValue("region-source-id"));
                    this.handleError(context, "An error occurred attempting to render the components of the region: " + regionId + ", at scope: " + regionScopeId + ", from the source: " + regionSourceId, null, t);
                }
            } else {
                logger.error((Object)("Unexpected render type set in RequestContext: " + renderType));
                this.handleError(context, "Unexpected render type", "The RequestContext should have been set with an attribute \"RENDER_TYPE\" whichshould have been either \"tagLibComponentRendering\" or \"tagLibRegionRendering\", but the actual value was set to: \"" + renderType + "\". The only place that this attribute should be set is in the " + ChromeRenderer.class.getName() + " class", null);
            }
        } else if (value == null) {
            logger.error((Object)"RequestContext key has not been set");
            this.handleError(context, "Unexpected render type class", "The RequestContext should have been set with an attribute \"RENDER_TYPE\" whichshould have been either \"tagLibComponentRendering\" or \"tagLibRegionRendering\", but it has not been set at all.", null);
        } else {
            logger.error((Object)("Unexpected render type set in RequestContext: " + value.getClass().getName()));
            this.handleError(context, "Unexpected render type class", "The RequestContext should have been set with an attribute \"RENDER_TYPE\" whichshould have been either \"tagLibComponentRendering\" or \"tagLibRegionRendering\", but the actual value was set to an unexpected Class: " + value.getClass().getName(), null);
        }
    }

    public String generateAnchorLink(String pageTypeId, String pageId, String objectId, String formatId, String target) {
        StringBuilder sb = new StringBuilder();
        sb.append("<A href=\"");
        sb.append(this.generateLink(pageTypeId, pageId, objectId, formatId));
        sb.append("\"");
        if (target != null) {
            sb.append(" target=\"");
            sb.append(target);
            sb.append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    public String generateLink(String pageTypeId, String pageId, String objectId, String formatId) {
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        String link = null;
        if (pageTypeId != null) {
            link = objectId != null ? this.linkBuilder.pageType(context, pageTypeId, formatId, objectId) : this.linkBuilder.pageType(context, pageTypeId, formatId);
        } else if (pageId != null) {
            link = objectId != null ? this.linkBuilder.page(context, pageId, formatId, objectId) : this.linkBuilder.page(context, pageId, formatId);
        } else if (objectId != null) {
            link = this.linkBuilder.object(context, objectId, formatId);
        }
        return link;
    }

    public String generateResourceURL(RequestContext renderContext, ModelObject object, String name, String id, String protocol, String endpoint, String objectId, String payload) {
        String url = null;
        if (object != null) {
            try {
                Resource resource = null;
                if (name != null && object instanceof ResourceProvider) {
                    ResourceProvider provider = (ResourceProvider)((Object)object);
                    resource = provider.getResource(name);
                } else {
                    resource = id != null ? this.resourceService.getResource(id) : this.resourceService.getResource(protocol, endpoint, objectId);
                }
                url = resource.getContentURL();
                if ("metadata".equalsIgnoreCase(payload)) {
                    url = resource.getMetadataURL();
                }
            }
            catch (ResourceLoaderException e) {
                String msg = "An exception occurred loading a resource using the following values, name=\"" + name + "\", id=\"" + id + "\", protocol=\"" + protocol + "\", endpoint=\"" + endpoint + "\", objectId=\"" + objectId + "\", payload=\"" + payload + "\"";
                logger.error((Object)msg, (Throwable)e);
                url = msg;
            }
        }
        return url;
    }

    public void updateStyleSheetImports(RequestContext context, String href) {
        LinkedList css = null;
        if (context.hasValue("alfStylesheet")) {
            css = (LinkedList)context.getValue("alfStylesheet");
        } else {
            css = new LinkedList();
            context.setValue("alfStylesheet", css);
        }
        css.add(href);
    }

    protected void handleError(RequestContext context, String errorTitle, String errorDescription, Throwable t) throws RequestDispatchException {
        if (errorTitle != null) {
            context.setValue(CONTEXT_VALUE_ERROR_TITLE, (Serializable)((Object)errorTitle));
        }
        if (errorDescription != null) {
            context.setValue(CONTEXT_VALUE_ERROR_DESCRIPTION, (Serializable)((Object)errorDescription));
        }
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            context.setValue(CONTEXT_VALUE_STACKTRACE, (Serializable)((Object)pw.toString()));
        }
        this.handleRenderProblem("", "general-error", context, t);
    }

    protected void handleRenderProblem(String targetId, String errorPageId, RequestContext context, Throwable t) {
        logger.error((Object)("An exception occurred while rendering: " + targetId), t);
        try {
            if (!this.renderErrorHandlerPage(context, errorPageId)) {
                logger.error((Object)("An error occurred rendering error page: " + errorPageId));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void setModelObjectService(ModelObjectService modelObjectService) {
        this.modelObjectService = modelObjectService;
    }

    public void setWebFrameworkConfiguration(WebFrameworkConfigElement webFrameworkConfiguration) {
        this.webFrameworkConfiguration = webFrameworkConfiguration;
    }

    public void setPageRenderer(PageRenderer pageRenderer) {
        this.pageRenderer = pageRenderer;
    }

    public void setTemplateRenderer(TemplateInstanceRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setRegionRenderer(RegionRenderer regionRenderer) {
        this.regionRenderer = regionRenderer;
    }

    public void setComponentRenderer(ComponentRenderer componentRenderer) {
        this.componentRenderer = componentRenderer;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }
}

