/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.support;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.springframework.extensions.surf.LinkBuilder;
import org.springframework.extensions.surf.LinkBuilderFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RequestContextException;
import org.springframework.extensions.surf.support.AbstractRequestContextFactory;
import org.springframework.extensions.surf.support.ServletLinkBuilderFactory;
import org.springframework.extensions.surf.support.ServletRequestContext;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;

public class ServletRequestContextFactory
extends AbstractRequestContextFactory {
    private static final String SERVLET_LINKBUILDER_FACTORY_ID = "webframework.factory.linkbuilder.servlet";
    private LinkBuilderFactory linkBuilderFactory = null;

    public void setLinkBuilderFactory(LinkBuilderFactory linkBuilderFactory) {
        this.linkBuilderFactory = linkBuilderFactory;
    }

    public boolean canHandle(WebRequest webRequest) {
        return webRequest instanceof DispatcherServletWebRequest;
    }

    public LinkBuilder createLinkBuilder() {
        ServletLinkBuilderFactory linkBuilderFactory = (ServletLinkBuilderFactory)this.getApplicationContext().getBean(SERVLET_LINKBUILDER_FACTORY_ID);
        LinkBuilder linkBuilder = linkBuilderFactory.newInstance();
        return linkBuilder;
    }

    public RequestContext newInstance(WebRequest webRequest) throws RequestContextException {
        if (!(webRequest instanceof ServletWebRequest)) {
            throw new RequestContextException("ServletRequestContextFactory can only produce RequestContext instances for ServletWebRequest objects.");
        }
        ServletWebRequest dispatcherRequest = (ServletWebRequest)webRequest;
        HttpServletRequest request = dispatcherRequest.getRequest();
        try {
            request.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException encErr) {
            // empty catch block
        }
        LinkBuilder linkBuilder = this.linkBuilderFactory == null ? this.createLinkBuilder() : this.linkBuilderFactory.newInstance();
        ServletRequestContext context = new ServletRequestContext(this.webFrameworkServiceRegistry, this.frameworkUtils, linkBuilder);
        webRequest.setAttribute("requestContext", (Object)context, 0);
        context.method = request.getMethod();
        context.contextPath = request.getContextPath();
        context.uri = request.getRequestURI();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = request.getParameter(parameterName);
            if (parameterValue == null) continue;
            context.parametersMap.put(parameterName, parameterValue);
        }
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = request.getAttribute(attributeName);
            if (attributeValue == null || !(attributeValue instanceof Serializable)) continue;
            context.attributesMap.put(attributeName, (Serializable)attributeValue);
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            if (headerValue == null) continue;
            context.headersMap.put(headerName, headerValue);
        }
        return context;
    }
}

