/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class FakeHttpServletResponse
extends HttpServletResponseWrapper {
    private static final String CHARSET_PREFIX = "charset=";
    private String characterEncoding = "UTF-8";
    private ByteArrayOutputStream content;
    private DelegatingServletOutputStream outputStream;
    private PrintWriter writer;
    private int contentLength = 0;
    private String contentType;
    private int bufferSize = 1024;
    private boolean committed;
    private Locale locale = Locale.getDefault();
    private List<Cookie> cookies = null;
    private Map<String, Object> headers = null;
    private int status = 200;
    private String errorMessage;
    private String redirectedUrl;
    private String forwardedUrl;
    private String includedUrl;
    private boolean initialised = false;

    public FakeHttpServletResponse(HttpServletResponse wrapped) {
        super(wrapped);
    }

    private void init() {
        if (!this.initialised) {
            this.content = new ByteArrayOutputStream(1024);
            this.outputStream = new DelegatingServletOutputStream(this.content);
            this.initialised = true;
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() {
        this.init();
        return this.outputStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            Writer targetWriter = new Writer(){
                private Writer proxy = null;

                private Writer getWriter() throws UnsupportedEncodingException {
                    if (this.proxy == null) {
                        FakeHttpServletResponse.this.init();
                        this.proxy = FakeHttpServletResponse.this.characterEncoding != null ? new OutputStreamWriter((OutputStream)FakeHttpServletResponse.this.content, FakeHttpServletResponse.this.characterEncoding) : new OutputStreamWriter(FakeHttpServletResponse.this.content);
                    }
                    return this.proxy;
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                    this.getWriter().write(cbuf, off, len);
                }

                public void flush() throws IOException {
                    if (this.proxy != null) {
                        this.getWriter().flush();
                    }
                }

                public void close() throws IOException {
                    if (this.proxy != null) {
                        this.getWriter().close();
                    }
                }
            };
            this.writer = new PrintWriter(targetWriter, true);
        }
        return this.writer;
    }

    public void flushBuffer() {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not flush OutputStream: " + ex.getMessage());
            }
        }
        this.committed = true;
    }

    public void sendError(int newStatus, String newErrorMessage) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = newStatus;
        this.errorMessage = newErrorMessage;
        this.committed = true;
    }

    public void sendError(int newStatus) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = newStatus;
        this.committed = true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void sendRedirect(String url) throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Cannot send redirect - response is already committed");
        }
        this.redirectedUrl = url;
        this.committed = true;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.content != null ? this.content.toByteArray() : new byte[]{};
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        String contentToReturn = "";
        this.flushBuffer();
        if (this.content != null) {
            contentToReturn = this.characterEncoding != null ? this.content.toString(this.characterEncoding) : this.content.toString();
        }
        return contentToReturn;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String contentType) {
        int charsetIndex;
        this.contentType = contentType;
        if (contentType != null && (charsetIndex = contentType.toLowerCase().indexOf(CHARSET_PREFIX)) != -1) {
            String encoding = contentType.substring(charsetIndex + CHARSET_PREFIX.length());
            this.setCharacterEncoding(encoding);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        if (this.content != null) {
            this.content.reset();
        }
    }

    public void reset() {
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentLength = 0;
        this.contentType = null;
        this.locale = null;
        this.cookies = null;
        this.headers = null;
        this.status = 200;
        this.errorMessage = null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addCookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>(4);
        }
        this.cookies.add(cookie);
    }

    public Cookie[] getCookies() {
        return this.cookies == null ? new Cookie[]{} : this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public Cookie getCookie(String name) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>(4);
        }
        for (Cookie cookie : this.cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public void addHeader(String name, String value) {
        this.doAddHeader(name, value);
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>(8);
        }
        this.headers.put(name, value);
    }

    public void addDateHeader(String name, long value) {
        this.doAddHeader(name, new Long(value));
    }

    public void setDateHeader(String name, long value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>(8);
        }
        this.headers.put(name, new Long(value));
    }

    public void addIntHeader(String name, int value) {
        this.doAddHeader(name, new Integer(value));
    }

    public void setIntHeader(String name, int value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>(8);
        }
        this.headers.put(name, new Integer(value));
    }

    private void doAddHeader(String name, Object value) {
        Object oldValue;
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>(8);
        }
        if ((oldValue = this.headers.get(name)) instanceof List) {
            List list = (List)oldValue;
            list.add(value);
        } else if (oldValue != null) {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(oldValue);
            list.add(value);
            this.headers.put(name, list);
        } else {
            this.headers.put(name, value);
        }
    }

    public boolean containsHeader(String name) {
        return this.headers != null ? this.headers.containsKey(name) : false;
    }

    public Set getHeaderNames() {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>(8);
        }
        return this.headers.keySet();
    }

    public Object getHeader(String name) {
        return this.headers != null ? this.headers.get(name) : null;
    }

    public List getHeaders(String name) {
        Object value;
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>(8);
        }
        if ((value = this.headers.get(name)) instanceof List) {
            return (List)value;
        }
        if (value != null) {
            return Collections.singletonList(value);
        }
        return Collections.EMPTY_LIST;
    }

    public void setForwardedUrl(String forwardedUrl) {
        this.forwardedUrl = forwardedUrl;
    }

    public String getForwardedUrl() {
        return this.forwardedUrl;
    }

    public void setIncludedUrl(String includedUrl) {
        this.includedUrl = includedUrl;
    }

    public String getIncludedUrl() {
        return this.includedUrl;
    }

    public class DelegatingServletOutputStream
    extends ServletOutputStream {
        private final OutputStream proxy;

        public DelegatingServletOutputStream(OutputStream targetStream) {
            this.proxy = targetStream;
        }

        public OutputStream getTargetStream() {
            return this.proxy;
        }

        public void write(int b) throws IOException {
            this.proxy.write(b);
        }

        public void flush() throws IOException {
            super.flush();
            this.proxy.flush();
        }

        public void close() throws IOException {
            super.close();
            this.proxy.close();
        }
    }
}

