/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.RequestContextUtil;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.PresentationContainer;
import org.springframework.extensions.webscripts.ProcessorModelHelper;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalWebScriptRuntimeContainer
extends PresentationContainer {
    private ThreadLocal<RequestContext> renderContext = new ThreadLocal();
    private ThreadLocal<ModelObject> modelObject = new ThreadLocal();
    private ProcessorModelHelper processorModelHelper;

    public void setProcessorModelHelper(ProcessorModelHelper processorModelHelper) {
        this.processorModelHelper = processorModelHelper;
    }

    protected void bindRequestContext(RequestContext context) {
        this.renderContext.set(context);
    }

    protected void bindModelObject(ModelObject object) {
        this.modelObject.set(object);
    }

    protected void unbindRequestContext() {
        this.renderContext.remove();
    }

    protected void unbindModelObject() {
        this.modelObject.remove();
    }

    protected RequestContext getRequestContext() {
        return this.renderContext.get();
    }

    protected ModelObject getModelObject() {
        return this.modelObject.get();
    }

    public void reset() {
        super.reset();
        if (this.getApplicationContext() != null) {
            this.getScriptProcessorRegistry().reset();
            this.getTemplateProcessorRegistry().reset();
        }
    }

    public Map<String, Object> getScriptParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(8, 1.0f);
        params.putAll(super.getScriptParameters());
        RequestContext context = this.getRequestContext();
        ModelObject object = this.getModelObject();
        if (context != null) {
            this.processorModelHelper.populateScriptModel(context, params, object);
        }
        return params;
    }

    public Map<String, Object> getTemplateParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(32, 1.0f);
        params.putAll(super.getTemplateParameters());
        RequestContext context = this.getRequestContext();
        ModelObject object = this.getModelObject();
        if (context != null) {
            try {
                this.processorModelHelper.populateTemplateModel(context, params, object);
            }
            catch (RendererExecutionException ree) {
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript(WebScriptRequest scriptReq, WebScriptResponse scriptRes, Authenticator auth) throws IOException {
        boolean handleBinding = false;
        RequestContext rc = null;
        try {
            HttpServletResponse response;
            RequestContext context;
            HttpServletRequest request;
            if (ServletUtil.getRequest() == null && (request = WebScriptServletRuntime.getHttpServletRequest((WebScriptRequest)scriptReq)) != null) {
                try {
                    rc = RequestContextUtil.initRequestContext(this.getApplicationContext(), request);
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize RequestContext for local WebScript runtime: " + e.getMessage());
                }
            }
            if ((context = this.getRequestContext()) == null && (response = WebScriptServletRuntime.getHttpServletResponse((WebScriptResponse)scriptRes)) != null) {
                context = ThreadLocalRequestContext.getRequestContext();
                context.setResponse(response);
                handleBinding = true;
            }
            if (handleBinding) {
                this.bindRequestContext(context);
            }
            try {
                super.executeScript(scriptReq, scriptRes, auth);
            }
            finally {
                if (handleBinding) {
                    this.unbindRequestContext();
                }
            }
        }
        finally {
            if (rc != null) {
                rc.release();
            }
        }
    }
}

