/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import org.mozilla.javascript.Scriptable;
import org.springframework.extensions.surf.ModelHelper;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.extensions.webscripts.ScriptBase;
import org.springframework.extensions.webscripts.ScriptHelper;
import org.springframework.extensions.webscripts.ScriptResources;
import org.springframework.extensions.webscripts.ScriptableLinkedHashMap;
import org.springframework.extensions.webscripts.ScriptableMap;

public final class ScriptModelObject
extends ScriptBase {
    private static final long serialVersionUID = -3378946227712939601L;
    private final ModelObject modelObject;
    private final ScriptResources resources;

    public ScriptModelObject(RequestContext context, ModelObject modelObject) {
        super(context);
        this.modelObject = modelObject;
        this.resources = new ScriptResources(context, this.modelObject);
    }

    protected ScriptableMap buildProperties() {
        if (this.properties == null) {
            this.properties = new ScriptableLinkedHashMap<String, Serializable>(this.modelObject.getProperties()){

                public void put(String name, Scriptable start, Object value) {
                    this.put(name, (Serializable)value);
                    ScriptModelObject.this.modelObject.setProperty(name, value != null ? value.toString() : null);
                }

                public void put(int index, Scriptable start, Object value) {
                }

                public void delete(String name) {
                    this.remove(name);
                    ScriptModelObject.this.modelObject.removeProperty(name);
                }

                public void delete(int index) {
                }
            };
        }
        return this.properties;
    }

    public String getId() {
        return this.modelObject.getId();
    }

    public void setId(String id) {
        ModelHelper.resetId(this.modelObject, id);
    }

    public String getTypeId() {
        return this.modelObject.getTypeId();
    }

    public String getTitle() {
        return this.modelObject.getTitle();
    }

    public void setTitle(Serializable value) {
        if (value != null) {
            this.getProperties().put((Object)"title", (Object)value);
        } else {
            this.getProperties().delete("title");
        }
    }

    public String getTitleId() {
        return this.modelObject.getTitleId();
    }

    public void setTitleId(Serializable value) {
        if (value != null) {
            this.getProperties().put((Object)"titleId", (Object)value);
        } else {
            this.getProperties().delete("titleId");
        }
    }

    public String getDescription() {
        return this.modelObject.getDescription();
    }

    public String getDescriptionId() {
        return this.modelObject.getDescriptionId();
    }

    public void setDescriptionId(Serializable value) {
        if (value != null) {
            this.getProperties().put((Object)"descriptionId", (Object)value);
        } else {
            this.getProperties().delete("descriptionId");
        }
    }

    public void setDescription(Serializable value) {
        if (value != null) {
            this.getProperties().put((Object)"description", (Object)value);
        } else {
            this.getProperties().delete("description");
        }
    }

    public long getTimestamp() {
        return this.modelObject.getModificationTime();
    }

    public String getPersisterId() {
        return this.modelObject.getPersisterId();
    }

    public String getStoragePath() {
        return this.modelObject.getStoragePath();
    }

    public ScriptResources getResources() {
        return this.resources;
    }

    public void save() {
        for (String propertyName : this.getProperties().keySet()) {
            String propertyValue = (String)this.getProperties().get((Object)propertyName);
            this.modelObject.setProperty(propertyName, propertyValue);
        }
        this.getObjectService().saveObject(this.modelObject);
    }

    public void remove() {
        this.getObjectService().removeObject(this.modelObject);
    }

    public void delete() {
        this.remove();
    }

    public String toXML() {
        return this.modelObject.toXML();
    }

    public void touch() {
        this.modelObject.touch();
        this.properties = null;
    }

    public boolean getBooleanProperty(String propertyName) {
        ParameterCheck.mandatory((String)"propertyName", (Object)propertyName);
        return this.modelObject.getBooleanProperty(propertyName);
    }

    public String getProperty(String propertyName) {
        ParameterCheck.mandatory((String)"propertyName", (Object)propertyName);
        return (String)this.getProperties().get((Object)propertyName);
    }

    public void setProperty(String propertyName, String propertyValue) {
        ParameterCheck.mandatory((String)"propertyName", (Object)propertyName);
        ParameterCheck.mandatory((String)"propertyValue", (Object)propertyValue);
        this.getProperties().put((Object)propertyName, (Object)propertyValue);
    }

    public void removeProperty(String propertyName) {
        ParameterCheck.mandatory((String)"propertyName", (Object)propertyName);
        this.getProperties().remove((Object)propertyName);
    }

    public ModelObject getModelObject() {
        return this.modelObject;
    }

    public ScriptModelObject clone() {
        String objectTypeId = this.getModelObject().getTypeId();
        String objectId = this.getModelObject().getId();
        ModelObject obj = this.getObjectService().clone(objectTypeId, objectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }

    public ScriptModelObject clone(String newObjectId) {
        ParameterCheck.mandatory((String)"newObjectId", (Object)newObjectId);
        String objectTypeId = this.getModelObject().getTypeId();
        String objectId = this.getModelObject().getId();
        ModelObject obj = this.getObjectService().clone(objectTypeId, objectId, newObjectId);
        return ScriptHelper.toScriptModelObject(this.context, obj);
    }
}

