/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.resource.ResourceProvider;
import org.springframework.extensions.webscripts.ScriptBase;
import org.springframework.extensions.webscripts.ScriptResource;
import org.springframework.extensions.webscripts.ScriptableLinkedHashMap;
import org.springframework.extensions.webscripts.ScriptableMap;

public final class ScriptResources
extends ScriptBase {
    private static final long serialVersionUID = -3378946227712931201L;
    private final ModelObject modelObject;

    public ScriptResources(RequestContext context, ModelObject modelObject) {
        super(context);
        this.modelObject = modelObject;
    }

    protected ScriptableMap buildProperties() {
        if (this.properties == null) {
            this.properties = new ScriptableLinkedHashMap<String, Serializable>(){};
            String[] resourceNames = this.getNames();
            for (int i = 0; i < resourceNames.length; ++i) {
                ScriptResource scriptResource = this.get(resourceNames[i]);
                this.properties.put((Object)resourceNames[i], (Object)scriptResource);
            }
        }
        return this.properties;
    }

    public ModelObject getModelObject() {
        return this.modelObject;
    }

    public ScriptResource get(String name) {
        ResourceProvider provider;
        Resource resource;
        ScriptResource scriptResource = null;
        if (this.modelObject instanceof ResourceProvider && (resource = (provider = (ResourceProvider)((Object)this.modelObject)).getResource(name)) != null) {
            scriptResource = new ScriptResource(this.context, resource);
        }
        return scriptResource;
    }

    public void remove(String name) {
        if (this.modelObject instanceof ResourceProvider) {
            ResourceProvider provider = (ResourceProvider)((Object)this.modelObject);
            provider.removeResource(name);
            this.properties.remove((Object)name);
        }
    }

    public ScriptResource add(String name, String resourceId) {
        ResourceProvider provider;
        Resource resource;
        ScriptResource scriptResource = null;
        if (this.modelObject instanceof ResourceProvider && (resource = (provider = (ResourceProvider)((Object)this.modelObject)).addResource(name, resourceId)) != null) {
            scriptResource = new ScriptResource(this.context, resource);
            this.properties.put((Object)name, (Object)scriptResource);
        }
        return scriptResource;
    }

    public ScriptResource add(String name, String protocolId, String endpointId, String objectId) {
        ResourceProvider provider;
        Resource resource;
        ScriptResource scriptResource = null;
        if (this.modelObject instanceof ResourceProvider && (resource = (provider = (ResourceProvider)((Object)this.modelObject)).addResource(name, protocolId, endpointId, objectId)) != null) {
            scriptResource = new ScriptResource(this.context, resource);
            this.properties.put((Object)name, (Object)scriptResource);
        }
        return scriptResource;
    }

    public String[] getNames() {
        ResourceProvider provider;
        Resource[] array;
        String[] names = new String[]{};
        if (this.modelObject instanceof ResourceProvider && (array = (provider = (ResourceProvider)((Object)this.modelObject)).getResources()).length > 0) {
            names = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                names[i] = array[i].getName();
            }
        }
        return names;
    }
}

