/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;

final class GJYearOfEraDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = -5961050944769862059L;
    private final BasicChronology iChronology;

    GJYearOfEraDateTimeField(DateTimeField yearField, BasicChronology chronology) {
        super(yearField, DateTimeFieldType.yearOfEra());
        this.iChronology = chronology;
    }

    public int get(long instant) {
        int year = this.getWrappedField().get(instant);
        if (year <= 0) {
            year = 1 - year;
        }
        return year;
    }

    public long add(long instant, int years) {
        return this.getWrappedField().add(instant, years);
    }

    public long add(long instant, long years) {
        return this.getWrappedField().add(instant, years);
    }

    public long addWrapField(long instant, int years) {
        return this.getWrappedField().addWrapField(instant, years);
    }

    public int[] addWrapField(ReadablePartial instant, int fieldIndex, int[] values, int years) {
        return this.getWrappedField().addWrapField(instant, fieldIndex, values, years);
    }

    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifference(minuendInstant, subtrahendInstant);
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifferenceAsLong(minuendInstant, subtrahendInstant);
    }

    public long set(long instant, int year) {
        FieldUtils.verifyValueBounds(this, year, 1, this.getMaximumValue());
        if (this.iChronology.getYear(instant) <= 0) {
            year = 1 - year;
        }
        return super.set(instant, year);
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return this.getWrappedField().getMaximumValue();
    }

    public long roundFloor(long instant) {
        return this.getWrappedField().roundFloor(instant);
    }

    public long roundCeiling(long instant) {
        return this.getWrappedField().roundCeiling(instant);
    }

    public long remainder(long instant) {
        return this.getWrappedField().remainder(instant);
    }

    private Object readResolve() {
        return this.iChronology.yearOfEra();
    }
}

