/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.reference;

import java.util.Map;
import org.alfresco.cmis.CMISObjectReference;
import org.alfresco.cmis.CMISRelationshipReference;
import org.alfresco.cmis.CMISRepositoryReference;
import org.alfresco.cmis.CMISServices;
import org.alfresco.repo.cmis.reference.AVMPathReference;
import org.alfresco.repo.cmis.reference.AssociationIdRelationshipReference;
import org.alfresco.repo.cmis.reference.DefaultRepositoryReference;
import org.alfresco.repo.cmis.reference.NodeIdReference;
import org.alfresco.repo.cmis.reference.NodePathReference;
import org.alfresco.repo.cmis.reference.ObjectIdReference;
import org.alfresco.repo.cmis.reference.ObjectPathReference;
import org.alfresco.repo.cmis.reference.StoreRepositoryReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceFactory {
    private CMISServices cmisService;

    public void setCMISService(CMISServices cmisService) {
        this.cmisService = cmisService;
    }

    public CMISRepositoryReference createRepoReferenceFromUrl(Map<String, String> args, Map<String, String> templateArgs) {
        String store_type = templateArgs.get("store_type");
        String store_id = templateArgs.get("store_id");
        if (store_type != null && store_id != null) {
            return new StoreRepositoryReference(this.cmisService, store_type + ":" + store_id);
        }
        String store = templateArgs.get("store");
        if (store != null) {
            return new StoreRepositoryReference(this.cmisService, store);
        }
        return new DefaultRepositoryReference(this.cmisService);
    }

    public CMISObjectReference createObjectReferenceFromUrl(Map<String, String> args, Map<String, String> templateArgs) {
        String objectId = args.get("noderef");
        if (objectId != null) {
            return new ObjectIdReference(this.cmisService, objectId);
        }
        CMISRepositoryReference repo = this.createRepoReferenceFromUrl(args, templateArgs);
        String id = templateArgs.get("id");
        if (id != null) {
            return new NodeIdReference(this.cmisService, repo, id);
        }
        String path = templateArgs.get("path");
        if (path == null) {
            path = args.get("path");
        }
        if (path != null) {
            return new ObjectPathReference(this.cmisService, repo, path);
        }
        String nodepath = templateArgs.get("nodepath");
        if (nodepath == null) {
            nodepath = args.get("nodepath");
        }
        if (nodepath != null) {
            return new NodePathReference(this.cmisService, repo, nodepath);
        }
        String avmPath = templateArgs.get("avmpath");
        if (avmPath != null) {
            return new AVMPathReference(this.cmisService, repo, avmPath);
        }
        return null;
    }

    public CMISRelationshipReference createRelationshipReferenceFromUrl(Map<String, String> args, Map<String, String> templateArgs) {
        String assocId = templateArgs.get("assoc_id");
        if (assocId != null) {
            return new AssociationIdRelationshipReference(this.cmisService, assocId);
        }
        return null;
    }
}

