/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest;

import freemarker.ext.beans.BeanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.List;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.cmis.CMISTypesFilterEnum;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.web.scripts.RepositoryImageResolver;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.springframework.extensions.webscripts.WebScriptException;

public class CMISChildrenMethod
implements TemplateMethodModelEx {
    private CMISServices cmisService;
    private ServiceRegistry serviceRegistry;
    private TemplateImageResolver imageResolver;

    public CMISChildrenMethod(CMISServices cmisService, ServiceRegistry serviceRegistry, RepositoryImageResolver imageResolver) {
        this.cmisService = cmisService;
        this.serviceRegistry = serviceRegistry;
        this.imageResolver = imageResolver.getImageResolver();
    }

    public Object exec(List args) throws TemplateModelException {
        Object wrapped;
        Object arg0;
        TemplateNode[] children = null;
        if (args.size() > 0 && (arg0 = args.get(0)) instanceof BeanModel && (wrapped = ((BeanModel)arg0).getWrappedObject()) != null && wrapped instanceof TemplateNode) {
            NodeRef[] childNodeRefs;
            String typesFilterStr;
            Object arg1;
            NodeRef nodeRef = ((TemplateNode)wrapped).getNodeRef();
            CMISTypesFilterEnum typesFilter = CMISTypesFilterEnum.ANY;
            if (args.size() > 1 && (arg1 = args.get(1)) instanceof TemplateScalarModel && (typesFilterStr = ((TemplateScalarModel)arg1).getAsString()) != null && typesFilterStr.length() > 0) {
                typesFilter = (CMISTypesFilterEnum)CMISTypesFilterEnum.FACTORY.toEnum(typesFilterStr);
            }
            try {
                childNodeRefs = this.cmisService.getChildren(nodeRef, typesFilter, null);
            }
            catch (CMISInvalidArgumentException e) {
                throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
            }
            children = new TemplateNode[childNodeRefs.length];
            for (int i = 0; i < childNodeRefs.length; ++i) {
                children[i] = new TemplateNode(childNodeRefs[i], this.serviceRegistry, this.imageResolver);
            }
        }
        return children;
    }
}

