/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest.test;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.alfresco.repo.cmis.rest.AlfrescoCMISExtensionFactory;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.ExtensionFactory;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Service;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.chemistry.tck.atompub.client.CMISClient;
import org.apache.chemistry.tck.atompub.utils.ResourceLoader;
import org.junit.Assert;
import org.springframework.extensions.webscripts.TestWebScriptServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCMISTest
extends BaseWebScriptTest {
    protected static final QName ELEMENT_PROPERTIES = new QName("http://www.alfresco.org", "properties");
    protected static final QName ELEMENT_APPLIED_ASPECTS = new QName("http://www.alfresco.org", "appliedAspects");
    protected static final String URL_CMIS = "/cmis";
    protected Abdera abdera = new Abdera();
    protected Parser parser;
    protected Factory factory = this.abdera.getFactory();
    protected CMISClient cmisClient;
    protected ResourceLoader localTemplates;
    protected Service cmisService;
    protected Entry testCaseFolder;

    public BaseCMISTest() {
        this.factory.registerExtension((ExtensionFactory)new AlfrescoCMISExtensionFactory());
        this.parser = this.factory.newParser();
        this.localTemplates = new ResourceLoader('/' + ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + '/');
        this.cmisClient = new CMISClient(null, null, null, null);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setDefaultRunAs("admin");
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(URL_CMIS);
        TestWebScriptServer.Response res = this.sendRequest((TestWebScriptServer.Request)req, 200);
        String xml = res.getContentAsString();
        Assert.assertNotNull((Object)xml);
        Assert.assertTrue((xml.length() > 0 ? 1 : 0) != 0);
        this.cmisService = (Service)this.parse(new StringReader(xml));
        Assert.assertNotNull((Object)this.cmisService);
        IRI rootFolderHREF = this.cmisClient.getRootCollection(this.cmisClient.getWorkspace(this.cmisService));
        Assert.assertNotNull((Object)rootFolderHREF);
        String folderName = ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis() + " - " + this.getName();
        this.testCaseFolder = this.createObject(rootFolderHREF, folderName, "cmis:folder");
    }

    protected <T extends Element> T parse(Reader doc) {
        Document entryDoc = this.parser.parse(doc);
        return (T)entryDoc.getRoot();
    }

    protected <T extends Element> T fetch(IRI href, Map<String, String> args) throws Exception {
        TestWebScriptServer.Request get = new TestWebScriptServer.GetRequest(href.toString()).setArgs(args);
        TestWebScriptServer.Response res = this.sendRequest(get, 200);
        Assert.assertNotNull((Object)res);
        String xml = res.getContentAsString();
        T result = this.parse(new StringReader(xml));
        Assert.assertNotNull(result);
        return result;
    }

    protected Entry createObject(IRI parent, String name, String type) throws Exception {
        return (Entry)this.createObject(parent, name, type, 201);
    }

    protected <T extends Element> T createObject(IRI parent, String name, String type, int expectedStatus) throws Exception {
        String createObject = this.localTemplates.load("BaseCMISTest.createObject.atomentry.xml");
        createObject = createObject.replace("${NAME}", name);
        createObject = createObject.replace("${TYPE}", type);
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(parent.toString(), createObject, "application/atom+xml;type=entry");
        TestWebScriptServer.Response res = this.sendRequest((TestWebScriptServer.Request)req, expectedStatus);
        Assert.assertNotNull((Object)res);
        try {
            String xml = res.getContentAsString();
            return this.parse(new StringReader(xml));
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected void assertContains(Set<String> actual, String ... expected) {
        Assert.assertTrue((boolean)actual.containsAll(Arrays.asList(expected)));
    }

    protected void assertDoesNotContain(Set<String> actual, String ... unexpected) {
        HashSet<String> copy = new HashSet<String>(actual);
        copy.retainAll(Arrays.asList(unexpected));
        Assert.assertTrue((boolean)copy.isEmpty());
    }
}

