/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.activation.DataSource;
import org.alfresco.service.cmr.repository.ContentReader;

public class ContentReaderDataSource
implements DataSource {
    private String mimetype;
    private InputStream inputStream;
    private String name;
    private long offset = 0L;
    private long length = 0x3FFFFFFFFFFFFFFFL;
    private long sizeToRead = 0L;

    public ContentReaderDataSource(ContentReader contentReader, String name, BigInteger offset, BigInteger length, long contentSize) {
        this.createContentReaderDataSource(contentReader.getContentInputStream(), contentReader.getMimetype(), name, offset, length, contentSize);
    }

    public ContentReaderDataSource(InputStream contentInputStream, String mimeType, String name, BigInteger offset, BigInteger length) {
        try {
            this.createContentReaderDataSource(contentInputStream, mimeType, name, offset, length, contentInputStream.available());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void createContentReaderDataSource(InputStream contentInputStream, String mimeType, String name, BigInteger offset, BigInteger length, long contentSize) {
        this.name = name;
        this.mimetype = mimeType;
        if (offset != null) {
            this.offset = offset.longValue();
        }
        if (length != null) {
            this.length = length.longValue();
        }
        this.sizeToRead = this.offset + this.length < contentSize ? this.length : contentSize - this.offset;
        if (this.sizeToRead < 0L) {
            throw new RuntimeException("Offset value exceeds content size");
        }
        try {
            this.inputStream = new RangedInputStream(contentInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getContentType() {
        return this.mimetype;
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public long getSizeToRead() {
        return this.sizeToRead;
    }

    private class RangedInputStream
    extends InputStream {
        private InputStream inputStream;
        private int bytesread;

        private RangedInputStream(InputStream inputStream) throws IOException {
            this.inputStream = inputStream;
            this.inputStream.skip(ContentReaderDataSource.this.offset);
            this.bytesread = 0;
        }

        public int read() throws IOException {
            if ((long)this.bytesread < ContentReaderDataSource.this.sizeToRead) {
                ++this.bytesread;
                return this.inputStream.read();
            }
            return -1;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if ((long)len > ContentReaderDataSource.this.sizeToRead - (long)this.bytesread) {
                len = (int)(ContentReaderDataSource.this.sizeToRead - (long)this.bytesread);
            }
            int readed = this.inputStream.read(b, off, len);
            this.bytesread += readed;
            return readed;
        }

        public int available() throws IOException {
            return (int)(ContentReaderDataSource.this.sizeToRead - (long)this.bytesread + 1L);
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public long skip(long n) throws IOException {
            if ((long)this.bytesread + n > ContentReaderDataSource.this.sizeToRead) {
                n = ContentReaderDataSource.this.sizeToRead - n > 0L ? ContentReaderDataSource.this.sizeToRead - n : ContentReaderDataSource.this.sizeToRead - (long)this.bytesread;
            }
            n = this.inputStream.skip(n);
            this.bytesread = (int)((long)this.bytesread + n);
            return n;
        }
    }
}

