/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import javax.jws.WebService;
import org.alfresco.cmis.CMISAccessControlFormatEnum;
import org.alfresco.cmis.CMISAccessControlReport;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.repo.cmis.ws.ACLServicePort;
import org.alfresco.repo.cmis.ws.CmisACLType;
import org.alfresco.repo.cmis.ws.CmisAccessControlListType;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.DMAbstractServicePort;
import org.alfresco.repo.cmis.ws.EnumACLPropagation;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;
import org.alfresco.service.cmr.repository.NodeRef;

@WebService(name="ACLServicePort", serviceName="ACLService", portName="ACLServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", endpointInterface="org.alfresco.repo.cmis.ws.ACLServicePort")
public class DMAclServicePort
extends DMAbstractServicePort
implements ACLServicePort {
    public CmisACLType applyACL(String repositoryId, String objectId, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, EnumACLPropagation aclPropagation, CmisExtensionType extension) throws CmisException {
        NodeRef object;
        this.checkRepositoryId(repositoryId);
        try {
            object = (NodeRef)this.cmisService.getObject(objectId, NodeRef.class, true, false, false);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        return this.applyAclCarefully(object, addACEs, removeACEs, aclPropagation, null);
    }

    public CmisACLType getACL(String repositoryId, String objectId, Boolean onlyBasicPermissions, CmisExtensionType extension) throws CmisException {
        NodeRef nodeRef;
        this.checkRepositoryId(repositoryId);
        try {
            nodeRef = (NodeRef)this.cmisService.getReadableObject(objectId, NodeRef.class);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        CMISAccessControlFormatEnum permissionsKind = null == onlyBasicPermissions || onlyBasicPermissions != false ? CMISAccessControlFormatEnum.CMIS_BASIC_PERMISSIONS : CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS;
        CMISAccessControlReport aclReport = this.cmisAclService.getAcl(nodeRef, permissionsKind);
        return this.convertAclReportToCmisAclType(aclReport);
    }
}

