/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebService;
import org.alfresco.cmis.CMISRelationshipDirectionEnum;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.PropertyFilter;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.CmisObjectListType;
import org.alfresco.repo.cmis.ws.DMAbstractServicePort;
import org.alfresco.repo.cmis.ws.EnumIncludeRelationships;
import org.alfresco.repo.cmis.ws.EnumRelationshipDirection;
import org.alfresco.repo.cmis.ws.EnumServiceException;
import org.alfresco.repo.cmis.ws.RelationshipServicePort;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.service.cmr.repository.NodeRef;

@WebService(name="RelationshipServicePort", serviceName="RelationshipService", portName="RelationshipServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", endpointInterface="org.alfresco.repo.cmis.ws.RelationshipServicePort")
public class DMRelationshipServicePort
extends DMAbstractServicePort
implements RelationshipServicePort {
    private static final Map<EnumRelationshipDirection, CMISRelationshipDirectionEnum> RELATIONSHIP_DIRECTION_MAPPING = new HashMap<EnumRelationshipDirection, CMISRelationshipDirectionEnum>(5);

    public CmisObjectListType getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, EnumRelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        if (null == objectId || "".equals(objectId) || !NodeRef.isNodeRef((String)objectId)) {
            throw ExceptionUtil.createCmisException("Object with Id='" + objectId + "' is not exist!", EnumServiceException.OBJECT_NOT_FOUND);
        }
        try {
            CMISTypeDefinition relDef = null != typeId ? this.cmisService.getTypeDefinition(typeId) : null;
            NodeRef nodeRef = (NodeRef)this.cmisService.getReadableObject(objectId, NodeRef.class);
            Object[] assocs = this.cmisService.getRelationships(nodeRef, relDef, includeSubRelationshipTypes != null && includeSubRelationshipTypes != false, relationshipDirection == null ? CMISRelationshipDirectionEnum.SOURCE : RELATIONSHIP_DIRECTION_MAPPING.get((Object)relationshipDirection));
            skipCount = null != skipCount ? skipCount : BigInteger.ZERO;
            maxItems = null != maxItems ? maxItems : BigInteger.ZERO;
            PropertyFilter propertyFilter = this.createPropertyFilter(filter);
            return this.createResult(propertyFilter, includeAllowableActions, assocs, skipCount, maxItems);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    private CmisObjectListType createResult(PropertyFilter filter, Boolean includeAllowableActions, Object[] sourceArray, BigInteger skipCount, BigInteger maxItems) throws CmisException {
        Cursor cursor = this.createCursor(sourceArray.length, skipCount, maxItems);
        CmisObjectListType result = new CmisObjectListType();
        for (int i = cursor.getStartRow(); i <= cursor.getEndRow(); ++i) {
            result.getObjects().add(this.createCmisObject(sourceArray[i], filter, (EnumIncludeRelationships)null, includeAllowableActions, (String)null));
        }
        result.setHasMoreItems(cursor.getEndRow() < sourceArray.length);
        result.setNumItems(BigInteger.valueOf(cursor.getPageSize()));
        return result;
    }

    static {
        RELATIONSHIP_DIRECTION_MAPPING.put(EnumRelationshipDirection.SOURCE, CMISRelationshipDirectionEnum.SOURCE);
        RELATIONSHIP_DIRECTION_MAPPING.put(EnumRelationshipDirection.TARGET, CMISRelationshipDirectionEnum.TARGET);
        RELATIONSHIP_DIRECTION_MAPPING.put(EnumRelationshipDirection.EITHER, CMISRelationshipDirectionEnum.BOTH);
    }
}

