/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.alfresco.service.cmr.repository.FileTypeImageSize;

public class FileTypeImageUtils {
    private static final String IMAGE_PREFIX16 = "/images/filetypes/";
    private static final String IMAGE_PREFIX32 = "/images/filetypes32/";
    private static final String IMAGE_PREFIX64 = "/images/filetypes64/";
    private static final String IMAGE_POSTFIX_GIF = ".gif";
    private static final String IMAGE_POSTFIX_PNG = ".png";
    private static final String DEFAULT_FILE_IMAGE16 = "/images/filetypes/_default.gif";
    private static final String DEFAULT_FILE_IMAGE32 = "/images/filetypes32/_default.gif";
    private static final String DEFAULT_FILE_IMAGE64 = "/images/filetypes64/_default.png";
    private static final Map<String, String> s_fileExtensionMap = new HashMap<String, String>(89, 1.0f);

    public static String getFileTypeImage(String name, boolean small) {
        return FileTypeImageUtils.getFileTypeImage(FacesContext.getCurrentInstance(), null, name, small ? FileTypeImageSize.Small : FileTypeImageSize.Medium);
    }

    public static String getFileTypeImage(FacesContext fc, String name, boolean small) {
        return FileTypeImageUtils.getFileTypeImage(fc, null, name, small ? FileTypeImageSize.Small : FileTypeImageSize.Medium);
    }

    public static String getFileTypeImage(FacesContext fc, String name, FileTypeImageSize size) {
        return FileTypeImageUtils.getFileTypeImage(fc, null, name, size);
    }

    public static String getFileTypeImage(ServletContext sc, String name, boolean small) {
        return FileTypeImageUtils.getFileTypeImage(null, sc, name, small ? FileTypeImageSize.Small : FileTypeImageSize.Medium);
    }

    public static String getFileTypeImage(ServletContext sc, String name, FileTypeImageSize size) {
        return FileTypeImageUtils.getFileTypeImage(null, sc, name, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileTypeImage(FacesContext fc, ServletContext sc, String name, FileTypeImageSize size) {
        String image = null;
        String defaultImage = null;
        switch (size) {
            case Small: {
                defaultImage = DEFAULT_FILE_IMAGE16;
                break;
            }
            case Medium: {
                defaultImage = DEFAULT_FILE_IMAGE32;
                break;
            }
            case Large: {
                defaultImage = DEFAULT_FILE_IMAGE64;
            }
        }
        int extIndex = name.lastIndexOf(46);
        if (extIndex != -1 && name.length() > extIndex + 1) {
            String ext = name.substring(extIndex + 1).toLowerCase();
            String key = ext + ' ' + size.toString();
            Map<String, String> map = s_fileExtensionMap;
            synchronized (map) {
                image = s_fileExtensionMap.get(key);
                if (image == null) {
                    image = size != FileTypeImageSize.Large ? (size == FileTypeImageSize.Small ? IMAGE_PREFIX16 : IMAGE_PREFIX32) + ext + IMAGE_POSTFIX_GIF : IMAGE_PREFIX64 + ext + IMAGE_POSTFIX_PNG;
                    if (fc != null && fc.getExternalContext().getResourceAsStream(image) != null || sc != null && sc.getResourceAsStream(image) != null) {
                        s_fileExtensionMap.put(key, image);
                    } else if (fc == null && sc == null) {
                        image = defaultImage;
                    } else {
                        s_fileExtensionMap.put(key, defaultImage);
                        image = defaultImage;
                    }
                }
            }
        }
        return image != null ? image : defaultImage;
    }
}

