/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.activities.feed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.util.JSONtoFmModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserFeedRetrieverWebScript
extends DeclarativeWebScript {
    private static final Log logger = LogFactory.getLog(UserFeedRetrieverWebScript.class);
    public static final String PARAM_SITE_ID = "s";
    public static final String PARAM_EXCLUDE_THIS_USER = "exclUser";
    public static final String PARAM_EXCLUDE_OTHER_USERS = "exclOthers";
    private ActivityService activityService;
    private AuthorityService authorityService;

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        HashMap<String, Object> model;
        block14: {
            String extensionPath;
            String format = req.getFormat();
            if (format == null || format.length() == 0) {
                format = this.getDescription().getDefaultFormat();
            }
            String[] extParts = (extensionPath = req.getExtensionPath()) == null ? new String[1] : extensionPath.split("/");
            String feedUserId = null;
            if (extParts.length == 1) {
                feedUserId = extParts[0];
            } else if (extParts.length > 1) {
                throw new AlfrescoRuntimeException("Unexpected extension: " + extensionPath);
            }
            String siteId = req.getParameter(PARAM_SITE_ID);
            String exclThisUserStr = req.getParameter(PARAM_EXCLUDE_THIS_USER);
            String exclOtherUsersStr = req.getParameter(PARAM_EXCLUDE_OTHER_USERS);
            boolean exclThisUser = false;
            if (exclThisUserStr != null && (exclThisUserStr.equalsIgnoreCase("true") || exclThisUserStr.equalsIgnoreCase("t"))) {
                exclThisUser = true;
            }
            boolean exclOtherUsers = false;
            if (exclOtherUsersStr != null && (exclOtherUsersStr.equalsIgnoreCase("true") || exclOtherUsersStr.equalsIgnoreCase("t"))) {
                exclOtherUsers = true;
            }
            if (feedUserId == null || feedUserId.length() == 0) {
                feedUserId = AuthenticationUtil.getFullyAuthenticatedUser();
            }
            if (format.equals("atomfeed") || format.equals("atom")) {
                format = "atomentry";
            }
            model = new HashMap<String, Object>();
            try {
                List feedEntries = this.activityService.getUserFeedEntries(feedUserId, format, siteId, exclThisUser, exclOtherUsers);
                if (format.equals("json")) {
                    model.put("feedEntries", feedEntries);
                    model.put("siteId", siteId);
                    break block14;
                }
                ArrayList<Map> activityFeedModels = new ArrayList<Map>();
                try {
                    for (String feedEntry : feedEntries) {
                        activityFeedModels.add(JSONtoFmModel.convertJSONObjectToMap((String)feedEntry));
                    }
                }
                catch (JSONException je) {
                    throw new AlfrescoRuntimeException("Unable to get user feed entries: " + je.getMessage());
                }
                model.put("feedEntries", activityFeedModels);
                model.put("feedUserId", feedUserId);
            }
            catch (AccessDeniedException ade) {
                status.setCode(401);
                logger.warn((Object)("Unable to get user feed entries for '" + feedUserId + "' - currently logged in as '" + AuthenticationUtil.getFullyAuthenticatedUser() + "'"));
                return null;
            }
        }
        return model;
    }
}

