/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.SocketException;
import java.util.SortedMap;
import java.util.StringTokenizer;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.bean.BaseRemoteStore;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.search.SearchService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class AVMRemoteStore
extends BaseRemoteStore {
    private static final Log logger = LogFactory.getLog(AVMRemoteStore.class);
    private String rootPath = "/";
    private AVMService avmService;
    private SearchService searchService;
    private static final String[] hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};

    public void setRootPath(String rootPath) {
        if (rootPath == null || rootPath.length() == 0) {
            throw new IllegalArgumentException("Root path must be specified.");
        }
        this.rootPath = rootPath;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    protected void lastModified(WebScriptResponse res, String store, String path) throws IOException {
        String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor desc = this.avmService.lookup(-1, avmPath);
        if (desc == null) {
            throw new WebScriptException("Unable to locate AVM file: " + avmPath);
        }
        Writer out = res.getWriter();
        out.write(Long.toString(desc.getModDate()));
        out.close();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AVMRemoteStore.lastModified() " + Long.toString(desc.getModDate())));
        }
    }

    protected void getDocument(final WebScriptResponse res, String store, final String path) throws IOException {
        final String avmPath = this.buildAVMPath(store, path);
        final AVMNodeDescriptor desc = this.avmService.lookup(-1, avmPath);
        if (desc == null) {
            res.setStatus(404);
            return;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                try {
                    ContentReader reader = AVMRemoteStore.this.avmService.getContentReader(-1, avmPath);
                    if (reader == null) {
                        throw new WebScriptException("No content found for AVM file: " + avmPath);
                    }
                    String mimetype = reader.getMimetype();
                    if (mimetype == null || mimetype.length() == 0) {
                        mimetype = "application/octet-stream";
                        int extIndex = path.lastIndexOf(46);
                        if (extIndex != -1) {
                            String ext = path.substring(extIndex + 1);
                            mimetype = AVMRemoteStore.this.mimetypeService.getMimetype(ext);
                        }
                    }
                    res.setContentType(mimetype);
                    res.setContentEncoding(reader.getEncoding());
                    res.setHeader("Last-Modified", Long.toString(desc.getModDate()));
                    res.setHeader("Content-Length", Long.toString(reader.getSize()));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AVMRemoteStore.getDocument() " + mimetype + " of size: " + reader.getSize()));
                    }
                    try {
                        reader.getContent(res.getOutputStream());
                    }
                    catch (SocketException e1) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Client aborted stream read:\n\tnode: " + avmPath + "\n\tcontent: " + reader));
                        }
                    }
                    catch (ContentIOException e2) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Client aborted stream read:\n\tnode: " + avmPath + "\n\tcontent: " + reader));
                        }
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                catch (AVMNotFoundException avmErr) {
                    res.setStatus(404);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    protected void hasDocument(WebScriptResponse res, String store, String path) throws IOException {
        String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor desc = this.avmService.lookup(-1, avmPath);
        Writer out = res.getWriter();
        out.write(Boolean.toString(desc != null));
        out.close();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AVMRemoteStore.hasDocument() " + Boolean.toString(desc != null)));
        }
    }

    protected void createDocument(final WebScriptResponse res, final String store, final String path, final InputStream content) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                String avmPath = AVMRemoteStore.this.buildAVMPath(store, path);
                try {
                    String[] parts = AVMNodeConverter.SplitBase((String)avmPath);
                    String[] dirs = parts[0].split("/");
                    String parentPath = dirs[0] + "/" + dirs[1];
                    for (int index = 2; index < dirs.length; ++index) {
                        String dirPath = parentPath + "/" + dirs[index];
                        if (AVMRemoteStore.this.avmService.lookup(-1, dirPath) == null) {
                            AVMRemoteStore.this.avmService.createDirectory(parentPath, dirs[index]);
                        }
                        parentPath = dirPath;
                    }
                    AVMRemoteStore.this.avmService.createFile(parts[0], parts[1], content);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AVMRemoteStore.createDocument() " + avmPath + " of size: " + AVMRemoteStore.this.avmService.lookup(-1, avmPath).getLength()));
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                catch (AVMExistsException avmErr) {
                    res.setStatus(409);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    protected void updateDocument(final WebScriptResponse res, String store, String path, final InputStream content) {
        final String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor desc = this.avmService.lookup(-1, avmPath);
        if (desc == null) {
            res.setStatus(404);
            return;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                try {
                    ContentWriter writer = AVMRemoteStore.this.avmService.getContentWriter(avmPath, true);
                    writer.putContent(content);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AVMRemoteStore.updateDocument() " + avmPath + " of size: " + AVMRemoteStore.this.avmService.lookup(-1, avmPath).getLength()));
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    protected void deleteDocument(final WebScriptResponse res, String store, String path) {
        final String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor desc = this.avmService.lookup(-1, avmPath);
        if (desc == null) {
            res.setStatus(404);
            return;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                try {
                    AVMRemoteStore.this.avmService.removeNode(avmPath);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AVMRemoteStore.deleteDocument() " + avmPath));
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listDocuments(WebScriptResponse res, String store, String path, boolean recurse) throws IOException {
        String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor node = this.avmService.lookup(-1, avmPath);
        if (node == null) {
            res.setStatus(404);
            return;
        }
        try {
            this.traverseNode(res.getWriter(), store, node, recurse);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AVMRemoteStore.listDocuments() " + path + " Recursive: " + recurse));
            }
        }
        catch (AccessDeniedException ae) {
            res.setStatus(401);
        }
        finally {
            res.getWriter().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listDocuments(WebScriptResponse res, String store, String path, String pattern) throws IOException {
        String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor node = this.avmService.lookup(-1, avmPath);
        if (node == null) {
            res.setStatus(404);
            return;
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "*";
        }
        try {
            Writer out = res.getWriter();
            int cropPoint = store.length() + this.rootPath.length() + 1;
            StringBuilder buf = new StringBuilder(pattern.length() + 8);
            StringTokenizer t = new StringTokenizer(pattern, "*");
            while (t.hasMoreTokens()) {
                buf.append(AVMRemoteStore.encodePath(t.nextToken()));
                if (!t.hasMoreTokens()) continue;
                buf.append('*');
            }
            String encpattern = buf.toString().replace("\\", "\\\\");
            boolean encoded = encpattern.length() != pattern.length();
            SortedMap listing = this.avmService.getDirectoryListing(node, encpattern);
            for (AVMNodeDescriptor n : listing.values()) {
                if (!n.isFile()) continue;
                String p = n.getPath().substring(cropPoint);
                out.write(encoded ? URLDecoder.decode((String)p) : p);
                out.write("\n");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AVMRemoteStore.listDocuments() " + path + " Pattern: " + pattern));
            }
        }
        catch (AccessDeniedException ae) {
            res.setStatus(401);
        }
        finally {
            res.getWriter().close();
        }
    }

    private String buildAVMPath(String store, String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return store + ":" + this.rootPath + (path != null ? AVMRemoteStore.encodePath(path) : "");
    }

    private void traverseNode(Writer out, String store, AVMNodeDescriptor node, boolean recurse) throws IOException {
        int cropPoint = store.length() + this.rootPath.length() + 1;
        SortedMap listing = this.avmService.getDirectoryListing(node);
        for (AVMNodeDescriptor n : listing.values()) {
            if (n.isFile()) {
                out.write(n.getPath().substring(cropPoint));
                out.write("\n");
                continue;
            }
            if (!recurse || !n.isDirectory()) continue;
            this.traverseNode(out, store, n, recurse);
        }
    }

    private static String encodePath(String s) {
        StringBuilder sb = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            String soFar;
            char ch = s.charAt(i);
            if ('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '/' || ch == '\'' || ch == ' ' || ch == '.' || ch == '~' || ch == '-' || ch == '_' || ch == '@' || ch == '!' || ch == '(' || ch == ')' || ch == ';' || ch == ',' || ch == '+' || ch == '$') {
                if (sb == null) continue;
                sb.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                if (sb == null) {
                    soFar = s.substring(0, i);
                    sb = new StringBuilder(len + 16);
                    sb.append(soFar);
                }
                sb.append(hex[ch]);
                continue;
            }
            if (ch <= '\u07ff') {
                if (sb == null) {
                    soFar = s.substring(0, i);
                    sb = new StringBuilder(len + 16);
                    sb.append(soFar);
                }
                sb.append(hex[0xC0 | ch >> 6]);
                sb.append(hex[0x80 | ch & 0x3F]);
                continue;
            }
            if (sb == null) {
                soFar = s.substring(0, i);
                sb = new StringBuilder(len + 16);
                sb.append(soFar);
            }
            sb.append(hex[0xE0 | ch >> 12]);
            sb.append(hex[0x80 | ch >> 6 & 0x3F]);
            sb.append(hex[0x80 | ch & 0x3F]);
        }
        return sb != null ? sb.toString() : s;
    }
}

