/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginTicket
extends DeclarativeWebScript {
    private TicketComponent ticketComponent;

    public void setTicketComponent(TicketComponent ticketComponent) {
        this.ticketComponent = ticketComponent;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        String ticket = req.getExtensionPath();
        if (ticket == null && ticket.length() == 0) {
            throw new WebScriptException(400, "Ticket not specified");
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("ticket", ticket);
        try {
            String ticketUser = this.ticketComponent.validateTicket(ticket);
            String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
            if (currentUser == null || !currentUser.equals(ticketUser)) {
                status.setRedirect(true);
                status.setCode(404);
                status.setMessage("Ticket not found");
            }
        }
        catch (AuthenticationException e) {
            status.setRedirect(true);
            status.setCode(404);
            status.setMessage("Ticket not found");
        }
        return model;
    }
}

