/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.alfresco.repo.exporter.ACPExportPackageHandler;
import org.alfresco.repo.web.scripts.content.StreamContent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class StreamACP
extends StreamContent {
    private static Log logger = LogFactory.getLog(StreamACP.class);
    protected static final String TEMP_FILE_PREFIX = "export_";
    protected static final String MULTIPART_FORMDATA = "multipart/form-data";
    protected static final String ZIP_EXTENSION = "zip";
    protected static final String PARAM_NODE_REFS = "nodeRefs";
    protected ExporterService exporterService;

    public void setExporterService(ExporterService exporterService) {
        this.exporterService = exporterService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        File tempACPFile = null;
        try {
            NodeRef[] nodeRefs = null;
            String contentType = req.getContentType();
            nodeRefs = MULTIPART_FORMDATA.equals(contentType) ? this.getNodeRefs(req.getParameter(PARAM_NODE_REFS)) : this.getNodeRefs(new JSONObject(new JSONTokener(req.getContent().getContent())));
            ExporterCrawlerParameters params = new ExporterCrawlerParameters();
            params.setCrawlSelf(true);
            params.setCrawlChildNodes(true);
            params.setExportFrom(new Location(nodeRefs));
            tempACPFile = this.createACP(params, "acp", false);
            this.streamContent(req, res, tempACPFile, true, tempACPFile.getName());
        }
        catch (IOException ioe) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)ioe);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        finally {
            if (tempACPFile != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleting temporary archive: " + tempACPFile.getAbsolutePath()));
                }
                tempACPFile.delete();
            }
        }
    }

    protected NodeRef[] getNodeRefs(String nodeRefsParam) {
        if (nodeRefsParam == null) {
            throw new WebScriptException(400, "Mandatory 'nodeRefs' parameter was not provided in form data");
        }
        ArrayList<NodeRef> listNodeRefs = new ArrayList<NodeRef>(8);
        StringTokenizer tokenizer = new StringTokenizer(nodeRefsParam, ",");
        while (tokenizer.hasMoreTokens()) {
            listNodeRefs.add(new NodeRef(tokenizer.nextToken().trim()));
        }
        NodeRef[] nodeRefs = new NodeRef[listNodeRefs.size()];
        nodeRefs = listNodeRefs.toArray(nodeRefs);
        return nodeRefs;
    }

    protected NodeRef[] getNodeRefs(JSONObject json) throws JSONException {
        if (!json.has(PARAM_NODE_REFS)) {
            throw new WebScriptException(400, "Mandatory 'nodeRefs' parameter was not provided in request body");
        }
        NodeRef[] nodeRefs = new NodeRef[]{};
        JSONArray jsonArray = json.getJSONArray(PARAM_NODE_REFS);
        if (jsonArray.length() != 0) {
            nodeRefs = new NodeRef[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                NodeRef nodeRef;
                nodeRefs[i] = nodeRef = new NodeRef(jsonArray.getString(i));
            }
        }
        return nodeRefs;
    }

    protected File createACP(ExporterCrawlerParameters params, String extension, boolean keepFolderStructure) {
        try {
            File dataFile = new File(GUID.generate());
            File contentDir = new File(GUID.generate());
            File acpFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)("." + extension));
            ACPExportPackageHandler handler = new ACPExportPackageHandler((OutputStream)new FileOutputStream(acpFile), dataFile, contentDir, this.mimetypeService);
            handler.setExportAsFolders(keepFolderStructure);
            handler.setNodeService(this.nodeService);
            this.exporterService.exportView((ExportPackageHandler)handler, params, null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created temporary archive: " + acpFile.getAbsolutePath()));
            }
            return acpFile;
        }
        catch (FileNotFoundException fnfe) {
            throw new WebScriptException(500, "Failed to create archive", (Throwable)fnfe);
        }
    }
}

