/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class DiscussionServiceTest
extends BaseWebScriptTest {
    private static Log logger = LogFactory.getLog(DiscussionServiceTest.class);
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private SiteService siteService;
    private static final String USER_ONE = "UserOneThird";
    private static final String USER_TWO = "UserTwoThird";
    private static final String SITE_SHORT_NAME_DISCUSSION = "DiscussionSiteShortNameThree";
    private static final String COMPONENT_DISCUSSION = "discussion";
    private static final String URL_FORUM_POST = "/api/forum/post/site/DiscussionSiteShortNameThree/discussion/";
    private static final String URL_FORUM_POSTS = "/api/forum/site/DiscussionSiteShortNameThree/discussion/posts";
    private List<String> posts = new ArrayList<String>(5);

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_DISCUSSION);
        if (siteInfo == null) {
            this.siteService.createSite("DiscussionSitePreset", SITE_SHORT_NAME_DISCUSSION, "DiscussionSiteTitle", "DiscussionSiteDescription", true);
        }
        this.createUser(USER_ONE, "SiteCollaborator");
        this.createUser(USER_TWO, "SiteCollaborator");
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.siteService.deleteSite(SITE_SHORT_NAME_DISCUSSION);
    }

    private void createUser(String userName, String role) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"FirstName123");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"LastName123");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
        this.siteService.setMembership(SITE_SHORT_NAME_DISCUSSION, userName, role);
    }

    private JSONObject createPost(String title, String content, int expectedStatus) throws Exception {
        JSONObject post = new JSONObject();
        post.put("title", (Object)title);
        post.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_FORUM_POSTS, post.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject item = result.getJSONObject("item");
        this.posts.add(item.getString("name"));
        return item;
    }

    private JSONObject updatePost(String nodeRef, String title, String content, int expectedStatus) throws Exception {
        JSONObject post = new JSONObject();
        post.put("title", (Object)title);
        post.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(this.getPostUrl(nodeRef), post.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    private JSONObject getPost(String name, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_FORUM_POST + name), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result.getJSONObject("item");
        }
        return null;
    }

    private String getRepliesUrl(String nodeRef) {
        return "/api/forum/post/node/" + nodeRef.replace("://", "/") + "/replies";
    }

    private String getPostUrl(String nodeRef) {
        return "/api/forum/post/node/" + nodeRef.replace("://", "/");
    }

    private JSONObject createReply(String nodeRef, String title, String content, int expectedStatus) throws Exception {
        JSONObject reply = new JSONObject();
        reply.put("title", (Object)title);
        reply.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.getRepliesUrl(nodeRef), reply.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    private JSONObject updateComment(String nodeRef, String title, String content, int expectedStatus) throws Exception {
        JSONObject comment = new JSONObject();
        comment.put("title", (Object)title);
        comment.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(this.getPostUrl(nodeRef), comment.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    public void testCreateForumPost() throws Exception {
        String title = "test";
        String content = "test";
        JSONObject item = this.createPost(title, content, 200);
        DiscussionServiceTest.assertEquals((Object)title, (Object)item.get("title"));
        DiscussionServiceTest.assertEquals((Object)content, (Object)item.get("content"));
        this.getPost(item.getString("name"), 200);
    }

    public void testUpdateForumPost() throws Exception {
        String title = "test";
        String content = "test";
        JSONObject item = this.createPost(title, content, 200);
        DiscussionServiceTest.assertEquals((Object)title, (Object)item.get("title"));
        DiscussionServiceTest.assertEquals((Object)content, (Object)item.get("content"));
        DiscussionServiceTest.assertEquals((boolean)false, (boolean)item.getBoolean("isUpdated"));
        this.getPost(item.getString("name"), 200);
        String title2 = "test";
        String content2 = "test";
        item = this.updatePost(item.getString("nodeRef"), title2, content2, 200);
        DiscussionServiceTest.assertEquals((Object)title2, (Object)item.get("title"));
        DiscussionServiceTest.assertEquals((Object)content2, (Object)item.get("content"));
        DiscussionServiceTest.assertEquals((boolean)true, (boolean)item.getBoolean("isUpdated"));
    }

    public void testGetAll() throws Exception {
        String url = URL_FORUM_POSTS;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        DiscussionServiceTest.assertEquals((int)this.posts.size(), (int)result.getInt("total"));
    }

    public void testDeleteToplevelPost() throws Exception {
        JSONObject item = this.createPost("test", "test", 200);
        String name = item.getString("name");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL_FORUM_POST + name), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_FORUM_POST + name), 404);
    }

    public void testAddReply() throws Exception {
        JSONObject item = this.createPost("test", "test", 200);
        String postName = item.getString("name");
        String postNodeRef = item.getString("nodeRef");
        JSONObject reply = this.createReply(postNodeRef, "test", "test", 200);
        String replyNodeRef = reply.getString("nodeRef");
        DiscussionServiceTest.assertEquals((String)"test", (String)reply.getString("title"));
        DiscussionServiceTest.assertEquals((String)"test", (String)reply.getString("content"));
        JSONObject reply2 = this.createReply(replyNodeRef, "test2", "test2", 200);
        DiscussionServiceTest.assertEquals((String)"test2", (String)reply2.getString("title"));
        DiscussionServiceTest.assertEquals((String)"test2", (String)reply2.getString("content"));
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getRepliesUrl(postNodeRef)), 200);
        logger.debug((Object)response.getContentAsString());
        JSONObject result = new JSONObject(response.getContentAsString());
        DiscussionServiceTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        item = this.getPost(postName, 200);
        DiscussionServiceTest.assertEquals((int)2, (int)item.getInt("totalReplyCount"));
        DiscussionServiceTest.assertEquals((int)1, (int)item.getInt("replyCount"));
    }

    public void testUpdateReply() throws Exception {
        JSONObject item = this.createPost("test", "test", 200);
        String postName = item.getString("name");
        String postNodeRef = item.getString("nodeRef");
        JSONObject reply = this.createReply(postNodeRef, "test", "test", 200);
        String replyNodeRef = reply.getString("nodeRef");
        DiscussionServiceTest.assertEquals((String)"test", (String)reply.getString("title"));
        DiscussionServiceTest.assertEquals((String)"test", (String)reply.getString("content"));
        DiscussionServiceTest.assertEquals((boolean)false, (boolean)reply.getBoolean("isUpdated"));
        JSONObject reply2 = this.updatePost(reply.getString("nodeRef"), "test2", "test2", 200);
        DiscussionServiceTest.assertEquals((String)"test2", (String)reply2.getString("title"));
        DiscussionServiceTest.assertEquals((String)"test2", (String)reply2.getString("content"));
        DiscussionServiceTest.assertEquals((boolean)true, (boolean)reply2.getBoolean("isUpdated"));
    }
}

