/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facebook;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.web.scripts.facebook.FacebookAppModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.WebScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookService {
    private static final Log logger = LogFactory.getLog(FacebookService.class);
    private Map<String, FacebookAppModel> apps = new HashMap<String, FacebookAppModel>();
    private ReentrantReadWriteLock appsLock = new ReentrantReadWriteLock();
    private Container container;

    public void setContainer(Container container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FacebookAppModel getAppModel(String apiKey) {
        FacebookAppModel facebookApp = null;
        this.appsLock.readLock().lock();
        try {
            facebookApp = this.apps.get(apiKey);
            if (facebookApp == null) {
                this.appsLock.readLock().unlock();
                this.appsLock.writeLock().lock();
                try {
                    facebookApp = this.apps.get(apiKey);
                    if (facebookApp == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Initialising Facebook Application '" + apiKey + "'"));
                        }
                        String appPath = "com/facebook/_apps/app." + apiKey + ".js";
                        String validScriptPath = this.container.getScriptProcessorRegistry().findValidScriptPath(appPath);
                        if (validScriptPath == null) {
                            throw new WebScriptException("Unable to locate application initialisation script '" + appPath + "'");
                        }
                        ScriptProcessor scriptProcessor = this.container.getScriptProcessorRegistry().getScriptProcessor(validScriptPath);
                        ScriptContent appScript = scriptProcessor.findScript(validScriptPath);
                        if (appScript == null) {
                            throw new WebScriptException("Unable to locate application initialisation script '" + appPath + "'");
                        }
                        HashMap<String, FacebookAppModel> model = new HashMap<String, FacebookAppModel>();
                        FacebookAppModel app = new FacebookAppModel(apiKey);
                        model.put("app", app);
                        scriptProcessor.executeScript(appScript, model);
                        if (app.getSecret() == null) {
                            throw new WebScriptException("Secret key for application '" + apiKey + "' has not been specified.");
                        }
                        if (app.getApiKey() == null) {
                            throw new WebScriptException("Application Id for application '" + apiKey + "' has not been specified.");
                        }
                        this.apps.put(apiKey, app);
                        facebookApp = app;
                    }
                }
                finally {
                    this.appsLock.readLock().lock();
                    this.appsLock.writeLock().unlock();
                }
            }
            FacebookAppModel facebookAppModel = facebookApp;
            return facebookAppModel;
        }
        finally {
            this.appsLock.readLock().unlock();
        }
    }

    public Map<String, FacebookAppModel> getAppModels() {
        return this.apps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.appsLock.writeLock().lock();
        try {
            this.apps.clear();
        }
        finally {
            this.appsLock.writeLock().unlock();
        }
    }
}

