/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facebook;

import javax.servlet.http.HttpServletRequest;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

public class FacebookServletRequest
extends WebScriptServletRequest {
    private String appId;
    private String secretKey;
    private String pathInfo;

    public FacebookServletRequest(Runtime container, HttpServletRequest req, Match serviceMatch, ServerProperties serverProperties, String pathInfo) {
        super(container, req, serviceMatch, serverProperties);
        this.pathInfo = pathInfo;
    }

    void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    void setAppId(String appId) {
        this.appId = appId;
    }

    public String getApiKey() {
        return this.getParameter("fb_sig_api_key");
    }

    public String getUserId() {
        return this.getParameter("fb_sig_user");
    }

    public String getSessionKey() {
        return this.getParameter("fb_sig_session_key");
    }

    public boolean isInCanvas() {
        String canvas = this.getParameter("fb_sig_api_key");
        return canvas == null || canvas.equals("1");
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getCanvasPath() {
        String pathInfo = this.getPathInfo();
        String[] pathSegments = pathInfo.split("/");
        if (pathSegments.length < 3) {
            throw new WebScriptException("Cannot establish Facebook Canvas Page URL from request " + this.getURL());
        }
        return pathSegments[2];
    }

    public String getPagePath() {
        String pagePath = this.getPathInfo();
        if (pagePath.startsWith("/facebook")) {
            pagePath = this.pathInfo.substring("/facebook".length());
        }
        return pagePath;
    }

    public String[] getFriends() {
        String friendsStr = this.getParameter("fb_sig_friends");
        String[] friends = friendsStr == null ? new String[]{} : friendsStr.split(",");
        return friends;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }
}

