/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.forms;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public abstract class AbstractTestFormRestApi
extends BaseWebScriptTest {
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String TEST_FORM_DESCRIPTION = "Test form description";
    protected static final String TEST_FORM_TITLE = "Test form title";
    protected static final String FORM_DEF_URL = "/api/formdefinitions";
    protected String referencingNodeUpdateUrl;
    protected String containingNodeUpdateUrl;
    protected String containingNodeUrl;
    protected NodeRef referencingDocNodeRef;
    protected Map<QName, Serializable> refNodePropertiesAfterCreation;
    protected NodeRef associatedDoc_A;
    protected NodeRef associatedDoc_B;
    protected NodeRef associatedDoc_C;
    protected NodeRef associatedDoc_D;
    protected NodeRef associatedDoc_E;
    protected NodeRef childDoc_A;
    protected NodeRef childDoc_B;
    protected NodeRef childDoc_C;
    protected NodeRef childDoc_D;
    protected NodeRef childDoc_E;
    protected NodeRef testFolderNodeRef;
    protected NodeService nodeService;
    private FileFolderService fileFolderService;
    private ContentService contentService;
    private Repository repositoryHelper;
    protected NodeRef containerNodeRef;

    protected void setUp() throws Exception {
        super.setUp();
        this.fileFolderService = (FileFolderService)this.getServer().getApplicationContext().getBean("FileFolderService");
        this.contentService = (ContentService)this.getServer().getApplicationContext().getBean("ContentService");
        this.repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        NodeRef companyHomeNodeRef = this.repositoryHelper.getCompanyHome();
        String guid = GUID.generate();
        FileInfo referencingDoc = this.fileFolderService.create(companyHomeNodeRef, "referencingDoc" + guid + ".txt", ContentModel.TYPE_CONTENT);
        this.referencingDocNodeRef = referencingDoc.getNodeRef();
        HashMap<QName, String> aspectProps = new HashMap<QName, String>(2);
        aspectProps.put(ContentModel.PROP_TITLE, TEST_FORM_TITLE);
        aspectProps.put(ContentModel.PROP_DESCRIPTION, TEST_FORM_DESCRIPTION);
        this.nodeService.addAspect(this.referencingDocNodeRef, ContentModel.ASPECT_TITLED, aspectProps);
        ContentWriter contentWriter = this.contentService.getWriter(referencingDoc.getNodeRef(), ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/plain");
        contentWriter.putContent("The quick brown fox jumped over the lazy dog.");
        FileInfo associatedDocsFolder = this.fileFolderService.create(companyHomeNodeRef, "testFolder" + guid, ContentModel.TYPE_FOLDER);
        this.testFolderNodeRef = associatedDocsFolder.getNodeRef();
        this.associatedDoc_A = this.createTestNode("associatedDoc_A" + guid);
        this.associatedDoc_B = this.createTestNode("associatedDoc_B" + guid);
        this.associatedDoc_C = this.createTestNode("associatedDoc_C" + guid);
        this.associatedDoc_D = this.createTestNode("associatedDoc_D" + guid);
        this.associatedDoc_E = this.createTestNode("associatedDoc_E" + guid);
        aspectProps.clear();
        this.nodeService.addAspect(this.referencingDocNodeRef, ContentModel.ASPECT_REFERENCING, aspectProps);
        this.nodeService.createAssociation(this.referencingDocNodeRef, this.associatedDoc_A, ContentModel.ASSOC_REFERENCES);
        this.nodeService.createAssociation(this.referencingDocNodeRef, this.associatedDoc_B, ContentModel.ASSOC_REFERENCES);
        HashMap containerProps = new HashMap();
        this.containerNodeRef = this.nodeService.createNode(companyHomeNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testContainer" + guid)), ContentModel.TYPE_CONTAINER, containerProps).getChildRef();
        this.childDoc_A = this.createTestNode("childDoc_A" + guid);
        this.childDoc_B = this.createTestNode("childDoc_B" + guid);
        this.childDoc_C = this.createTestNode("childDoc_C" + guid);
        this.childDoc_D = this.createTestNode("childDoc_D" + guid);
        this.childDoc_E = this.createTestNode("childDoc_E" + guid);
        this.nodeService.addChild(this.containerNodeRef, this.childDoc_A, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"childA"));
        this.nodeService.addChild(this.containerNodeRef, this.childDoc_B, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"childB"));
        StringBuilder builder = new StringBuilder();
        builder.append("/api/node/workspace/").append(this.referencingDocNodeRef.getStoreRef().getIdentifier()).append("/").append(this.referencingDocNodeRef.getId()).append("/formprocessor");
        this.referencingNodeUpdateUrl = builder.toString();
        builder = new StringBuilder();
        builder.append("/api/node/workspace/").append(this.containerNodeRef.getStoreRef().getIdentifier()).append("/").append(this.containerNodeRef.getId()).append("/formprocessor");
        this.containingNodeUpdateUrl = builder.toString();
        this.refNodePropertiesAfterCreation = this.nodeService.getProperties(this.referencingDocNodeRef);
        this.refNodePropertiesAfterCreation.toString();
    }

    public void tearDown() {
        this.nodeService.deleteNode(this.referencingDocNodeRef);
        this.nodeService.deleteNode(this.associatedDoc_A);
        this.nodeService.deleteNode(this.associatedDoc_B);
        this.nodeService.deleteNode(this.associatedDoc_C);
        this.nodeService.deleteNode(this.associatedDoc_D);
        this.nodeService.deleteNode(this.associatedDoc_E);
        this.nodeService.deleteNode(this.childDoc_A);
        this.nodeService.deleteNode(this.childDoc_B);
        this.nodeService.deleteNode(this.childDoc_C);
        this.nodeService.deleteNode(this.childDoc_D);
        this.nodeService.deleteNode(this.childDoc_E);
        this.nodeService.deleteNode(this.testFolderNodeRef);
        this.nodeService.deleteNode(this.containerNodeRef);
    }

    protected TestWebScriptServer.Response sendGetReq(String url, int expectedStatusCode) throws IOException, UnsupportedEncodingException {
        TestWebScriptServer.Response result = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), expectedStatusCode);
        return result;
    }

    protected NodeRef createTestNode(String associatedDocName) {
        HashMap<QName, String> docProps = new HashMap<QName, String>(1);
        docProps.put(ContentModel.PROP_NAME, associatedDocName + ".txt");
        return this.nodeService.createNode(this.testFolderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)(associatedDocName + ".txt")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
    }
}

