/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.forms;

import java.util.ArrayList;
import java.util.Iterator;
import org.alfresco.repo.web.scripts.forms.AbstractTestFormRestApi;
import org.alfresco.service.cmr.repository.NodeRef;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.mozilla.javascript.NativeObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.extensions.webscripts.json.JSONUtils;

public class FormRestApiGet_Test
extends AbstractTestFormRestApi {
    protected JSONObject createItemJSON(NodeRef nodeRef) throws Exception {
        JSONObject jsonPostData = new JSONObject();
        jsonPostData.put("itemKind", (Object)"node");
        StringBuilder builder = new StringBuilder();
        builder.append(nodeRef.getStoreRef().getProtocol()).append("/").append(nodeRef.getStoreRef().getIdentifier()).append("/").append(nodeRef.getId());
        jsonPostData.put("itemId", (Object)builder.toString());
        return jsonPostData;
    }

    public void testResponseContentType() throws Exception {
        JSONObject jsonPostData = this.createItemJSON(this.referencingDocNodeRef);
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/formdefinitions", jsonPostString, "application/json"), 200);
        FormRestApiGet_Test.assertEquals((String)"application/json;charset=UTF-8", (String)rsp.getContentType());
    }

    public void testGetFormForNonExistentNode() throws Exception {
        String missingId = this.referencingDocNodeRef.getId().replaceAll("\\d", "x");
        NodeRef missingNodeRef = new NodeRef(this.referencingDocNodeRef.getStoreRef(), missingId);
        JSONObject jsonPostData = this.createItemJSON(missingNodeRef);
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/formdefinitions", jsonPostString, "application/json"), 404);
        FormRestApiGet_Test.assertEquals((String)"application/json;charset=UTF-8", (String)rsp.getContentType());
    }

    public void testJsonContentParsesCorrectly() throws Exception {
        JSONObject jsonPostData = this.createItemJSON(this.referencingDocNodeRef);
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/formdefinitions", jsonPostString, "application/json"), 200);
        String jsonResponseString = rsp.getContentAsString();
        NativeObject jsonObject = new JSONUtils().toObject(jsonResponseString);
        FormRestApiGet_Test.assertNotNull((String)"JSON object was null.", (Object)jsonObject);
    }

    public void testJsonUpperStructure() throws Exception {
        JSONObject jsonPostData = this.createItemJSON(this.referencingDocNodeRef);
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/formdefinitions", jsonPostString, "application/json"), 200);
        String jsonResponseString = rsp.getContentAsString();
        JSONObject jsonParsedObject = new JSONObject(new JSONTokener(jsonResponseString));
        FormRestApiGet_Test.assertNotNull((Object)jsonParsedObject);
        Object dataObj = jsonParsedObject.get("data");
        FormRestApiGet_Test.assertEquals(JSONObject.class, dataObj.getClass());
        JSONObject rootDataObject = (JSONObject)dataObj;
        FormRestApiGet_Test.assertEquals((int)5, (int)rootDataObject.length());
        String item = (String)rootDataObject.get("item");
        String submissionUrl = (String)rootDataObject.get("submissionUrl");
        String type = (String)rootDataObject.get("type");
        JSONObject definitionObject = (JSONObject)rootDataObject.get("definition");
        JSONObject formDataObject = (JSONObject)rootDataObject.get("formData");
        FormRestApiGet_Test.assertNotNull((Object)item);
        FormRestApiGet_Test.assertNotNull((Object)submissionUrl);
        FormRestApiGet_Test.assertNotNull((Object)type);
        FormRestApiGet_Test.assertNotNull((Object)definitionObject);
        FormRestApiGet_Test.assertNotNull((Object)formDataObject);
    }

    public void testJsonFormData() throws Exception {
        JSONObject jsonPostData = this.createItemJSON(this.referencingDocNodeRef);
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/formdefinitions", jsonPostString, "application/json"), 200);
        String jsonResponseString = rsp.getContentAsString();
        JSONObject jsonParsedObject = new JSONObject(new JSONTokener(jsonResponseString));
        FormRestApiGet_Test.assertNotNull((Object)jsonParsedObject);
        JSONObject rootDataObject = (JSONObject)jsonParsedObject.get("data");
        JSONObject formDataObject = (JSONObject)rootDataObject.get("formData");
        ArrayList<String> keys = new ArrayList<String>();
        Iterator iter = formDataObject.keys();
        while (iter.hasNext()) {
            String nextFieldName = (String)iter.next();
            FormRestApiGet_Test.assertEquals((String)("Did not expect to find a colon char in " + nextFieldName), (int)-1, (int)nextFieldName.indexOf(58));
            keys.add(nextFieldName);
        }
        int threshold = 5;
        int actualKeyCount = keys.size();
        FormRestApiGet_Test.assertTrue((String)("Expected more than 5 entries in formData. Actual: " + actualKeyCount), (actualKeyCount > 5 ? 1 : 0) != 0);
    }

    public void testJsonDefinitionFields() throws Exception {
        JSONObject jsonPostData = this.createItemJSON(this.referencingDocNodeRef);
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/formdefinitions", jsonPostString, "application/json"), 200);
        String jsonResponseString = rsp.getContentAsString();
        JSONObject jsonParsedObject = new JSONObject(new JSONTokener(jsonResponseString));
        FormRestApiGet_Test.assertNotNull((Object)jsonParsedObject);
        JSONObject rootDataObject = (JSONObject)jsonParsedObject.get("data");
        JSONObject definitionObject = (JSONObject)rootDataObject.get("definition");
        JSONArray fieldsArray = (JSONArray)definitionObject.get("fields");
        for (int i = 0; i < fieldsArray.length(); ++i) {
            Object nextObj = fieldsArray.get(i);
            JSONObject nextJsonObject = (JSONObject)nextObj;
            ArrayList<String> fieldKeys = new ArrayList<String>();
            Iterator iter2 = nextJsonObject.keys();
            while (iter2.hasNext()) {
                fieldKeys.add((String)iter2.next());
            }
            for (String s : fieldKeys) {
                if (!s.equals("mandatory") && !s.equals("protectedField")) continue;
                FormRestApiGet_Test.assertEquals((String)"JSON booleans should be actual booleans.", Boolean.class, nextJsonObject.get(s).getClass());
            }
        }
    }

    public void testJsonSelectedFields() throws Exception {
        JSONObject jsonPostData = this.createItemJSON(this.referencingDocNodeRef);
        JSONArray jsonFields = new JSONArray();
        jsonFields.put((Object)"cm:name");
        jsonFields.put((Object)"cm:title");
        jsonFields.put((Object)"cm:publisher");
        jsonPostData.put("fields", (Object)jsonFields);
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/formdefinitions", jsonPostString, "application/json"), 200);
        String jsonResponseString = rsp.getContentAsString();
        JSONObject jsonParsedObject = new JSONObject(new JSONTokener(jsonResponseString));
        FormRestApiGet_Test.assertNotNull((Object)jsonParsedObject);
        JSONObject rootDataObject = (JSONObject)jsonParsedObject.get("data");
        JSONObject definitionObject = (JSONObject)rootDataObject.get("definition");
        JSONArray fieldsArray = (JSONArray)definitionObject.get("fields");
        FormRestApiGet_Test.assertEquals((String)"Expected 2 fields", (int)2, (int)fieldsArray.length());
        JSONObject nameField = (JSONObject)fieldsArray.get(0);
        JSONObject titleField = (JSONObject)fieldsArray.get(1);
        String nameFieldDataKey = nameField.getString("dataKeyName");
        String titleFieldDataKey = titleField.getString("dataKeyName");
        JSONObject formDataObject = (JSONObject)rootDataObject.get("formData");
        FormRestApiGet_Test.assertNotNull((String)"Expected to find cm:name data", (Object)formDataObject.get(nameFieldDataKey));
        FormRestApiGet_Test.assertNotNull((String)"Expected to find cm:title data", (Object)formDataObject.get(titleFieldDataKey));
        FormRestApiGet_Test.assertEquals((Object)"Test form title", (Object)formDataObject.get("prop_cm_title"));
    }

    public void testJsonForcedFields() throws Exception {
        JSONObject jsonPostData = this.createItemJSON(this.referencingDocNodeRef);
        JSONArray jsonFields = new JSONArray();
        jsonFields.put((Object)"cm:name");
        jsonFields.put((Object)"cm:title");
        jsonFields.put((Object)"cm:publisher");
        jsonFields.put((Object)"cm:wrong");
        jsonPostData.put("fields", (Object)jsonFields);
        JSONArray jsonForcedFields = new JSONArray();
        jsonForcedFields.put((Object)"cm:publisher");
        jsonForcedFields.put((Object)"cm:wrong");
        jsonPostData.put("force", (Object)jsonForcedFields);
        String jsonPostString = jsonPostData.toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/formdefinitions", jsonPostString, "application/json"), 200);
        String jsonResponseString = rsp.getContentAsString();
        JSONObject jsonParsedObject = new JSONObject(new JSONTokener(jsonResponseString));
        FormRestApiGet_Test.assertNotNull((Object)jsonParsedObject);
        JSONObject rootDataObject = (JSONObject)jsonParsedObject.get("data");
        JSONObject definitionObject = (JSONObject)rootDataObject.get("definition");
        JSONArray fieldsArray = (JSONArray)definitionObject.get("fields");
        FormRestApiGet_Test.assertEquals((String)"Expected 3 fields", (int)3, (int)fieldsArray.length());
        JSONObject nameField = (JSONObject)fieldsArray.get(0);
        JSONObject titleField = (JSONObject)fieldsArray.get(1);
        String nameFieldDataKey = nameField.getString("dataKeyName");
        String titleFieldDataKey = titleField.getString("dataKeyName");
        JSONObject formDataObject = (JSONObject)rootDataObject.get("formData");
        FormRestApiGet_Test.assertNotNull((String)"Expected to find cm:name data", (Object)formDataObject.get(nameFieldDataKey));
        FormRestApiGet_Test.assertNotNull((String)"Expected to find cm:title data", (Object)formDataObject.get(titleFieldDataKey));
        FormRestApiGet_Test.assertEquals((Object)"Test form title", (Object)formDataObject.get("prop_cm_title"));
    }
}

