/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.groups;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class GroupsTest
extends BaseWebScriptTest {
    private static final Log logger = LogFactory.getLog(BaseWebScriptTest.class);
    private MutableAuthenticationService authenticationService;
    private AuthorityService authorityService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private String ADMIN_GROUP = "ALFRESCO_ADMINISTRATORS";
    private String EMAIL_GROUP = "EMAIL_CONTRIBUTORS";
    private String TEST_ROOTGROUP = "GroupsTest_ROOT";
    private String TEST_GROUPA = "TestA";
    private String TEST_GROUPB = "TESTB";
    private String TEST_GROUPC = "TesTC";
    private String TEST_GROUPD = "TESTD";
    private String TEST_GROUPE = "TestE";
    private String TEST_LINK = "TESTLINK";
    private String TEST_ROOTGROUP_DISPLAY_NAME = "GROUPS_TESTROOTDisplayName";
    private static final String USER_ONE = "GroupTestOne";
    private static final String USER_TWO = "GroupTestTwo";
    private static final String USER_THREE = "GroupTestThree";
    private static final String URL_GROUPS = "/api/groups";
    private static final String URL_ROOTGROUPS = "/api/rootgroups";
    private static String rootGroupName = null;

    private synchronized String createTestTree() {
        if (rootGroupName == null) {
            rootGroupName = this.authorityService.getName(AuthorityType.GROUP, this.TEST_ROOTGROUP);
        }
        HashSet<String> shareZones = new HashSet<String>(1, 1.0f);
        shareZones.add("APP.SHARE");
        if (!this.authorityService.authorityExists(rootGroupName)) {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            rootGroupName = this.authorityService.createAuthority(AuthorityType.GROUP, this.TEST_ROOTGROUP, this.TEST_ROOTGROUP_DISPLAY_NAME, this.authorityService.getDefaultZones());
            String groupA = this.authorityService.createAuthority(AuthorityType.GROUP, this.TEST_GROUPA, this.TEST_GROUPA, this.authorityService.getDefaultZones());
            this.authorityService.addAuthority(rootGroupName, groupA);
            String groupB = this.authorityService.createAuthority(AuthorityType.GROUP, this.TEST_GROUPB, this.TEST_GROUPB, this.authorityService.getDefaultZones());
            this.authorityService.addAuthority(rootGroupName, groupB);
            String groupD = this.authorityService.createAuthority(AuthorityType.GROUP, this.TEST_GROUPD, this.TEST_GROUPD, this.authorityService.getDefaultZones());
            String groupE = this.authorityService.createAuthority(AuthorityType.GROUP, this.TEST_GROUPE, this.TEST_GROUPE, shareZones);
            this.authorityService.addAuthority(groupB, groupD);
            this.authorityService.addAuthority(groupB, groupE);
            this.authorityService.addAuthority(groupB, USER_TWO);
            this.authorityService.addAuthority(groupB, USER_THREE);
            String groupC = this.authorityService.createAuthority(AuthorityType.GROUP, this.TEST_GROUPC, this.TEST_GROUPC, this.authorityService.getDefaultZones());
            this.authorityService.addAuthority(rootGroupName, groupC);
            this.authorityService.addAuthority(groupC, USER_TWO);
            String link = this.authorityService.createAuthority(AuthorityType.GROUP, this.TEST_LINK, this.TEST_LINK, this.authorityService.getDefaultZones());
            this.authorityService.addAuthority(rootGroupName, link);
            this.authenticationComponent.setCurrentUser(USER_ONE);
        }
        return rootGroupName;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authorityService = (AuthorityService)this.getServer().getApplicationContext().getBean("AuthorityService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.createUser(USER_THREE);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
    }

    public void testGetRootGroup() throws Exception {
        int i;
        this.createTestTree();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_ROOTGROUPS), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        JSONArray data = top.getJSONArray("data");
        GroupsTest.assertTrue((data.length() >= 3 ? 1 : 0) != 0);
        boolean gotRootGroup = false;
        boolean gotAdminGroup = false;
        boolean gotEmailGroup = false;
        for (int i2 = 0; i2 < data.length(); ++i2) {
            JSONObject rootGroup = data.getJSONObject(i2);
            if (rootGroup.getString("shortName").equals(this.TEST_ROOTGROUP)) {
                GroupsTest.assertEquals((String)"shortName wrong", (String)this.TEST_ROOTGROUP, (String)rootGroup.getString("shortName"));
                GroupsTest.assertEquals((String)"displayName wrong", (String)this.TEST_ROOTGROUP_DISPLAY_NAME, (String)rootGroup.getString("displayName"));
                GroupsTest.assertEquals((String)"authorityType wrong", (String)"GROUP", (String)rootGroup.getString("authorityType"));
                GroupsTest.assertFalse((String)"test rootgroup is admin group", (boolean)rootGroup.getBoolean("isAdminGroup"));
                gotRootGroup = true;
            }
            if (rootGroup.getString("shortName").equals(this.ADMIN_GROUP)) {
                gotAdminGroup = true;
            }
            if (!rootGroup.getString("shortName").equals(this.EMAIL_GROUP)) continue;
            gotEmailGroup = true;
        }
        GroupsTest.assertTrue((String)"root group not found", (boolean)gotRootGroup);
        GroupsTest.assertTrue((String)"admin group not found", (boolean)gotAdminGroup);
        GroupsTest.assertTrue((String)"email group not found", (boolean)gotEmailGroup);
        if (rootGroupName != null) {
            rootGroupName = this.authorityService.getName(AuthorityType.GROUP, this.TEST_ROOTGROUP);
        }
        Set zones = this.authorityService.getAuthorityZones(rootGroupName);
        GroupsTest.assertTrue((String)"root group is in APP.DEFAULT zone", (boolean)zones.contains("APP.DEFAULT"));
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rootgroups?zone=APP.DEFAULT"), 200);
        JSONObject top2 = new JSONObject(response2.getContentAsString());
        logger.debug((Object)response2.getContentAsString());
        JSONArray data2 = top2.getJSONArray("data");
        GroupsTest.assertTrue((data2.length() > 0 ? 1 : 0) != 0);
        for (i = 0; i < data2.length(); ++i) {
            JSONObject rootGroup = data2.getJSONObject(i);
            if (rootGroup.getString("shortName").equals(this.TEST_ROOTGROUP)) {
                GroupsTest.assertEquals((String)"shortName wrong", (String)this.TEST_ROOTGROUP, (String)rootGroup.getString("shortName"));
                GroupsTest.assertEquals((String)"displayName wrong", (String)this.TEST_ROOTGROUP_DISPLAY_NAME, (String)rootGroup.getString("displayName"));
                GroupsTest.assertEquals((String)"authorityType wrong", (String)"GROUP", (String)rootGroup.getString("authorityType"));
                GroupsTest.assertFalse((String)"test rootgroup is admin group", (boolean)rootGroup.getBoolean("isAdminGroup"));
            }
            if (!rootGroup.getString("shortName").equals(this.ADMIN_GROUP)) continue;
        }
        response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rootgroups?zone=AUTH.ALF"), 200);
        top2 = new JSONObject(response2.getContentAsString());
        logger.debug((Object)response2.getContentAsString());
        data2 = top2.getJSONArray("data");
        GroupsTest.assertTrue((data2.length() > 0 ? 1 : 0) != 0);
        for (i = 0; i < data2.length(); ++i) {
            JSONObject rootGroup = data2.getJSONObject(i);
            if (rootGroup.getString("shortName").equals(this.TEST_ROOTGROUP)) {
                GroupsTest.assertEquals((String)"shortName wrong", (String)this.TEST_ROOTGROUP, (String)rootGroup.getString("shortName"));
                GroupsTest.assertEquals((String)"displayName wrong", (String)this.TEST_ROOTGROUP_DISPLAY_NAME, (String)rootGroup.getString("displayName"));
                GroupsTest.assertEquals((String)"authorityType wrong", (String)"GROUP", (String)rootGroup.getString("authorityType"));
                GroupsTest.assertFalse((String)"test rootgroup is admin group", (boolean)rootGroup.getBoolean("isAdminGroup"));
            }
            if (!rootGroup.getString("shortName").equals(this.ADMIN_GROUP)) continue;
        }
        response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/rootgroups?zone=WIBBLE"), 200);
        top2 = new JSONObject(response2.getContentAsString());
        logger.debug((Object)response2.getContentAsString());
        data2 = top2.getJSONArray("data");
        GroupsTest.assertTrue((data2.length() == 0 ? 1 : 0) != 0);
    }

    public void testGetGroup() throws Exception {
        this.createTestTree();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.ADMIN_GROUP), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        GroupsTest.assertTrue((data.length() > 0 ? 1 : 0) != 0);
        GroupsTest.assertTrue((String)"admin group is not root group", (boolean)data.getBoolean("isRootGroup"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/crap"), 404);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.TEST_GROUPB), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONObject("data");
        GroupsTest.assertTrue((data.length() > 0 ? 1 : 0) != 0);
        GroupsTest.assertFalse((String)"group B is not admin group", (boolean)data.getBoolean("isAdminGroup"));
        GroupsTest.assertFalse((String)"group B is not root group", (boolean)data.getBoolean("isRootGroup"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.TEST_GROUPE), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONObject("data");
        GroupsTest.assertTrue((data.length() > 0 ? 1 : 0) != 0);
        GroupsTest.assertFalse((String)"group E is not admin group", (boolean)data.getBoolean("isAdminGroup"));
        GroupsTest.assertFalse((String)"group E is not root group", (boolean)data.getBoolean("isRootGroup"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateRootGroup() throws Exception {
        String myGroupName = "GT_CRG";
        String myDisplayName = "GT_CRGDisplay";
        JSONObject newGroupJSON = new JSONObject();
        newGroupJSON.put("displayName", (Object)myDisplayName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/rootgroups/" + myGroupName, newGroupJSON.toString(), "application/json"), 500);
        this.authenticationComponent.setSystemUserAsCurrentUser();
        try {
            newGroupJSON = new JSONObject();
            newGroupJSON.put("displayName", (Object)myDisplayName);
            TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/rootgroups/" + myGroupName, newGroupJSON.toString(), "application/json"), 201);
            JSONObject top = new JSONObject(response.getContentAsString());
            JSONObject rootGroup = top.getJSONObject("data");
            GroupsTest.assertEquals((String)"shortName wrong", (String)myGroupName, (String)rootGroup.getString("shortName"));
            GroupsTest.assertEquals((String)"displayName wrong", (String)myDisplayName, (String)rootGroup.getString("displayName"));
            newGroupJSON = new JSONObject();
            newGroupJSON.put("displayName", (Object)myDisplayName);
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/rootgroups/" + myGroupName, newGroupJSON.toString(), "application/json"), 400);
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rootgroups/" + myGroupName), 200);
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rootgroups/" + myGroupName), 404);
        }
        finally {
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rootgroups/" + myGroupName), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLinkChild() throws Exception {
        String myRootGroup = "GT_LGROOT";
        try {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rootgroups/" + myRootGroup), 0);
            String groupLinkFullName = "";
            TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.TEST_LINK), 200);
            JSONObject top = new JSONObject(response.getContentAsString());
            logger.debug((Object)response.getContentAsString());
            JSONObject data = top.getJSONObject("data");
            GroupsTest.assertTrue((data.length() > 0 ? 1 : 0) != 0);
            groupLinkFullName = data.getString("fullName");
            JSONObject newGroupJSON = new JSONObject();
            newGroupJSON.put("displayName", (Object)myRootGroup);
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/rootgroups/" + myRootGroup, newGroupJSON.toString(), "application/json"), 201);
            this.authenticationComponent.setCurrentUser(USER_ONE);
            newGroupJSON = new JSONObject();
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/groups/" + myRootGroup + "/children/" + groupLinkFullName, newGroupJSON.toString(), "application/json"), 500);
            this.authenticationComponent.setSystemUserAsCurrentUser();
            newGroupJSON = new JSONObject();
            TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/groups/" + myRootGroup + "/children/" + groupLinkFullName, newGroupJSON.toString(), "application/json"), 200);
            JSONObject top2 = new JSONObject(response2.getContentAsString());
            logger.debug((Object)response2.getContentAsString());
            JSONObject data2 = top2.getJSONObject("data");
            newGroupJSON = new JSONObject();
            response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/groups/" + myRootGroup + "/children/" + groupLinkFullName, newGroupJSON.toString(), "application/json"), 500);
            logger.debug((Object)"Get child GROUPS of myRootGroup");
            response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + myRootGroup + "/children?authorityType=GROUP"), 200);
            top = new JSONObject(response.getContentAsString());
            logger.debug((Object)response.getContentAsString());
            data = top.getJSONArray("data");
            GroupsTest.assertTrue((String)"no child groups of myGroup", (data.length() == 1 ? 1 : 0) != 0);
            JSONObject subGroup = data.getJSONObject(0);
            GroupsTest.assertEquals((String)"shortName wrong", (String)this.TEST_LINK, (String)subGroup.getString("shortName"));
            GroupsTest.assertEquals((String)"authorityType wrong", (String)"GROUP", (String)subGroup.getString("authorityType"));
            newGroupJSON = new JSONObject();
            String userOneFullName = USER_ONE;
            TestWebScriptServer.Response response3 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/groups/" + myRootGroup + "/children/" + userOneFullName, newGroupJSON.toString(), "application/json"), 200);
            JSONObject top3 = new JSONObject(response3.getContentAsString());
            logger.debug((Object)response3.getContentAsString());
            JSONObject data3 = top3.getJSONObject("data");
            logger.debug((Object)"Get child USERS of myRootGroup");
            response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + myRootGroup + "/children?authorityType=USER"), 200);
            top = new JSONObject(response.getContentAsString());
            logger.debug((Object)response.getContentAsString());
            data = top.getJSONArray("data");
            GroupsTest.assertTrue((String)"no child groups of myGroup", (data.length() == 1 ? 1 : 0) != 0);
            subGroup = data.getJSONObject(0);
            GroupsTest.assertEquals((String)"shortName wrong", (String)USER_ONE, (String)subGroup.getString("shortName"));
            GroupsTest.assertEquals((String)"authorityType wrong", (String)"USER", (String)subGroup.getString("authorityType"));
            logger.debug((Object)"Unlink Test Link");
            response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/groups/" + myRootGroup + "/children/" + groupLinkFullName), 200);
            top = new JSONObject(response.getContentAsString());
            logger.debug((Object)response.getContentAsString());
            logger.debug((Object)"Get child GROUPS of myRootGroup");
            response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + myRootGroup + "/children?authorityType=GROUP"), 200);
            top = new JSONObject(response.getContentAsString());
            logger.debug((Object)response.getContentAsString());
            data = top.getJSONArray("data");
            String myNewGroup = "GROUP_BUFFY";
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rootgroups/BUFFY"), 0);
            JSONObject newGroupJSON2 = new JSONObject();
            response3 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/groups/" + myRootGroup + "/children/" + myNewGroup, newGroupJSON2.toString(), "application/json"), 201);
            top3 = new JSONObject(response3.getContentAsString());
            logger.debug((Object)response3.getContentAsString());
            data3 = top3.getJSONObject("data");
            GroupsTest.assertEquals((String)"shortName wrong", (String)"BUFFY", (String)data3.getString("shortName"));
            GroupsTest.assertEquals((String)"fullName wrong", (String)myNewGroup, (String)data3.getString("fullName"));
            GroupsTest.assertEquals((String)"authorityType wrong", (String)"GROUP", (String)data3.getString("authorityType"));
            logger.debug((Object)"Get child GROUPS of myRootGroup");
            response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + myRootGroup + "/children?authorityType=GROUP"), 200);
            top2 = new JSONObject(response2.getContentAsString());
            logger.debug((Object)response2.getContentAsString());
            data2 = top2.getJSONArray("data");
            for (int i = 0; i < data2.length(); ++i) {
                JSONObject rootGroup = data2.getJSONObject(i);
                if (!rootGroup.getString("fullName").equals(myNewGroup)) continue;
            }
        }
        finally {
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rootgroups/" + myRootGroup), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateGroup() throws Exception {
        String myGroupName = "GT_UG";
        String myDisplayName = "GT_UGDisplay";
        String myNewDisplayName = "GT_UGDisplayNew";
        this.authenticationComponent.setSystemUserAsCurrentUser();
        try {
            JSONObject newGroupJSON = new JSONObject();
            newGroupJSON.put("displayName", (Object)myDisplayName);
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/rootgroups/" + myGroupName, newGroupJSON.toString(), "application/json"), 201);
            newGroupJSON = new JSONObject();
            newGroupJSON.put("displayName", (Object)myNewDisplayName);
            TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/groups/" + myGroupName, newGroupJSON.toString(), "application/json"), 200);
            JSONObject top = new JSONObject(response.getContentAsString());
            logger.debug((Object)response.getContentAsString());
            JSONObject data = top.getJSONObject("data");
            GroupsTest.assertTrue((data.length() > 0 ? 1 : 0) != 0);
            GroupsTest.assertEquals((String)"displayName wrong", (String)myNewDisplayName, (String)data.getString("displayName"));
            TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + myGroupName), 200);
            JSONObject top2 = new JSONObject(response2.getContentAsString());
            logger.debug((Object)response2.getContentAsString());
            JSONObject data2 = top2.getJSONObject("data");
            GroupsTest.assertTrue((data2.length() > 0 ? 1 : 0) != 0);
            GroupsTest.assertEquals((String)"displayName wrong", (String)myNewDisplayName, (String)data2.getString("displayName"));
            newGroupJSON = new JSONObject();
            newGroupJSON.put("displayName", (Object)myNewDisplayName);
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/groups/rubbish", newGroupJSON.toString(), "application/json"), 404);
        }
        finally {
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/rootgroups/" + myGroupName), 0);
        }
    }

    public void testSearchGroups() throws Exception {
        this.createTestTree();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups?shortNameFilter=ALFRESCO_ADMIN*"), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        JSONArray data = top.getJSONArray("data");
        GroupsTest.assertEquals((String)"length not 1", (int)1, (int)data.length());
        JSONObject authority = data.getJSONObject(0);
        GroupsTest.assertEquals((String)"", (String)this.ADMIN_GROUP, (String)authority.getString("shortName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups?shortNameFilter=ALFRE?CO_ADMIN*"), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertEquals((String)"length not 1", (int)1, (int)data.length());
        authority = data.getJSONObject(0);
        GroupsTest.assertEquals((String)"", (String)this.ADMIN_GROUP, (String)authority.getString("shortName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups?shortNameFilter=ALF"), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertEquals((String)"length not 1", (int)1, (int)data.length());
        authority = data.getJSONObject(0);
        GroupsTest.assertEquals((String)"", (String)this.ADMIN_GROUP, (String)authority.getString("shortName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups?shortNameFilter=XX?X"), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertEquals((String)"length not 0", (int)0, (int)data.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups?shortNameFilter=" + this.ADMIN_GROUP), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertEquals((String)"length not 1", (int)1, (int)data.length());
        authority = data.getJSONObject(0);
        GroupsTest.assertEquals((String)"", (String)this.ADMIN_GROUP, (String)authority.getString("shortName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups?shortNameFilter=" + this.TEST_GROUPD), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertEquals((String)"length not 1", (int)1, (int)data.length());
        authority = data.getJSONObject(0);
        GroupsTest.assertEquals((String)"", (String)this.TEST_GROUPD, (String)authority.getString("shortName"));
        String url = "/api/groups?shortNameFilter=" + this.TEST_GROUPD + "& zone=" + "APP.DEFAULT";
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject top2 = new JSONObject(response2.getContentAsString());
        logger.debug((Object)response2.getContentAsString());
        JSONArray data2 = top2.getJSONArray("data");
        GroupsTest.assertEquals((String)"length not 1", (int)1, (int)data2.length());
        JSONObject authority2 = data2.getJSONObject(0);
        GroupsTest.assertEquals((String)"", (String)this.TEST_GROUPD, (String)authority2.getString("shortName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups?shortNameFilter=" + this.TEST_GROUPE), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertEquals((String)"length not 1", (int)1, (int)data.length());
        authority = data.getJSONObject(0);
        GroupsTest.assertEquals((String)"Group E not found", (String)this.TEST_GROUPE, (String)authority.getString("shortName"));
        Set zones = this.authorityService.getAuthorityZones(authority.getString("fullName"));
        GroupsTest.assertTrue((boolean)zones.contains("APP.SHARE"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups?shortNameFilter=" + this.TEST_GROUPE + "&zone=" + "APP.SHARE"), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        System.out.println(response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertEquals((String)"Can't find Group E in Share zone", (int)1, (int)data.length());
        authority = data.getJSONObject(0);
        GroupsTest.assertEquals((String)"", (String)this.TEST_GROUPE, (String)authority.getString("shortName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups?shortNameFilter=" + this.TEST_GROUPE + "&zone=" + "APP.WCM"), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        System.out.println(response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertEquals((String)"length not 0", (int)0, (int)data.length());
    }

    public void testGetParents() throws Exception {
        this.createTestTree();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.ADMIN_GROUP + "/parents"), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        JSONArray data = top.getJSONArray("data");
        GroupsTest.assertTrue((String)"top level group has no parents", (data.length() == 0 ? 1 : 0) != 0);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.TEST_GROUPB + "/parents"), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertTrue((data.length() > 0 ? 1 : 0) != 0);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.TEST_GROUPD + "/parents?level=ALL"), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertTrue((data.length() >= 2 ? 1 : 0) != 0);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.TEST_GROUPD + "/parents?level=rubbish"), 400);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/rubbish/parents?level=all"), 404);
    }

    public void testGetChildren() throws Exception {
        int i;
        this.createTestTree();
        logger.debug((Object)"Get all children of GROUP B");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.TEST_GROUPB + "/children"), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        JSONArray data = top.getJSONArray("data");
        GroupsTest.assertTrue((data.length() > 0 ? 1 : 0) != 0);
        boolean gotGroupD = false;
        boolean gotGroupE = false;
        boolean gotUserTwo = false;
        boolean gotUserThree = false;
        for (int i2 = 0; i2 < data.length(); ++i2) {
            JSONObject authority = data.getJSONObject(i2);
            if (authority.getString("shortName").equals(this.TEST_GROUPD)) {
                gotGroupD = true;
            }
            if (authority.getString("shortName").equals(this.TEST_GROUPE)) {
                gotGroupE = true;
            }
            if (authority.getString("shortName").equals(USER_TWO)) {
                gotUserTwo = true;
            }
            if (!authority.getString("shortName").equals(USER_THREE)) continue;
            gotUserThree = true;
        }
        GroupsTest.assertEquals((String)"4 groups not returned", (int)4, (int)data.length());
        GroupsTest.assertTrue((String)"not got group D", (boolean)gotGroupD);
        GroupsTest.assertTrue((String)"not got group E", (boolean)gotGroupE);
        GroupsTest.assertTrue((String)"not got user two", (boolean)gotUserTwo);
        GroupsTest.assertTrue((String)"not got user three", (boolean)gotUserThree);
        logger.debug((Object)"Get child GROUPS of GROUP B");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.TEST_GROUPB + "/children?authorityType=GROUP"), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertTrue((String)"no child groups of group B", (data.length() > 1 ? 1 : 0) != 0);
        gotGroupD = false;
        gotGroupE = false;
        JSONObject subGroup = data.getJSONObject(0);
        for (i = 0; i < data.length(); ++i) {
            JSONObject authority = data.getJSONObject(i);
            if (authority.getString("shortName").equals(this.TEST_GROUPD)) {
                gotGroupD = true;
                continue;
            }
            if (authority.getString("shortName").equals(this.TEST_GROUPE)) {
                gotGroupE = true;
                continue;
            }
            GroupsTest.fail((String)("unexpected authority returned:" + authority.getString("shortName")));
        }
        GroupsTest.assertTrue((String)"not got group D", (boolean)gotGroupD);
        GroupsTest.assertTrue((String)"not got group E", (boolean)gotGroupE);
        GroupsTest.assertEquals((String)"authorityType wrong", (String)"GROUP", (String)subGroup.getString("authorityType"));
        for (i = 0; i < data.length(); ++i) {
            JSONObject authority = data.getJSONObject(i);
            GroupsTest.assertEquals((String)"authorityType wrong", (String)"GROUP", (String)authority.getString("authorityType"));
        }
        logger.debug((Object)"Get Child Users of Group B");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.TEST_GROUPB + "/children?authorityType=USER"), 200);
        top = new JSONObject(response.getContentAsString());
        logger.debug((Object)response.getContentAsString());
        data = top.getJSONArray("data");
        GroupsTest.assertTrue((data.length() > 1 ? 1 : 0) != 0);
        for (int i3 = 0; i3 < data.length(); ++i3) {
            JSONObject authority = data.getJSONObject(i3);
            GroupsTest.assertEquals((String)"authorityType wrong", (String)"USER", (String)authority.getString("authorityType"));
        }
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/" + this.TEST_GROUPB + "/children?authorityType=XXX"), 400);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/groups/rubbish/children"), 404);
    }
}

