/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.invitation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.TestModeable;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class InvitationTest
extends BaseWebScriptTest {
    private static final QName avatarQName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"test");
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private NodeService nodeService;
    private String userOne = "InvitationTestOne" + GUID.generate();
    private String userTwo = "InvitationTestTwo" + GUID.generate();
    private String userThree = "InvitationTestThree" + GUID.generate();
    private static final String URL_SITES = "/api/sites";
    private static final String URL_INVITATIONS = "/api/invitations";
    private List<String> createdSites = new ArrayList<String>(5);
    private List<Tracker> createdInvitations = new ArrayList<Tracker>(10);
    private TestModeable mailActionExecutor;
    private final Map<String, Map<String, String>> userProperties = new HashMap<String, Map<String, String>>(3);

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.mailActionExecutor = (TestModeable)this.getServer().getApplicationContext().getBean("mail");
        this.mailActionExecutor.setTestMode(true);
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(this.userOne, "Joe", "Bloggs");
        this.createUser(this.userTwo, "Jane", "Doe");
        this.createUser(this.userThree, "Nick", "Smith");
        this.authenticationComponent.setCurrentUser(this.userOne);
    }

    private void createUser(String userName, String firstName, String lastName) {
        this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
        PropertyMap ppOne = new PropertyMap(5);
        ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
        ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)firstName);
        ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)lastName);
        String email = firstName + "@email.com";
        ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)email);
        ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
        NodeRef person = this.personService.createPerson((Map)ppOne);
        String avatarUrl = this.makeAvatar(person);
        HashMap<String, String> properties = new HashMap<String, String>(4);
        properties.put("firstName", firstName);
        properties.put("lastName", lastName);
        properties.put("email", email);
        properties.put("avatar", avatarUrl);
        this.userProperties.put(userName, properties);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        for (String shortName : this.createdSites) {
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName), 0);
        }
        this.createdSites.clear();
        for (Tracker invite : this.createdInvitations) {
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + invite.siteName + "/invitations/" + invite.inviteId), 0);
        }
        this.createdInvitations.clear();
        this.mailActionExecutor.setTestMode(false);
        this.personService.deletePerson(this.userOne);
        this.personService.deletePerson(this.userTwo);
        this.personService.deletePerson(this.userThree);
    }

    private JSONObject createSite(String sitePreset, String shortName, String title, String description, SiteVisibility visibility, int expectedStatus) throws Exception {
        JSONObject site = new JSONObject();
        site.put("sitePreset", (Object)sitePreset);
        site.put("shortName", (Object)shortName);
        site.put("title", (Object)title);
        site.put("description", (Object)description);
        site.put("visibility", (Object)visibility.toString());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_SITES, site.toString(), "application/json"), expectedStatus);
        this.createdSites.add(shortName);
        return new JSONObject(response.getContentAsString());
    }

    public void testInvitationsGet() throws Exception {
        String shortNameSiteA = GUID.generate();
        this.createSite("myPreset", shortNameSiteA, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String shortNameSiteB = GUID.generate();
        this.createSite("myPreset", shortNameSiteB, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String inviteeComments = "Please sir, let $* me in";
        String userName = this.userTwo;
        String roleName = "SiteConsumer";
        String moderatedIdAUSER_TWO = this.createModeratedInvitation(shortNameSiteA, inviteeComments, userName, roleName);
        String moderatedIdBUSER_TWO = this.createModeratedInvitation(shortNameSiteB, inviteeComments, userName, roleName);
        String inviteeCommentsB = "Please sir, let $* me in";
        String userNameB = this.userThree;
        String roleNameB = "SiteConsumer";
        String moderatedIdBUSER_THREE = this.createModeratedInvitation(shortNameSiteB, inviteeCommentsB, userNameB, roleNameB);
        String inviteeFirstName = "Buffy";
        String inviteeLastName = "Summers";
        String inviteeEmail = "buffy@sunnydale";
        String inviteeUserName = userName;
        String serverPath = "http://localhost:8081/share/";
        String acceptURL = "page/accept-invite";
        String rejectURL = "page/reject-invite";
        String nominatedId = this.createNominatedInvitation(shortNameSiteA, inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, roleName, serverPath, acceptURL, rejectURL);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/invitations?inviteeUserName=" + this.userTwo), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONArray data = top.getJSONArray("data");
        JSONObject moderatedAInv = this.getInvitation(moderatedIdAUSER_TWO, data);
        InvitationTest.assertNotNull((String)"Moderated invitation to Site A not present!", (Object)moderatedAInv);
        JSONObject moderatedBInv = this.getInvitation(moderatedIdBUSER_TWO, data);
        InvitationTest.assertNotNull((String)"Moderated invitation to Site B not present!", (Object)moderatedBInv);
        JSONObject nominatedInv = this.getInvitation(nominatedId, data);
        InvitationTest.assertNotNull((String)"Nominated invitation to Site A not present!", (Object)nominatedInv);
        this.checkJSONInvitations(data);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/invitations?invitationType=MODERATED"), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        for (int i = 0; i < data.length(); ++i) {
            JSONObject obj = data.getJSONObject(i);
            InvitationTest.assertEquals((String)"Wrong invitation type", (String)"MODERATED", (String)obj.getString("invitationType"));
        }
        JSONObject moderatedATwoInv = this.getInvitation(moderatedIdAUSER_TWO, data);
        InvitationTest.assertNotNull((String)"first is null", (Object)moderatedATwoInv);
        JSONObject moderatedBTwoInv = this.getInvitation(moderatedIdBUSER_TWO, data);
        InvitationTest.assertNotNull((String)"second is null", (Object)moderatedBTwoInv);
        JSONObject moderatedBThreeInv = this.getInvitation(moderatedIdBUSER_THREE, data);
        InvitationTest.assertNotNull((String)"third is null", (Object)moderatedBThreeInv);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/invitations?invitationType=MODERATED&resourceName=" + shortNameSiteA + "&resourceType=WEB_SITE"), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        InvitationTest.assertEquals((String)"One moderated invitations not found", (int)1, (int)data.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/invitations?invitationType=MODERATED&resourceName=" + shortNameSiteA + "&resourceType=madeUpStuff"), 500);
        InvitationTest.assertEquals((int)500, (int)response.getStatus());
        top = new JSONObject(response.getContentAsString());
        InvitationTest.assertNotNull((Object)top.getString("message"));
    }

    public void testSiteInvitationsGet() throws Exception {
        String shortNameSiteA = GUID.generate();
        this.createSite("myPreset", shortNameSiteA, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String shortNameSiteB = GUID.generate();
        this.createSite("myPreset", shortNameSiteB, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String inviteeComments = "Please sir, let $* me in";
        String userName = this.userTwo;
        String roleName = "SiteConsumer";
        String moderatedIdAUSER_TWO = this.createModeratedInvitation(shortNameSiteA, inviteeComments, userName, roleName);
        String moderatedIdBUSER_TWO = this.createModeratedInvitation(shortNameSiteB, inviteeComments, userName, roleName);
        String inviteeCommentsB = "Please sir, let $* me in";
        String userNameB = this.userThree;
        String roleNameB = "SiteConsumer";
        String moderatedIdBUSER_THREE = this.createModeratedInvitation(shortNameSiteB, inviteeCommentsB, userNameB, roleNameB);
        String inviteeFirstName = "Buffy";
        String inviteeLastName = "Summers";
        String inviteeEmail = "buffy@sunnydale";
        String inviteeUserName = userName;
        String serverPath = "http://localhost:8081/share/";
        String acceptURL = "page/accept-invite";
        String rejectURL = "page/reject-invite";
        String nominatedId = this.createNominatedInvitation(shortNameSiteA, inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, roleName, serverPath, acceptURL, rejectURL);
        String allSiteAUrl = "/api/sites/" + shortNameSiteA + "/invitations";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(allSiteAUrl), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONArray data = top.getJSONArray("data");
        InvitationTest.assertEquals((String)"Wrong number of invitations!", (int)2, (int)data.length());
        JSONObject moderatedAInv = this.getInvitation(moderatedIdAUSER_TWO, data);
        InvitationTest.assertNotNull((String)"Moderated invitation to Site A not present!", (Object)moderatedAInv);
        JSONObject nominatedInv = this.getInvitation(nominatedId, data);
        InvitationTest.assertNotNull((String)"Nominated invitation to Site A not present!", (Object)nominatedInv);
        this.checkJSONInvitations(data);
        String allSiteBUrl = "/api/sites/" + shortNameSiteB + "/invitations";
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(allSiteBUrl), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        InvitationTest.assertEquals((String)"Wrong number of invitations!", (int)2, (int)data.length());
        JSONObject moderatedB2Inv = this.getInvitation(moderatedIdBUSER_TWO, data);
        InvitationTest.assertNotNull((String)"Moderated invitation User 2 to Site B not present!", (Object)moderatedB2Inv);
        JSONObject moderatedB3Inv = this.getInvitation(moderatedIdBUSER_THREE, data);
        InvitationTest.assertNotNull((String)"Moderated invitation User 3 to Site B not present!", (Object)moderatedB3Inv);
        this.checkJSONInvitations(data);
        String siteAModeratedUrl = "/api/sites/" + shortNameSiteA + "/invitations?invitationType=MODERATED";
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(siteAModeratedUrl), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        InvitationTest.assertEquals((int)1, (int)data.length());
        JSONObject invitation = data.getJSONObject(0);
        InvitationTest.assertEquals((String)"Wrong invitation type", (String)"MODERATED", (String)invitation.getString("invitationType"));
        JSONObject moderatedATwoInv = this.getInvitation(moderatedIdAUSER_TWO, data);
        InvitationTest.assertNotNull((String)"first is null", (Object)moderatedATwoInv);
        String siteANominatedUrl = "/api/sites/" + shortNameSiteA + "/invitations?invitationType=NOMINATED";
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(siteANominatedUrl), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        InvitationTest.assertEquals((int)1, (int)data.length());
        invitation = data.getJSONObject(0);
        InvitationTest.assertEquals((String)"Wrong invitation type", (String)"NOMINATED", (String)invitation.getString("invitationType"));
        JSONObject nominatedATwoInv = this.getInvitation(nominatedId, data);
        InvitationTest.assertNotNull((String)"first is null", (Object)nominatedATwoInv);
        String siteBUser2Url = "/api/sites/" + shortNameSiteB + "/invitations?inviteeUserName=" + this.userTwo;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(siteBUser2Url), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        InvitationTest.assertEquals((int)1, (int)data.length());
        invitation = data.getJSONObject(0);
        InvitationTest.assertEquals((String)"Wrong invitation user", (String)this.userTwo, (String)invitation.getString("inviteeUserName"));
        JSONObject moderatedBTwoInv = this.getInvitation(moderatedIdBUSER_TWO, data);
        InvitationTest.assertNotNull((String)"first is null", (Object)moderatedBTwoInv);
        siteBUser2Url = "/api/sites/" + shortNameSiteB + "/invitations?inviteeUserName=" + this.userThree;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(siteBUser2Url), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        InvitationTest.assertEquals((int)1, (int)data.length());
        invitation = data.getJSONObject(0);
        InvitationTest.assertEquals((String)"Wrong invitation user", (String)this.userThree, (String)invitation.getString("inviteeUserName"));
        JSONObject moderatedBThreeInv = this.getInvitation(moderatedIdBUSER_THREE, data);
        InvitationTest.assertNotNull((String)"first is null", (Object)moderatedBThreeInv);
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/invitations?invitationType=MODERATED&resourceName=" + shortNameSiteA + "&resourceType=madeUpStuff"), 500);
        InvitationTest.assertEquals((int)500, (int)response2.getStatus());
        JSONObject top2 = new JSONObject(response2.getContentAsString());
        InvitationTest.assertNotNull((Object)top2.getString("message"));
    }

    private void checkJSONInvitations(JSONArray data) throws JSONException {
        for (int i = 0; i < data.length(); ++i) {
            JSONObject invitation = data.getJSONObject(i);
            String userId = invitation.getString("inviteeUserName");
            Map<String, String> expectedProps = this.userProperties.get(userId);
            JSONObject invitee = invitation.getJSONObject("invitee");
            InvitationTest.assertNotNull((Object)invitee);
            InvitationTest.assertEquals((String)("User name is wrong for user: " + i), (String)userId, (String)invitee.getString("userName"));
            InvitationTest.assertEquals((String)("Avatar URI is wrong for user: " + i), (String)expectedProps.get("avatar"), (String)invitee.getString("avatar"));
            InvitationTest.assertEquals((String)"First name is wrong!", (String)expectedProps.get("firstName"), (String)invitee.getString("firstName"));
            InvitationTest.assertEquals((String)"Last name is wrong!", (String)expectedProps.get("lastName"), (String)invitee.getString("lastName"));
        }
    }

    private String makeAvatar(NodeRef person) {
        this.nodeService.addAspect(person, ContentModel.ASPECT_PREFERENCES, null);
        ChildAssociationRef assoc = this.nodeService.createNode(person, ContentModel.ASSOC_PREFERENCE_IMAGE, avatarQName, ContentModel.TYPE_CONTENT);
        NodeRef avatar = assoc.getChildRef();
        this.nodeService.createAssociation(person, avatar, ContentModel.ASSOC_AVATAR);
        return "api/node/" + avatar + "/content/thumbnails/avatar";
    }

    private String createNominatedInvitation(String siteName, String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeUserName, String inviteeRoleName, String serverPath, String acceptURL, String rejectURL) throws Exception {
        JSONObject newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"NOMINATED");
        newInvitation.put("inviteeRoleName", (Object)inviteeRoleName);
        if (inviteeUserName != null) {
            newInvitation.put("inviteeUserName", (Object)inviteeUserName);
        } else {
            newInvitation.put("inviteeFirstName", (Object)inviteeFirstName);
            newInvitation.put("inviteeLastName", (Object)inviteeLastName);
            newInvitation.put("inviteeEmail", (Object)inviteeEmail);
        }
        newInvitation.put("serverPath", (Object)serverPath);
        newInvitation.put("acceptURL", (Object)acceptURL);
        newInvitation.put("rejectURL", (Object)rejectURL);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + siteName + "/invitations", newInvitation.toString(), "application/json"), 201);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        this.createdInvitations.add(new Tracker(inviteId, siteName));
        return inviteId;
    }

    private String createModeratedInvitation(String siteName, String inviteeComments, String inviteeUserName, String inviteeRoleName) throws Exception {
        JSONObject newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"MODERATED");
        newInvitation.put("inviteeRoleName", (Object)inviteeRoleName);
        newInvitation.put("inviteeComments", (Object)inviteeComments);
        newInvitation.put("inviteeUserName", (Object)inviteeUserName);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + siteName + "/invitations", newInvitation.toString(), "application/json"), 201);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        this.createdInvitations.add(new Tracker(inviteId, siteName));
        return inviteId;
    }

    private JSONObject getInvitation(String inviteId, JSONArray data) throws Exception {
        for (int i = 0; i < data.length(); ++i) {
            JSONObject obj = data.getJSONObject(i);
            if (!inviteId.equals(obj.getString("inviteId"))) continue;
            return obj;
        }
        return null;
    }

    private class Tracker {
        public String inviteId;
        public String siteName;

        public Tracker(String inviteId, String siteName) {
            this.inviteId = inviteId;
            this.siteName = siteName;
        }
    }
}

