/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.metadata;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class BulkMetadataGet
extends AbstractWebScript {
    private ServiceRegistry services;
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    private String getMimeType(ContentData contentProperty) {
        String mimetype = null;
        if (contentProperty != null) {
            mimetype = contentProperty.getMimetype();
        }
        return mimetype;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        try {
            Content c = req.getContent();
            if (c == null) {
                throw new WebScriptException(400, "Missing POST body.");
            }
            JSONObject jsonIn = new JSONObject(c.getContent());
            JSONArray nodeRefsArray = jsonIn.getJSONArray("nodeRefs");
            if (nodeRefsArray == null || nodeRefsArray.length() == 0) {
                throw new WebScriptException(500, "Must provide node refs");
            }
            JSONWriter jsonOut = new JSONWriter(res.getWriter());
            res.setContentType("application/json");
            res.setContentEncoding(Charset.defaultCharset().displayName());
            jsonOut.startObject();
            jsonOut.startValue("nodes");
            jsonOut.startArray();
            for (int i = 0; i < nodeRefsArray.length(); ++i) {
                NodeRef nodeRef = new NodeRef(nodeRefsArray.getString(i));
                if (this.nodeService.exists(nodeRef)) {
                    NodeRef parentNodeRef = null;
                    ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(nodeRef);
                    if (childAssocRef != null) {
                        parentNodeRef = childAssocRef.getParentRef();
                    }
                    QName type = this.nodeService.getType(nodeRef);
                    String shortType = type.toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService());
                    Map properties = this.nodeService.getProperties(nodeRef);
                    jsonOut.startObject();
                    jsonOut.writeValue("nodeRef", nodeRef.toString());
                    jsonOut.writeValue("parentNodeRef", parentNodeRef.toString());
                    jsonOut.writeValue("type", type.toString());
                    jsonOut.writeValue("shortType", shortType);
                    TypeDefinition typeDef = this.dictionaryService.getType(type);
                    jsonOut.writeValue("typeTitle", typeDef.getTitle());
                    jsonOut.writeValue("name", (String)properties.get(ContentModel.PROP_NAME));
                    jsonOut.writeValue("title", (String)properties.get(ContentModel.PROP_TITLE));
                    jsonOut.writeValue("mimeType", this.getMimeType((ContentData)properties.get(ContentModel.PROP_CONTENT)));
                    jsonOut.endObject();
                    continue;
                }
                jsonOut.startObject();
                jsonOut.writeValue("nodeRef", nodeRef.toString());
                jsonOut.writeValue("error", "true");
                jsonOut.writeValue("errorCode", "invalidNodeRef");
                jsonOut.writeValue("errorText", I18NUtil.getMessage((String)"msg.invalidNodeRef", (Object[])new Object[]{nodeRef.toString()}));
                jsonOut.endObject();
            }
            jsonOut.endArray();
            jsonOut.endValue();
            jsonOut.endObject();
        }
        catch (JSONException jErr) {
            throw new WebScriptException(400, "Unable to parse JSON POST body: " + jErr.getMessage());
        }
        res.getWriter().close();
        res.setStatus(200);
    }

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
        this.nodeService = services.getNodeService();
        this.dictionaryService = services.getDictionaryService();
    }
}

