/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.portlet;

import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.portlet.PortletAuthenticatorFactory;

public class JSR168PortletAuthenticatorFactory
implements PortletAuthenticatorFactory {
    private static final Log logger = LogFactory.getLog(JSR168PortletAuthenticatorFactory.class);
    private AuthenticationService unprotAuthenticationService;
    private TransactionService txnService;

    public void setUnprotAuthenticationService(AuthenticationService authenticationService) {
        this.unprotAuthenticationService = authenticationService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.txnService = transactionService;
    }

    public Authenticator create(RenderRequest req, RenderResponse res) {
        return new JSR168PortletAuthenticator(req, res);
    }

    public class JSR168PortletAuthenticator
    implements Authenticator {
        private RenderRequest req;

        public JSR168PortletAuthenticator(RenderRequest req, RenderResponse res) {
            this.req = req;
        }

        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            String portalUser = (String)this.req.getPortletSession().getAttribute("alfportletusername");
            if (portalUser == null) {
                portalUser = this.req.getRemoteUser();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("JSR-168 Remote user: " + portalUser));
            }
            if (isGuest || portalUser == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Authenticating as Guest");
                }
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authenticating as user " + portalUser));
                }
                UserTransaction txn = null;
                try {
                    txn = JSR168PortletAuthenticatorFactory.this.txnService.getUserTransaction();
                    txn.begin();
                    if (!JSR168PortletAuthenticatorFactory.this.unprotAuthenticationService.authenticationExists(portalUser)) {
                        throw new WebScriptException(403, "User " + portalUser + " is not a known Alfresco user");
                    }
                    AuthenticationUtil.setFullyAuthenticatedUser((String)portalUser);
                }
                catch (Throwable err) {
                    throw new AlfrescoRuntimeException("Error authenticating user: " + portalUser, err);
                }
                finally {
                    try {
                        if (txn != null) {
                            txn.rollback();
                        }
                    }
                    catch (Exception tex) {}
                }
            }
            return true;
        }

        public boolean emptyCredentials() {
            String portalUser = (String)this.req.getPortletSession().getAttribute("alfportletusername");
            if (portalUser == null) {
                portalUser = this.req.getRemoteUser();
            }
            return portalUser == null;
        }
    }
}

