/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rating;

import java.util.Map;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractRatingWebScript
extends DeclarativeWebScript {
    protected static final String RATING_SCHEME = "ratingScheme";
    protected static final String RATING = "rating";
    protected static final String RATED_NODE = "ratedNode";
    protected static final String NODE_REF = "nodeRef";
    protected static final String RATINGS = "ratings";
    protected static final String AVERAGE_RATINGS = "averageRatings";
    protected static final String RATINGS_TOTALS = "ratingsTotals";
    protected static final String RATINGS_COUNTS = "ratingsCounts";
    protected NodeService nodeService;
    protected RatingService ratingService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRatingService(RatingService ratingService) {
        this.ratingService = ratingService;
    }

    protected NodeRef parseRequestForNodeRef(WebScriptRequest req) {
        String nodeId;
        String storeId;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String storeType = (String)templateVars.get("store_type");
        StoreRef storeRef = new StoreRef(storeType, storeId = (String)templateVars.get("store_id"));
        NodeRef nodeRef = new NodeRef(storeRef, nodeId = (String)templateVars.get("id"));
        if (!this.nodeService.exists(nodeRef)) {
            throw new WebScriptException(404, "Unable to find node: " + nodeRef.toString());
        }
        return nodeRef;
    }
}

