/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rating;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.rating.AbstractRatingWebScript;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RatingDelete
extends AbstractRatingWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String ratingSchemeName;
        HashMap<String, Object> model = new HashMap<String, Object>();
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        Rating deletedRating = this.ratingService.removeRatingByCurrentUser(nodeRef, ratingSchemeName = this.parseRequestForScheme(req));
        if (deletedRating == null) {
            throw new WebScriptException(400, "Unable to delete non-existent rating: " + ratingSchemeName + " from " + nodeRef.toString());
        }
        model.put("nodeRef", nodeRef.toString());
        model.put("rating", deletedRating);
        return model;
    }

    private String parseRequestForScheme(WebScriptRequest req) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String scheme = (String)templateVars.get("scheme");
        return scheme;
    }
}

