/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wcm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class WebProjectTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private static final String USER_ONE = "WebProjectTestOne";
    private static final String USER_TWO = "WebProjectTestTwo";
    private static final String USER_THREE = "WebProjectTestThree";
    private static final String URL_WEB_PROJECTS = "/api/wcm/webprojects";
    private static final String BASIC_NAME = "testProj";
    private static final String BASIC_UPDATED_NAME = "updatedName";
    private static final String BASIC_DESCRIPTION = "testDescription";
    private static final String BASIC_UPDATED_DESCRIPTION = "updatedDescription";
    private static final String BASIC_TITLE = "testTitle";
    private static final String BASIC_UPDATED_TITLE = "updatedTitle";
    private static final String BASIC_DNSNAME = "testDNSName";
    private static final String BAD_PROJECT_REF = "doesNotExist";
    private List<String> createdWebProjects = new ArrayList<String>(5);

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.createUser(USER_THREE);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        for (String webProjectRef : this.createdWebProjects) {
            try {
                this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/wcm/webprojects/" + webProjectRef), 0);
            }
            catch (Exception exception) {}
        }
        this.createdWebProjects.clear();
    }

    public void testBasicCRUDWebProject() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/wcm/webprojects/testDNSName"), 0);
        JSONObject webProj = new JSONObject();
        webProj.put("name", (Object)BASIC_NAME);
        webProj.put("description", (Object)BASIC_DESCRIPTION);
        webProj.put("title", (Object)BASIC_TITLE);
        webProj.put("dnsName", (Object)BASIC_DNSNAME);
        webProj.put("isTemplate", true);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_WEB_PROJECTS, webProj.toString(), "application/json"), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject result = top.getJSONObject("data");
        String webProjectRef = result.getString("webprojectref");
        WebProjectTest.assertNotNull((String)"webproject ref is null", (Object)webProjectRef);
        this.createdWebProjects.add(webProjectRef);
        WebProjectTest.assertEquals((Object)BASIC_NAME, (Object)result.get("name"));
        WebProjectTest.assertEquals((Object)BASIC_DESCRIPTION, (Object)result.get("description"));
        WebProjectTest.assertEquals((Object)BASIC_TITLE, (Object)result.get("title"));
        TestWebScriptServer.Response lookup = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/wcm/webprojects/" + webProjectRef), 200);
        JSONObject lookupResult = new JSONObject(lookup.getContentAsString());
        JSONObject data = lookupResult.getJSONObject("data");
        WebProjectTest.assertEquals((Object)BASIC_NAME, (Object)data.get("name"));
        WebProjectTest.assertEquals((Object)BASIC_DESCRIPTION, (Object)data.get("description"));
        WebProjectTest.assertEquals((Object)BASIC_TITLE, (Object)data.get("title"));
        String url = data.getString("url");
        WebProjectTest.assertNotNull((String)"url is null", (Object)url);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject update = new JSONObject();
        update.put("name", (Object)BASIC_UPDATED_NAME);
        TestWebScriptServer.Response updateResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/wcm/webprojects/" + webProjectRef, update.toString(), "application/json"), 200);
        JSONObject updateResult = new JSONObject(updateResponse.getContentAsString());
        JSONObject data2 = updateResult.getJSONObject("data");
        WebProjectTest.assertEquals((Object)BASIC_UPDATED_NAME, (Object)data2.get("name"));
        WebProjectTest.assertEquals((Object)BASIC_DESCRIPTION, (Object)data2.get("description"));
        WebProjectTest.assertEquals((Object)BASIC_TITLE, (Object)data2.get("title"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/wcm/webprojects/" + webProjectRef), 200);
    }

    public void testListWebSites() throws Exception {
        int LOOP_COUNT = 5;
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        for (int i = 0; i < LOOP_COUNT; ++i) {
            JSONObject webProj = new JSONObject();
            webProj.put("name", (Object)(BASIC_NAME + i));
            webProj.put("description", (Object)(BASIC_DESCRIPTION + i));
            webProj.put("title", (Object)(BASIC_TITLE + i));
            webProj.put("dnsName", (Object)(BASIC_DNSNAME + i));
            TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_WEB_PROJECTS, webProj.toString(), "application/json"), 200);
            JSONObject result = new JSONObject(response.getContentAsString());
            JSONObject data = result.getJSONObject("data");
            String webProjectRef = data.getString("webprojectref");
            this.createdWebProjects.add(webProjectRef);
        }
        TestWebScriptServer.Response list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_WEB_PROJECTS), 200);
        JSONObject lookupResult = new JSONObject(list.getContentAsString());
        JSONArray data = lookupResult.getJSONArray("data");
        WebProjectTest.assertTrue((data.length() >= LOOP_COUNT ? 1 : 0) != 0);
        int foundCount = 0;
        for (int i = 0; i < data.length(); ++i) {
            JSONObject obj = data.getJSONObject(i);
            String name = obj.getString("name");
            if (!name.contains(BASIC_NAME)) continue;
            ++foundCount;
        }
        WebProjectTest.assertTrue((foundCount >= LOOP_COUNT ? 1 : 0) != 0);
        String stepURL = "/api/wcm/webprojects?userName=Freddy";
        TestWebScriptServer.Response listResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(stepURL), 200);
        JSONObject lookupResult2 = new JSONObject(listResponse.getContentAsString());
        JSONArray data2 = lookupResult2.getJSONArray("data");
        WebProjectTest.assertTrue((data2.length() == 0 ? 1 : 0) != 0);
    }

    public void testUpdateWebProject() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        JSONObject webProj = new JSONObject();
        webProj.put("name", (Object)BASIC_NAME);
        webProj.put("description", (Object)BASIC_DESCRIPTION);
        webProj.put("title", (Object)BASIC_TITLE);
        webProj.put("dnsName", (Object)BASIC_DNSNAME);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_WEB_PROJECTS, webProj.toString(), "application/json"), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject result = top.getJSONObject("data");
        String webProjectRef = result.getString("webprojectref");
        WebProjectTest.assertNotNull((String)"webproject ref is null", (Object)webProjectRef);
        this.createdWebProjects.add(webProjectRef);
        TestWebScriptServer.Response lookup = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/wcm/webprojects/" + webProjectRef), 200);
        JSONObject lookupResult = new JSONObject(lookup.getContentAsString());
        JSONObject data = lookupResult.getJSONObject("data");
        WebProjectTest.assertEquals((Object)BASIC_NAME, (Object)data.get("name"));
        WebProjectTest.assertEquals((Object)BASIC_DESCRIPTION, (Object)data.get("description"));
        WebProjectTest.assertEquals((Object)BASIC_TITLE, (Object)data.get("title"));
        JSONObject update = new JSONObject();
        update.put("description", (Object)BASIC_UPDATED_DESCRIPTION);
        TestWebScriptServer.Response updateResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/wcm/webprojects/" + webProjectRef, update.toString(), "application/json"), 200);
        JSONObject updateResult = new JSONObject(updateResponse.getContentAsString());
        TestWebScriptServer.Response lookup2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/wcm/webprojects/" + webProjectRef), 200);
        JSONObject lookupResult2 = new JSONObject(lookup2.getContentAsString());
        JSONObject data2 = lookupResult2.getJSONObject("data");
        WebProjectTest.assertEquals((Object)BASIC_NAME, (Object)data2.get("name"));
        WebProjectTest.assertEquals((Object)BASIC_UPDATED_DESCRIPTION, (Object)data2.get("description"));
        WebProjectTest.assertEquals((Object)BASIC_TITLE, (Object)data2.get("title"));
        update = new JSONObject();
        update.put("title", (Object)BASIC_UPDATED_TITLE);
        updateResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/wcm/webprojects/" + webProjectRef, update.toString(), "application/json"), 200);
        new JSONObject(updateResponse.getContentAsString());
        TestWebScriptServer.Response lookup3 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/wcm/webprojects/" + webProjectRef), 200);
        JSONObject lookupResult3 = new JSONObject(lookup3.getContentAsString());
        JSONObject data3 = lookupResult3.getJSONObject("data");
        WebProjectTest.assertEquals((Object)BASIC_NAME, (Object)data3.get("name"));
        WebProjectTest.assertEquals((Object)BASIC_UPDATED_DESCRIPTION, (Object)data3.get("description"));
        WebProjectTest.assertEquals((Object)BASIC_UPDATED_TITLE, (Object)data3.get("title"));
        update = new JSONObject();
        update.put("name", (Object)BASIC_UPDATED_NAME);
        updateResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/wcm/webprojects/" + webProjectRef, update.toString(), "application/json"), 200);
        updateResult = new JSONObject(updateResponse.getContentAsString());
        lookup2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/wcm/webprojects/" + webProjectRef), 200);
        lookupResult2 = new JSONObject(lookup2.getContentAsString());
        data2 = lookupResult2.getJSONObject("data");
        WebProjectTest.assertEquals((Object)BASIC_UPDATED_NAME, (Object)data2.get("name"));
        WebProjectTest.assertEquals((Object)BASIC_UPDATED_DESCRIPTION, (Object)data2.get("description"));
        WebProjectTest.assertEquals((Object)BASIC_UPDATED_TITLE, (Object)data2.get("title"));
        update = new JSONObject();
        update.put("name", (Object)BASIC_UPDATED_NAME);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/wcm/webprojects/doesNotExist", update.toString(), "application/json"), 404);
    }

    public void testDeleteWebProject() throws Exception {
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/wcm/webprojects/doesNotExist"), 404);
    }
}

