/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.util;

public class PagingCursor {
    boolean zeroBasedPage = false;
    boolean zeroBasedRow = true;

    public void setZeroBasedPage(boolean zeroBasedPage) {
        this.zeroBasedPage = zeroBasedPage;
    }

    public boolean isZeroBasedPage() {
        return this.zeroBasedPage;
    }

    public void setZeroBasedRow(boolean zeroBasedRow) {
        this.zeroBasedRow = zeroBasedRow;
    }

    public boolean isZeroBasedRow() {
        return this.zeroBasedRow;
    }

    public Page createPageCursor(long totalRows, int rowsPerPage, int page) {
        return new Page(totalRows, rowsPerPage, page, this.zeroBasedPage, this.zeroBasedRow);
    }

    public Page createPageCursor(long totalRows, int rowsPerPage, int page, boolean zeroBasedPage, boolean zeroBasedRow) {
        return new Page(totalRows, rowsPerPage, page, zeroBasedPage, zeroBasedRow);
    }

    public Rows createRowsCursor(long totalRows, long maxRows, long skipRows) {
        return new Rows(totalRows, maxRows, skipRows, this.zeroBasedRow);
    }

    public Rows createRowsCursor(long totalRows, long maxRows, long skipRows, boolean zeroBasedRow) {
        return new Rows(totalRows, maxRows, skipRows, zeroBasedRow);
    }

    public static class Rows {
        boolean zeroBasedRow;
        long totalRows;
        long skipRows;
        long maxRows;
        long pageSize;

        public Rows(long totalRows, long maxRows, long skipRows, boolean zeroBasedRow) {
            this.zeroBasedRow = zeroBasedRow;
            this.totalRows = totalRows;
            this.maxRows = maxRows;
            this.skipRows = skipRows;
            this.pageSize = maxRows <= 0L ? totalRows - skipRows : maxRows;
        }

        public long getTotalRows() {
            return this.totalRows;
        }

        public long getSkipRows() {
            return this.skipRows;
        }

        public long getMaxRows() {
            return this.maxRows;
        }

        public boolean isInRange() {
            return this.skipRows >= 0L && this.skipRows < this.totalRows;
        }

        public long getStartRow() {
            if (this.totalRows == 0L) {
                return -1L;
            }
            return this.skipRows + (long)(this.zeroBasedRow ? 0 : 1);
        }

        public long getEndRow() {
            if (this.totalRows == 0L) {
                return -1L;
            }
            return this.getStartRow() + Math.min(this.pageSize, this.totalRows - this.skipRows) - 1L;
        }

        public long getNextSkipRows() {
            return this.skipRows + this.pageSize < this.totalRows ? this.skipRows + this.pageSize : -1L;
        }
    }

    public static class Page {
        boolean zeroBasedPage;
        boolean zeroBasedRow;
        long totalRows;
        int rowsPerPage;
        long pageSize;
        int currentPage;
        int currentRow;

        public Page(long totalRows, int rowsPerPage, int page, boolean zeroBasedPage, boolean zeroBasedRow) {
            this.zeroBasedPage = zeroBasedPage;
            this.zeroBasedRow = zeroBasedRow;
            this.totalRows = totalRows;
            this.rowsPerPage = rowsPerPage;
            this.pageSize = rowsPerPage <= 0 ? totalRows : (long)rowsPerPage;
            this.currentPage = zeroBasedPage ? page : page - 1;
        }

        public long getTotalRows() {
            return this.totalRows;
        }

        public int getTotalPages() {
            if (this.totalRows == 0L) {
                return 0;
            }
            int totalPages = (int)(this.totalRows / this.pageSize);
            return totalPages += this.totalRows % this.pageSize != 0L ? 1 : 0;
        }

        public int getRowsPerPage() {
            return this.rowsPerPage;
        }

        public boolean isInRange() {
            return this.currentPage >= 0 && this.getCurrentPage() <= this.getLastPage();
        }

        public int getCurrentPage() {
            return this.currentPage + (this.zeroBasedPage ? 0 : 1);
        }

        public int getNextPage() {
            return this.getCurrentPage() < this.getLastPage() ? this.getCurrentPage() + 1 : -1;
        }

        public int getPreviousPage() {
            return this.currentPage > 0 ? this.getCurrentPage() - 1 : -1;
        }

        public int getFirstPage() {
            if (this.totalRows == 0L) {
                return -1;
            }
            return this.zeroBasedPage ? 0 : 1;
        }

        public int getLastPage() {
            if (this.totalRows == 0L) {
                return -1;
            }
            return this.getTotalPages() - (this.zeroBasedPage ? 1 : 0);
        }

        public long getStartRow() {
            if (this.totalRows == 0L) {
                return -1L;
            }
            return (long)this.currentPage * this.pageSize + (long)(this.zeroBasedRow ? 0 : 1);
        }

        public long getEndRow() {
            if (this.totalRows == 0L) {
                return -1L;
            }
            return this.getStartRow() + Math.min(this.pageSize, this.totalRows - (long)this.currentPage * this.pageSize) - 1L;
        }
    }
}

