/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;

public abstract class HierarchicalMethod
extends WebDAVMethod {
    protected String m_strDestinationPath;
    protected boolean m_overwrite = false;

    public final String getDestinationPath() {
        return this.m_strDestinationPath;
    }

    public final boolean hasOverWrite() {
        return this.m_overwrite;
    }

    protected void parseRequestHeaders() throws WebDAVServerException {
        String strDestination = this.m_request.getHeader("Destination");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsing Destination header: " + strDestination));
        }
        if (strDestination != null && strDestination.length() > 0) {
            int offset = -1;
            if (strDestination.startsWith("http://")) {
                this.checkDestinationPath(strDestination);
                offset = 7;
            } else if (strDestination.startsWith("https://")) {
                this.checkDestinationPath(strDestination);
                offset = 8;
            }
            if (offset != -1 && (offset = strDestination.indexOf("/", offset)) != -1) {
                String servletPath;
                String strPath = strDestination.substring(offset);
                if ((offset = strPath.indexOf(servletPath = this.m_request.getServletPath())) != -1) {
                    strPath = strPath.substring(offset + servletPath.length());
                }
                this.m_strDestinationPath = WebDAV.decodeURL(strPath);
            }
        }
        if (this.m_strDestinationPath == null) {
            logger.warn((Object)("Failed to parse the Destination header: " + strDestination));
            throw new WebDAVServerException(400);
        }
        String strOverwrite = this.m_request.getHeader("Overwrite");
        if (strOverwrite != null && strOverwrite.equals("T")) {
            this.m_overwrite = true;
        }
    }

    protected void parseRequestBody() throws WebDAVServerException {
    }

    protected final void checkDestinationPath(String path) throws WebDAVServerException {
        try {
            URL url = new URL(path);
            boolean localPath = true;
            if (url.getPort() != -1 && url.getPort() != this.m_request.getServerPort()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination path, different server port");
                }
                localPath = false;
            } else if (!url.getHost().equalsIgnoreCase(this.m_request.getServerName()) && !url.getHost().equals(this.m_request.getLocalAddr())) {
                String targetHost = url.getHost();
                if (!IPAddress.isNumericAddress((String)targetHost)) {
                    String localHost = this.m_request.getServerName();
                    int pos = targetHost.indexOf(".");
                    if (pos != -1) {
                        targetHost = targetHost.substring(0, pos);
                    }
                    if ((pos = localHost.indexOf(".")) != -1) {
                        localHost = localHost.substring(0, pos);
                    }
                    if (!targetHost.equalsIgnoreCase(localHost)) {
                        localPath = false;
                    }
                } else {
                    try {
                        InetAddress targetAddr = InetAddress.getByName(targetHost);
                        if (NetworkInterface.getByInetAddress(targetAddr) == null) {
                            localPath = false;
                        }
                    }
                    catch (Exception ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Failed to check target IP address, " + targetHost));
                        }
                        localPath = false;
                    }
                }
                if (!localPath && logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination path, different server name/address");
                    logger.debug((Object)("  URL host=" + url.getHost() + ", ServerName=" + this.m_request.getServerName() + ", localAddr=" + this.m_request.getLocalAddr()));
                }
            } else if (url.getPath().indexOf(this.m_request.getServletPath()) == -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination path, different serlet path");
                }
                localPath = false;
            }
            if (!localPath) {
                throw new WebDAVServerException(502);
            }
        }
        catch (MalformedURLException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Bad destination path, " + path));
            }
            throw new WebDAVServerException(502);
        }
    }
}

