/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.List;
import org.alfresco.repo.webdav.AbstractMoveOrCopyMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;

public class MoveMethod
extends AbstractMoveOrCopyMethod {
    protected void moveOrCopy(FileFolderService fileFolderService, NodeRef sourceNodeRef, NodeRef destParentNodeRef, String name) throws Exception {
        NodeRef rootNodeRef = this.getRootNodeRef();
        String path = this.getPath();
        List<String> pathElements = this.getDAVHelper().splitAllPaths(path);
        FileInfo fileInfo = null;
        try {
            fileInfo = fileFolderService.resolveNamePath(rootNodeRef, pathElements);
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Node not found: " + this.getPath()));
            }
            throw new WebDAVServerException(404);
        }
        this.checkNode(fileInfo);
        if (this.getNodeService().getPrimaryParent(sourceNodeRef).getParentRef().equals((Object)destParentNodeRef)) {
            fileFolderService.rename(sourceNodeRef, name);
        } else {
            fileFolderService.move(sourceNodeRef, destParentNodeRef, name);
        }
    }
}

