/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.namespace.QName;

public class PutMethod
extends WebDAVMethod {
    private String m_strLockToken = null;
    private String m_strContentType = null;
    private boolean m_expectHeaderPresent = false;

    protected void parseRequestHeaders() throws WebDAVServerException {
        this.m_strContentType = this.m_request.getHeader("Content-Type");
        String strExpect = this.m_request.getHeader("Expect");
        if (strExpect != null && strExpect.equals("100-continue")) {
            this.m_expectHeaderPresent = true;
        }
        this.parseIfHeader();
    }

    protected void parseRequestBody() throws WebDAVServerException {
    }

    protected void executeImpl() throws WebDAVServerException, Exception {
        String guessedMimetype;
        FileFolderService fileFolderService = this.getFileFolderService();
        FileInfo contentNodeInfo = null;
        boolean created = false;
        try {
            contentNodeInfo = this.getDAVHelper().getNodeForPath(this.getRootNodeRef(), this.getPath(), this.getServletPath());
            if (contentNodeInfo.isFolder()) {
                throw new WebDAVServerException(400);
            }
            this.checkNode(contentNodeInfo);
        }
        catch (FileNotFoundException e) {
            String[] paths = this.getDAVHelper().splitPath(this.getPath());
            try {
                FileInfo parentNodeInfo = this.getDAVHelper().getNodeForPath(this.getRootNodeRef(), paths[0], this.getServletPath());
                contentNodeInfo = fileFolderService.create(parentNodeInfo.getNodeRef(), paths[1], ContentModel.TYPE_CONTENT);
                created = true;
                HashMap<QName, String> titledProps = new HashMap<QName, String>(3, 1.0f);
                titledProps.put(ContentModel.PROP_TITLE, paths[1]);
                titledProps.put(ContentModel.PROP_DESCRIPTION, "");
                this.getNodeService().addAspect(contentNodeInfo.getNodeRef(), ContentModel.ASPECT_TITLED, titledProps);
            }
            catch (FileNotFoundException ee) {
                throw new WebDAVServerException(400);
            }
            catch (FileExistsException ee) {
                throw new WebDAVServerException(400);
            }
        }
        LockStatus lockSts = this.getLockService().getLockStatus(contentNodeInfo.getNodeRef());
        String userName = this.getDAVHelper().getAuthenticationService().getCurrentUserName();
        String owner = (String)((Object)this.getNodeService().getProperty(contentNodeInfo.getNodeRef(), ContentModel.PROP_LOCK_OWNER));
        if (lockSts == LockStatus.LOCKED || lockSts == LockStatus.LOCK_OWNER && !userName.equals(owner)) {
            throw new WebDAVServerException(423);
        }
        ContentWriter writer = fileFolderService.getWriter(contentNodeInfo.getNodeRef());
        String mimetype = null;
        mimetype = this.m_strContentType != null ? this.m_strContentType : (guessedMimetype = this.getMimetypeService().guessMimetype(contentNodeInfo.getName()));
        writer.setMimetype(mimetype);
        ServletInputStream is = this.m_request.getInputStream();
        is = is.markSupported() ? is : new BufferedInputStream((InputStream)is);
        ContentCharsetFinder charsetFinder = this.getMimetypeService().getContentCharsetFinder();
        Charset encoding = charsetFinder.getCharset((InputStream)is, mimetype);
        writer.setEncoding(encoding.name());
        writer.putContent((InputStream)is);
        this.m_response.setStatus(created ? 201 : 204);
    }
}

