/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.repository.UpdateResult;
import org.alfresco.repo.webservice.types.CML;
import org.alfresco.repo.webservice.types.CMLAddAspect;
import org.alfresco.repo.webservice.types.CMLAddChild;
import org.alfresco.repo.webservice.types.CMLCopy;
import org.alfresco.repo.webservice.types.CMLCreate;
import org.alfresco.repo.webservice.types.CMLCreateAssociation;
import org.alfresco.repo.webservice.types.CMLDelete;
import org.alfresco.repo.webservice.types.CMLMove;
import org.alfresco.repo.webservice.types.CMLRemoveAspect;
import org.alfresco.repo.webservice.types.CMLRemoveAssociation;
import org.alfresco.repo.webservice.types.CMLRemoveChild;
import org.alfresco.repo.webservice.types.CMLUpdate;
import org.alfresco.repo.webservice.types.CMLWriteContent;
import org.alfresco.repo.webservice.types.ContentFormat;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.repo.webservice.types.ParentReference;
import org.alfresco.repo.webservice.types.Predicate;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLUtil {
    private static Log logger = LogFactory.getLog(CMLUtil.class);
    private static final String CREATE = "create";
    private static final String ADD_ASPECT = "addAspect";
    private static final String REMOVE_ASPECT = "removeAspect";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String MOVE = "move";
    private static final String COPY = "copy";
    private static final String ADD_CHILD = "addChild";
    private static final String REMOVE_CHILD = "removeChild";
    private static final String CREATE_ASSOCIATION = "createAssociation";
    private static final String REMOVE_ASSOCIATION = "removeAssociation";
    private static final String WRITE_CONTENT = "writeContent";
    private NodeService nodeService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private CopyService copyService;
    private DictionaryService dictionaryService;
    private ContentService contentService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public UpdateResult[] executeCML(CML cml) {
        CMLRemoveAssociation[] removeAssocs;
        CMLCreateAssociation[] createAssocs;
        CMLRemoveChild[] removeChildren;
        CMLAddChild[] addChildren;
        CMLCopy[] copies;
        CMLMove[] moves;
        CMLDelete[] deletes;
        CMLWriteContent[] writes;
        CMLUpdate[] updates;
        CMLRemoveAspect[] removeAspects;
        CMLAddAspect[] addAspects;
        ExecutionContext context = new ExecutionContext();
        ArrayList<UpdateResult> results = new ArrayList<UpdateResult>();
        CMLCreate[] creates = cml.getCreate();
        if (creates != null) {
            for (CMLCreate create : creates) {
                this.executeCMLCreate(create, context, results);
            }
        }
        if ((addAspects = cml.getAddAspect()) != null) {
            for (CMLAddAspect addAspect : addAspects) {
                this.executeCMLAddAspect(addAspect, context, results);
            }
        }
        if ((removeAspects = cml.getRemoveAspect()) != null) {
            for (CMLRemoveAspect removeAspect : removeAspects) {
                this.executeCMLRemoveAspect(removeAspect, context, results);
            }
        }
        if ((updates = cml.getUpdate()) != null) {
            for (CMLUpdate update : updates) {
                this.executeCMLUpdate(update, context, results);
            }
        }
        if ((writes = cml.getWriteContent()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(writes.length + " write content statements ready for execution."));
            }
            for (CMLWriteContent write : writes) {
                this.executeCMLWriteContent(write, context, results);
            }
        }
        if ((deletes = cml.getDelete()) != null) {
            for (CMLDelete delete : deletes) {
                this.executeCMLDelete(delete, context, results);
            }
        }
        if ((moves = cml.getMove()) != null) {
            for (CMLMove move : moves) {
                this.executeCMLMove(move, context, results);
            }
        }
        if ((copies = cml.getCopy()) != null) {
            for (CMLCopy copy : copies) {
                this.executeCMLCopy(copy, context, results);
            }
        }
        if ((addChildren = cml.getAddChild()) != null) {
            for (CMLAddChild addChild : addChildren) {
                this.executeCMLAddChild(addChild, context, results);
            }
        }
        if ((removeChildren = cml.getRemoveChild()) != null) {
            for (CMLRemoveChild removeChild : removeChildren) {
                this.executeCMLRemoveChild(removeChild, context, results);
            }
        }
        if ((createAssocs = cml.getCreateAssociation()) != null) {
            for (CMLCreateAssociation createAssoc : createAssocs) {
                this.executeCMLCreateAssociation(createAssoc, context, results);
            }
        }
        if ((removeAssocs = cml.getRemoveAssociation()) != null) {
            for (CMLRemoveAssociation removeAssoc : removeAssocs) {
                this.executeCMLRemoveAssociation(removeAssoc, context, results);
            }
        }
        return results.toArray(new UpdateResult[results.size()]);
    }

    private void executeCMLCreate(CMLCreate create, ExecutionContext context, List<UpdateResult> results) {
        NodeRef parentNodeRef = null;
        QName assocTypeQName = null;
        QName assocQName = null;
        ParentReference parentReference = create.getParent();
        if (parentReference != null) {
            parentNodeRef = Utils.convertToNodeRef(parentReference, this.nodeService, this.searchService, this.namespaceService);
            assocTypeQName = QName.createQName((String)parentReference.getAssociationType());
            assocQName = QName.createQName((String)parentReference.getChildName());
        } else {
            String parentId = create.getParent_id();
            if (parentId != null) {
                parentNodeRef = (NodeRef)context.idMap.get(parentId);
            }
            assocTypeQName = QName.createQName((String)create.getAssociationType());
            assocQName = QName.createQName((String)create.getChildName());
        }
        if (parentNodeRef == null) {
            throw new AlfrescoRuntimeException("No parent details have been specified for the node being created.");
        }
        QName nodeTypeQName = QName.createQName((String)create.getType());
        PropertyMap properties = this.getPropertyMap(create.getProperty());
        NodeRef nodeRef = this.nodeService.createNode(parentNodeRef, assocTypeQName, assocQName, nodeTypeQName, (Map)properties).getChildRef();
        String id = create.getId();
        if (id != null && id.length() != 0) {
            context.addId(id, nodeRef);
        }
        results.add(this.createResult(CREATE, id, null, nodeRef));
    }

    private PropertyMap getPropertyMap(NamedValue[] namedValues) {
        PropertyMap properties = new PropertyMap();
        if (namedValues != null) {
            for (NamedValue value : namedValues) {
                QName qname = QName.createQName((String)value.getName());
                Serializable propValue = Utils.getValueFromNamedValue(this.dictionaryService, qname, value);
                properties.put((Object)qname, (Object)propValue);
            }
        }
        return properties;
    }

    private UpdateResult createResult(String cmd, String sourceId, NodeRef sourceNodeRef, NodeRef destinationNodeRef) {
        UpdateResult result = new UpdateResult();
        result.setStatement(cmd);
        if (sourceId != null) {
            result.setSourceId(sourceId);
        }
        if (sourceNodeRef != null) {
            result.setSource(Utils.convertToReference(this.nodeService, this.namespaceService, sourceNodeRef));
        }
        if (destinationNodeRef != null) {
            result.setDestination(Utils.convertToReference(this.nodeService, this.namespaceService, destinationNodeRef));
        }
        return result;
    }

    private void executeCMLAddAspect(CMLAddAspect addAspect, ExecutionContext context, List<UpdateResult> results) {
        List<NodeRef> nodeRefs = this.getNodeRefList(addAspect.getWhere_id(), addAspect.getWhere(), context);
        QName aspectQName = QName.createQName((String)addAspect.getAspect());
        PropertyMap properties = this.getPropertyMap(addAspect.getProperty());
        for (NodeRef nodeRef : nodeRefs) {
            this.nodeService.addAspect(nodeRef, aspectQName, (Map)properties);
            results.add(this.createResult(ADD_ASPECT, null, nodeRef, nodeRef));
        }
    }

    private void executeCMLRemoveAspect(CMLRemoveAspect removeAspect, ExecutionContext context, List<UpdateResult> results) {
        List<NodeRef> nodeRefs = this.getNodeRefList(removeAspect.getWhere_id(), removeAspect.getWhere(), context);
        QName aspectQName = QName.createQName((String)removeAspect.getAspect());
        for (NodeRef nodeRef : nodeRefs) {
            this.nodeService.removeAspect(nodeRef, aspectQName);
            results.add(this.createResult(REMOVE_ASPECT, null, nodeRef, nodeRef));
        }
    }

    private List<NodeRef> getNodeRefList(String id, Predicate predicate, ExecutionContext context) {
        NodeRef localNodeRef;
        boolean bResolved = false;
        List<NodeRef> nodeRefs = new ArrayList<NodeRef>();
        if (id != null && id.length() != 0 && (localNodeRef = context.getNodeRef(id)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Local node ref has been resolved for id = " + id));
            }
            nodeRefs.add(localNodeRef);
            bResolved = true;
        }
        if (!bResolved) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Trying to resolve predicate for where statement");
                if (predicate.getNodes() == null) {
                    logger.debug((Object)"!! Predicate has no nodes !!");
                }
            }
            nodeRefs = Utils.resolvePredicate(predicate, this.nodeService, this.searchService, this.namespaceService);
        }
        return nodeRefs;
    }

    private void executeCMLUpdate(CMLUpdate update, ExecutionContext context, List<UpdateResult> results) {
        List<NodeRef> nodeRefs = this.getNodeRefList(update.getWhere_id(), update.getWhere(), context);
        PropertyMap props = this.getPropertyMap(update.getProperty());
        for (NodeRef nodeRef : nodeRefs) {
            Map currentProps = this.nodeService.getProperties(nodeRef);
            currentProps.putAll(props);
            this.nodeService.setProperties(nodeRef, currentProps);
            results.add(this.createResult(UPDATE, null, nodeRef, nodeRef));
        }
    }

    private void executeCMLWriteContent(CMLWriteContent write, ExecutionContext context, List<UpdateResult> results) {
        List<NodeRef> nodeRefs = this.getNodeRefList(write.getWhere_id(), write.getWhere(), context);
        QName property = QName.createQName((String)write.getProperty());
        ContentFormat format = write.getFormat();
        byte[] content = write.getContent();
        if (logger.isDebugEnabled()) {
            if (nodeRefs != null) {
                logger.debug((Object)("Write content: " + nodeRefs.size() + " nodes found for execution"));
            } else {
                logger.debug((Object)"No nodes found to write content to!");
            }
        }
        if (nodeRefs != null) {
            for (NodeRef nodeRef : nodeRefs) {
                ContentWriter writer = this.contentService.getWriter(nodeRef, property, true);
                if (format != null) {
                    writer.setEncoding(format.getEncoding());
                    writer.setMimetype(format.getMimetype());
                }
                ByteArrayInputStream is = new ByteArrayInputStream(content);
                writer.putContent((InputStream)is);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Write content: content written on node " + nodeRef.toString() + " with format " + format.getMimetype() + "|" + format.getEncoding()));
                }
                results.add(this.createResult(WRITE_CONTENT, null, nodeRef, nodeRef));
            }
        }
    }

    private void executeCMLDelete(CMLDelete delete, ExecutionContext context, List<UpdateResult> results) {
        List<NodeRef> nodeRefs = Utils.resolvePredicate(delete.getWhere(), this.nodeService, this.searchService, this.namespaceService);
        for (NodeRef nodeRef : nodeRefs) {
            this.nodeService.deleteNode(nodeRef);
            results.add(this.createResult(DELETE, null, nodeRef, null));
        }
    }

    private void executeCMLMove(CMLMove move, ExecutionContext context, List<UpdateResult> results) {
        NodeRef destinationNodeRef = this.getNodeRef(move.getTo_id(), move.getTo(), context);
        if (destinationNodeRef != null) {
            QName assocType = null;
            QName assocName = null;
            if (move.getTo_id() != null) {
                assocType = QName.createQName((String)move.getAssociationType());
                assocName = QName.createQName((String)move.getChildName());
            } else {
                assocType = QName.createQName((String)move.getTo().getAssociationType());
                assocName = QName.createQName((String)move.getTo().getChildName());
            }
            List<NodeRef> nodesToMove = this.getNodeRefList(move.getWhere_id(), move.getWhere(), context);
            for (NodeRef nodeToMove : nodesToMove) {
                NodeRef newNodeRef = this.nodeService.moveNode(nodeToMove, destinationNodeRef, assocType, assocName).getChildRef();
                results.add(this.createResult(MOVE, null, nodeToMove, newNodeRef));
            }
        }
    }

    private NodeRef getNodeRef(String id, ParentReference parentReference, ExecutionContext context) {
        NodeRef nodeRef = null;
        nodeRef = id != null && id.length() != 0 ? context.getNodeRef(id) : Utils.convertToNodeRef(parentReference, this.nodeService, this.searchService, this.namespaceService);
        return nodeRef;
    }

    private NodeRef getNodeRef(String id, Reference reference, ExecutionContext context) {
        NodeRef nodeRef = null;
        nodeRef = id != null && id.length() != 0 ? context.getNodeRef(id) : Utils.convertToNodeRef(reference, this.nodeService, this.searchService, this.namespaceService);
        return nodeRef;
    }

    private void executeCMLCopy(CMLCopy copy, ExecutionContext context, List<UpdateResult> results) {
        NodeRef destinationNodeRef = this.getNodeRef(copy.getTo_id(), copy.getTo(), context);
        if (destinationNodeRef != null) {
            QName assocType = null;
            QName assocName = null;
            if (copy.getTo_id() != null) {
                assocType = QName.createQName((String)copy.getAssociationType());
                assocName = QName.createQName((String)copy.getChildName());
            } else {
                assocType = QName.createQName((String)copy.getTo().getAssociationType());
                assocName = QName.createQName((String)copy.getTo().getChildName());
            }
            boolean copyChildren = false;
            Boolean value = copy.getChildren();
            if (value != null) {
                copyChildren = value;
            }
            List<NodeRef> nodesToCopy = this.getNodeRefList(copy.getWhere_id(), copy.getWhere(), context);
            for (NodeRef nodeToCopy : nodesToCopy) {
                NodeRef newNodeRef = this.copyService.copyAndRename(nodeToCopy, destinationNodeRef, assocType, assocName, copyChildren);
                results.add(this.createResult(COPY, null, nodeToCopy, newNodeRef));
            }
        }
    }

    private void executeCMLAddChild(CMLAddChild addChild, ExecutionContext context, List<UpdateResult> results) {
        NodeRef nodeRef = this.getNodeRef(addChild.getTo_id(), addChild.getTo(), context);
        if (nodeRef != null) {
            QName assocType = null;
            QName assocName = null;
            if (addChild.getTo_id() != null) {
                assocType = QName.createQName((String)addChild.getAssociationType());
                assocName = QName.createQName((String)addChild.getChildName());
            } else {
                assocType = QName.createQName((String)addChild.getTo().getAssociationType());
                assocName = QName.createQName((String)addChild.getTo().getChildName());
            }
            List<NodeRef> whereNodeRefs = this.getNodeRefList(addChild.getWhere_id(), addChild.getWhere(), context);
            for (NodeRef whereNodeRef : whereNodeRefs) {
                this.nodeService.addChild(nodeRef, whereNodeRef, assocType, assocName);
                results.add(this.createResult(ADD_CHILD, null, nodeRef, whereNodeRef));
            }
        }
    }

    private void executeCMLRemoveChild(CMLRemoveChild removeChild, ExecutionContext context, List<UpdateResult> results) {
        NodeRef parentNodeRef = this.getNodeRef(removeChild.getFrom_id(), removeChild.getFrom(), context);
        if (parentNodeRef != null) {
            List<NodeRef> childNodeRefs = this.getNodeRefList(removeChild.getWhere_id(), removeChild.getWhere(), context);
            for (NodeRef childNodeRef : childNodeRefs) {
                this.nodeService.removeChild(parentNodeRef, childNodeRef);
                results.add(this.createResult(REMOVE_CHILD, null, parentNodeRef, null));
            }
        }
    }

    private void executeCMLCreateAssociation(CMLCreateAssociation createAssoc, ExecutionContext context, List<UpdateResult> results) {
        QName assocType = QName.createQName((String)createAssoc.getAssociation());
        if (assocType != null) {
            List<NodeRef> fromNodeRefs = this.getNodeRefList(createAssoc.getFrom_id(), createAssoc.getFrom(), context);
            List<NodeRef> toNodeRefs = this.getNodeRefList(createAssoc.getTo_id(), createAssoc.getTo(), context);
            for (NodeRef fromNodeRef : fromNodeRefs) {
                for (NodeRef toNodeRef : toNodeRefs) {
                    this.nodeService.createAssociation(fromNodeRef, toNodeRef, assocType);
                    results.add(this.createResult(CREATE_ASSOCIATION, null, fromNodeRef, toNodeRef));
                }
            }
        }
    }

    private void executeCMLRemoveAssociation(CMLRemoveAssociation removeAssoc, ExecutionContext context, List<UpdateResult> results) {
        QName assocType = QName.createQName((String)removeAssoc.getAssociation());
        if (assocType != null) {
            List<NodeRef> fromNodeRefs = this.getNodeRefList(removeAssoc.getFrom_id(), removeAssoc.getFrom(), context);
            List<NodeRef> toNodeRefs = this.getNodeRefList(removeAssoc.getTo_id(), removeAssoc.getTo(), context);
            for (NodeRef fromNodeRef : fromNodeRefs) {
                for (NodeRef toNodeRef : toNodeRefs) {
                    this.nodeService.removeAssociation(fromNodeRef, toNodeRef, assocType);
                    results.add(this.createResult(REMOVE_ASSOCIATION, null, fromNodeRef, toNodeRef));
                }
            }
        }
    }

    private class ExecutionContext {
        private Map<String, NodeRef> idMap = new HashMap<String, NodeRef>();
        private Map<NodeRef, String> nodeRefMap = new HashMap<NodeRef, String>();

        private ExecutionContext() {
        }

        public void addId(String id, NodeRef nodeRef) {
            this.idMap.put(id, nodeRef);
            this.nodeRefMap.put(nodeRef, id);
        }

        public NodeRef getNodeRef(String id) {
            return this.idMap.get(id);
        }

        public String getId(NodeRef nodeRef) {
            return this.nodeRefMap.get(nodeRef);
        }
    }
}

