/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice;

import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.webservice.CMLUtil;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.repository.UpdateResult;
import org.alfresco.repo.webservice.types.CML;
import org.alfresco.repo.webservice.types.CMLAddAspect;
import org.alfresco.repo.webservice.types.CMLAddChild;
import org.alfresco.repo.webservice.types.CMLCopy;
import org.alfresco.repo.webservice.types.CMLCreate;
import org.alfresco.repo.webservice.types.CMLCreateAssociation;
import org.alfresco.repo.webservice.types.CMLDelete;
import org.alfresco.repo.webservice.types.CMLMove;
import org.alfresco.repo.webservice.types.CMLRemoveAspect;
import org.alfresco.repo.webservice.types.CMLRemoveAssociation;
import org.alfresco.repo.webservice.types.CMLRemoveChild;
import org.alfresco.repo.webservice.types.CMLUpdate;
import org.alfresco.repo.webservice.types.CMLWriteContent;
import org.alfresco.repo.webservice.types.ContentFormat;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.repo.webservice.types.ParentReference;
import org.alfresco.repo.webservice.types.Predicate;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.PropertyMap;

public class CMLUtilTest
extends BaseSpringTest {
    private static final ContentData CONTENT_DATA_TEXT_UTF8 = new ContentData(null, "text/plain", 0L, "UTF-8");
    private static final ContentData CONTENT_DATA_HTML_UTF16 = new ContentData(null, "text/html", 0L, "UTF-16");
    private static final String TEST_CONTENT = "This is some test content";
    private CMLUtil cmlUtil;
    private NodeService nodeService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private NodeRef folderNodeRef;
    private AuthenticationComponent authenticationComponent;
    private ContentService contentService;

    protected String[] getConfigLocations() {
        return new String[]{"classpath:org/alfresco/repo/webservice/cml-test.xml"};
    }

    protected void onSetUpInTransaction() throws Exception {
        this.cmlUtil = (CMLUtil)this.applicationContext.getBean("CMLUtil");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.searchService = (SearchService)this.applicationContext.getBean("searchService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        PropertyMap contentProps = new PropertyMap();
        contentProps.put((Object)ContentModel.PROP_CONTENT, (Object)CONTENT_DATA_TEXT_UTF8);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, (Map)contentProps).getChildRef();
        this.folderNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER).getChildRef();
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    public void testMoreThanOneStatement() {
    }

    public void testCreate() {
        CMLCreate[] creates = new CMLCreate[]{this.createCMLCreate(ContentModel.TYPE_CONTENT, "id1")};
        CML cml = new CML();
        cml.setCreate(creates);
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"create", (String)updateResult.getStatement());
        CMLUtilTest.assertNull((Object)updateResult.getSource());
        CMLUtilTest.assertNotNull((Object)updateResult.getDestination());
        NodeRef createdNodeRef = Utils.convertToNodeRef(updateResult.getDestination(), this.nodeService, this.searchService, this.namespaceService);
        CMLUtilTest.assertNotNull((Object)createdNodeRef);
        CMLUtilTest.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(createdNodeRef));
        CMLUtilTest.assertEquals((Object)"name", (Object)this.nodeService.getProperty(createdNodeRef, ContentModel.PROP_NAME));
    }

    public void testAddRemoveAspect() {
        CMLAddAspect addAspect = new CMLAddAspect();
        addAspect.setAspect(ContentModel.ASPECT_VERSIONABLE.toString());
        addAspect.setWhere(this.createPredicate(this.nodeRef));
        CML cml = new CML();
        cml.setAddAspect(new CMLAddAspect[]{addAspect});
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"addAspect", (String)updateResult.getStatement());
        CMLUtilTest.assertNotNull((Object)updateResult.getSource());
        CMLUtilTest.assertNotNull((Object)updateResult.getDestination());
        CMLUtilTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        CMLRemoveAspect removeAspect = new CMLRemoveAspect();
        removeAspect.setAspect(ContentModel.ASPECT_VERSIONABLE.toString());
        removeAspect.setWhere(this.createPredicate(this.nodeRef));
        CML cml2 = new CML();
        cml2.setRemoveAspect(new CMLRemoveAspect[]{removeAspect});
        UpdateResult[] results2 = this.cmlUtil.executeCML(cml2);
        CMLUtilTest.assertNotNull((Object)results2);
        CMLUtilTest.assertEquals((int)1, (int)results2.length);
        UpdateResult result2 = results2[0];
        CMLUtilTest.assertEquals((String)"removeAspect", (String)result2.getStatement());
        CMLUtilTest.assertNotNull((Object)result2.getDestination());
        CMLUtilTest.assertNotNull((Object)result2.getSource());
        CMLUtilTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
    }

    public void testUpdate() {
        CMLUpdate update = new CMLUpdate();
        update.setWhere(this.createPredicate(this.nodeRef));
        update.setProperty(new NamedValue[]{new NamedValue(ContentModel.PROP_NAME.toString(), false, "updatedName", null), new NamedValue(ContentModel.PROP_CONTENT.toString(), false, CONTENT_DATA_HTML_UTF16.toString(), null)});
        CML cml = new CML();
        cml.setUpdate(new CMLUpdate[]{update});
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"update", (String)updateResult.getStatement());
        CMLUtilTest.assertNotNull((Object)updateResult.getSource());
        CMLUtilTest.assertNotNull((Object)updateResult.getDestination());
        CMLUtilTest.assertEquals((Object)"updatedName", (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_NAME));
        CMLUtilTest.assertEquals((Object)CONTENT_DATA_HTML_UTF16, (Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_CONTENT));
    }

    public void testWriteContent() {
        CMLWriteContent write = new CMLWriteContent();
        write.setWhere(this.createPredicate(this.nodeRef));
        write.setProperty(ContentModel.PROP_CONTENT.toString());
        ContentFormat format = new ContentFormat("text/plain", "UTF-8");
        write.setFormat(format);
        write.setContent(TEST_CONTENT.getBytes());
        CML cml = new CML();
        cml.setWriteContent(new CMLWriteContent[]{write});
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"writeContent", (String)updateResult.getStatement());
        CMLUtilTest.assertNotNull((Object)updateResult.getSource());
        CMLUtilTest.assertNotNull((Object)updateResult.getDestination());
        ContentReader reader = this.contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        CMLUtilTest.assertNotNull((Object)reader);
        CMLUtilTest.assertEquals((String)reader.getContentString(), (String)TEST_CONTENT);
    }

    public void testDelete() {
        CMLDelete delete = new CMLDelete();
        delete.setWhere(this.createPredicate(this.nodeRef));
        CML cml = new CML();
        cml.setDelete(new CMLDelete[]{delete});
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"delete", (String)updateResult.getStatement());
        CMLUtilTest.assertNotNull((Object)updateResult.getSource());
        CMLUtilTest.assertNull((Object)updateResult.getDestination());
        CMLUtilTest.assertFalse((boolean)this.nodeService.exists(this.nodeRef));
    }

    public void testMove() {
        CMLMove move = new CMLMove();
        move.setTo(this.createParentReference(this.folderNodeRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS));
        move.setWhere(this.createPredicate(this.nodeRef));
        CML cml = new CML();
        cml.setMove(new CMLMove[]{move});
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"move", (String)updateResult.getStatement());
        CMLUtilTest.assertNotNull((Object)updateResult.getSource());
        CMLUtilTest.assertNotNull((Object)updateResult.getDestination());
        List assocs = this.nodeService.getChildAssocs(this.folderNodeRef);
        CMLUtilTest.assertNotNull((Object)assocs);
        CMLUtilTest.assertEquals((int)1, (int)assocs.size());
        ChildAssociationRef assoc = (ChildAssociationRef)assocs.get(0);
        CMLUtilTest.assertEquals((Object)assoc.getChildRef(), (Object)Utils.convertToNodeRef(updateResult.getDestination(), this.nodeService, this.searchService, this.namespaceService));
    }

    public void testCopy() {
        CMLCopy copy = new CMLCopy();
        copy.setTo(this.createParentReference(this.folderNodeRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS));
        copy.setWhere(this.createPredicate(this.nodeRef));
        CML cml = new CML();
        cml.setCopy(new CMLCopy[]{copy});
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"copy", (String)updateResult.getStatement());
        CMLUtilTest.assertNotNull((Object)updateResult.getSource());
        CMLUtilTest.assertNotNull((Object)updateResult.getDestination());
        List assocs = this.nodeService.getChildAssocs(this.folderNodeRef);
        CMLUtilTest.assertNotNull((Object)assocs);
        CMLUtilTest.assertEquals((int)1, (int)assocs.size());
        ChildAssociationRef assoc = (ChildAssociationRef)assocs.get(0);
        CMLUtilTest.assertEquals((Object)assoc.getChildRef(), (Object)Utils.convertToNodeRef(updateResult.getDestination(), this.nodeService, this.searchService, this.namespaceService));
    }

    public void testAddChild() {
        CMLAddChild addChild = new CMLAddChild();
        addChild.setTo(this.createParentReference(this.folderNodeRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS));
        addChild.setWhere(this.createPredicate(this.nodeRef));
        CML cml = new CML();
        cml.setAddChild(new CMLAddChild[]{addChild});
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"addChild", (String)updateResult.getStatement());
        CMLUtilTest.assertNotNull((Object)updateResult.getSource());
        CMLUtilTest.assertNotNull((Object)updateResult.getDestination());
        List assocs = this.nodeService.getChildAssocs(this.folderNodeRef);
        CMLUtilTest.assertNotNull((Object)assocs);
        CMLUtilTest.assertEquals((int)1, (int)assocs.size());
        ChildAssociationRef assoc = (ChildAssociationRef)assocs.get(0);
        CMLUtilTest.assertEquals((Object)assoc.getChildRef(), (Object)Utils.convertToNodeRef(updateResult.getDestination(), this.nodeService, this.searchService, this.namespaceService));
    }

    public void testRemoveChild() {
        this.nodeService.addChild(this.folderNodeRef, this.nodeRef, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS);
        CMLRemoveChild removeChild = new CMLRemoveChild();
        removeChild.setFrom(Utils.convertToReference(this.nodeService, this.namespaceService, this.folderNodeRef));
        removeChild.setWhere(this.createPredicate(this.nodeRef));
        CML cml = new CML();
        cml.setRemoveChild(new CMLRemoveChild[]{removeChild});
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"removeChild", (String)updateResult.getStatement());
        CMLUtilTest.assertNotNull((Object)updateResult.getSource());
        CMLUtilTest.assertNull((Object)updateResult.getDestination());
        List assocs = this.nodeService.getChildAssocs(this.folderNodeRef);
        CMLUtilTest.assertEquals((int)0, (int)assocs.size());
    }

    public void testCreateAssociation() {
        CMLCreateAssociation createAssoc = new CMLCreateAssociation();
        createAssoc.setAssociation(ContentModel.ASSOC_CONTAINS.toString());
        createAssoc.setFrom(this.createPredicate(this.folderNodeRef));
        createAssoc.setTo(this.createPredicate(this.nodeRef));
        CML cml = new CML();
        cml.setCreateAssociation(new CMLCreateAssociation[]{createAssoc});
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"createAssociation", (String)updateResult.getStatement());
        CMLUtilTest.assertNotNull((Object)updateResult.getSource());
        CMLUtilTest.assertNotNull((Object)updateResult.getDestination());
        List assocs = this.nodeService.getTargetAssocs(this.folderNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS);
        CMLUtilTest.assertNotNull((Object)assocs);
        CMLUtilTest.assertEquals((int)1, (int)assocs.size());
        AssociationRef assoc = (AssociationRef)assocs.get(0);
        CMLUtilTest.assertEquals((Object)assoc.getTargetRef(), (Object)Utils.convertToNodeRef(updateResult.getDestination(), this.nodeService, this.searchService, this.namespaceService));
    }

    public void testRemoveAssociation() {
        this.nodeService.createAssociation(this.folderNodeRef, this.nodeRef, ContentModel.ASSOC_CONTAINS);
        CMLRemoveAssociation removeAssociation = new CMLRemoveAssociation();
        removeAssociation.setAssociation(ContentModel.ASSOC_CONTAINS.toString());
        removeAssociation.setFrom(this.createPredicate(this.folderNodeRef));
        removeAssociation.setTo(this.createPredicate(this.nodeRef));
        CML cml = new CML();
        cml.setRemoveAssociation(new CMLRemoveAssociation[]{removeAssociation});
        UpdateResult[] result = this.cmlUtil.executeCML(cml);
        CMLUtilTest.assertNotNull((Object)result);
        CMLUtilTest.assertEquals((int)1, (int)result.length);
        UpdateResult updateResult = result[0];
        CMLUtilTest.assertEquals((String)"removeAssociation", (String)updateResult.getStatement());
        CMLUtilTest.assertNotNull((Object)updateResult.getSource());
        CMLUtilTest.assertNotNull((Object)updateResult.getDestination());
        List assocs = this.nodeService.getTargetAssocs(this.folderNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS);
        CMLUtilTest.assertNotNull((Object)assocs);
        CMLUtilTest.assertEquals((int)0, (int)assocs.size());
    }

    private ParentReference createParentReference(NodeRef nodeRef, QName assocType, QName assocName) {
        ParentReference parentReference = new ParentReference();
        parentReference.setAssociationType(assocType.toString());
        parentReference.setChildName(assocName.toString());
        parentReference.setStore(Utils.convertToStore(nodeRef.getStoreRef()));
        parentReference.setUuid(nodeRef.getId());
        return parentReference;
    }

    private Predicate createPredicate(NodeRef nodeRef) {
        Predicate predicate = new Predicate();
        predicate.setStore(Utils.convertToStore(nodeRef.getStoreRef()));
        predicate.setNodes(new Reference[]{Utils.convertToReference(this.nodeService, this.namespaceService, nodeRef)});
        return predicate;
    }

    private CMLCreate createCMLCreate(QName type, String id) {
        CMLCreate create = new CMLCreate();
        create.setId("id1");
        create.setType(ContentModel.TYPE_CONTENT.toString());
        ParentReference parentReference = new ParentReference();
        parentReference.setAssociationType(ContentModel.ASSOC_CHILDREN.toString());
        parentReference.setChildName(ContentModel.ASSOC_CHILDREN.toString());
        parentReference.setStore(Utils.convertToStore(this.testStoreRef));
        parentReference.setUuid(this.rootNodeRef.getId());
        create.setParent(parentReference);
        create.setProperty(this.getContentNamedValues());
        return create;
    }

    private NamedValue[] getContentNamedValues() {
        return new NamedValue[]{new NamedValue(ContentModel.PROP_NAME.toString(), false, "name", null), new NamedValue(ContentModel.PROP_CONTENT.toString(), false, CONTENT_DATA_TEXT_UTF8.toString(), null)};
    }
}

