/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.authoring;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webservice.AbstractWebService;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.authoring.AuthoringFault;
import org.alfresco.repo.webservice.authoring.AuthoringServiceSoapPort;
import org.alfresco.repo.webservice.authoring.CancelCheckoutResult;
import org.alfresco.repo.webservice.authoring.CheckinResult;
import org.alfresco.repo.webservice.authoring.CheckoutResult;
import org.alfresco.repo.webservice.authoring.LockStatus;
import org.alfresco.repo.webservice.authoring.LockTypeEnum;
import org.alfresco.repo.webservice.authoring.VersionResult;
import org.alfresco.repo.webservice.types.ContentFormat;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.repo.webservice.types.ParentReference;
import org.alfresco.repo.webservice.types.Predicate;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.repo.webservice.types.Version;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringWebService
extends AbstractWebService
implements AuthoringServiceSoapPort {
    private static Log logger = LogFactory.getLog(AuthoringWebService.class);
    private CheckOutCheckInService cociService;
    private LockService lockService;
    private VersionService versionService;
    private TransactionService transactionService;

    public void setCheckOutCheckinService(CheckOutCheckInService cociService) {
        this.cociService = cociService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    public CheckoutResult checkout(final Predicate items, final ParentReference destination) throws RemoteException, AuthoringFault {
        try {
            return (CheckoutResult)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CheckoutResult>(){

                public CheckoutResult execute() {
                    List<NodeRef> nodes = Utils.resolvePredicate(items, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    CheckoutResult checkoutResult = new CheckoutResult();
                    Reference[] originals = new Reference[nodes.size()];
                    Reference[] workingCopies = new Reference[nodes.size()];
                    NodeRef destinationRef = null;
                    if (destination != null) {
                        destinationRef = Utils.convertToNodeRef(destination, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    }
                    for (int x = 0; x < nodes.size(); ++x) {
                        NodeRef original = nodes.get(x);
                        NodeRef workingCopy = null;
                        workingCopy = destinationRef != null ? AuthoringWebService.this.cociService.checkout(original, destinationRef, QName.createQName((String)destination.getAssociationType()), QName.createQName((String)destination.getChildName())) : AuthoringWebService.this.cociService.checkout(original);
                        originals[x] = Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, original);
                        workingCopies[x] = Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, workingCopy);
                    }
                    checkoutResult.setOriginals(originals);
                    checkoutResult.setWorkingCopies(workingCopies);
                    return checkoutResult;
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new AuthoringFault(0, e.getMessage());
        }
    }

    @Override
    public CheckinResult checkin(final Predicate items, final NamedValue[] comments, final boolean keepCheckedOut) throws RemoteException, AuthoringFault {
        try {
            return (CheckinResult)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CheckinResult>(){

                public CheckinResult execute() {
                    List<NodeRef> nodes = Utils.resolvePredicate(items, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    Map mapComments = AuthoringWebService.this.convertCommnets(comments);
                    Reference[] checkedIn = new Reference[nodes.size()];
                    ArrayList<Reference> listWorkingCopies = new ArrayList<Reference>(nodes.size());
                    int iIndex = 0;
                    for (NodeRef node : nodes) {
                        NodeRef checkedInNode = AuthoringWebService.this.cociService.checkin(node, mapComments, null, keepCheckedOut);
                        checkedIn[iIndex] = Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, checkedInNode);
                        if (keepCheckedOut) {
                            listWorkingCopies.add(Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, node));
                        }
                        ++iIndex;
                    }
                    Reference[] workingCopies = listWorkingCopies.toArray(new Reference[listWorkingCopies.size()]);
                    if (workingCopies == null) {
                        workingCopies = new Reference[]{};
                    }
                    CheckinResult result = new CheckinResult();
                    result.setCheckedIn(checkedIn);
                    result.setWorkingCopies(workingCopies);
                    return result;
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new AuthoringFault(0, e.getMessage());
        }
    }

    private Map<String, Serializable> convertCommnets(NamedValue[] comments) {
        HashMap<String, Serializable> mapComments = new HashMap<String, Serializable>(comments.length);
        for (NamedValue value : comments) {
            if (value.getName().equals("versionType")) {
                mapComments.put(value.getName(), (Serializable)VersionType.valueOf((String)value.getValue()));
                continue;
            }
            mapComments.put(value.getName(), (Serializable)((Object)value.getValue()));
        }
        return mapComments;
    }

    @Override
    public Reference checkinExternal(final Reference node, final NamedValue[] comments, final boolean keepCheckedOut, final ContentFormat format, final byte[] content) throws RemoteException, AuthoringFault {
        try {
            return (Reference)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Reference>(){

                public Reference execute() {
                    NodeRef nodeRef = Utils.convertToNodeRef(node, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    ContentWriter contentWriter = AuthoringWebService.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, false);
                    if (contentWriter == null) {
                        throw new RuntimeException("Unable to write external content before checkin.");
                    }
                    ByteArrayInputStream is = new ByteArrayInputStream(content);
                    contentWriter.setEncoding(format.getEncoding());
                    contentWriter.setMimetype(format.getMimetype());
                    contentWriter.putContent((InputStream)is);
                    String contentUrl = contentWriter.getContentUrl();
                    Map versionProperties = AuthoringWebService.this.convertCommnets(comments);
                    NodeRef origNodeRef = AuthoringWebService.this.cociService.checkin(nodeRef, versionProperties, contentUrl, keepCheckedOut);
                    return Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, origNodeRef);
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new AuthoringFault(0, e.getMessage());
        }
    }

    @Override
    public CancelCheckoutResult cancelCheckout(final Predicate items) throws RemoteException, AuthoringFault {
        try {
            return (CancelCheckoutResult)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CancelCheckoutResult>(){

                public CancelCheckoutResult execute() {
                    List<NodeRef> nodes = Utils.resolvePredicate(items, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    Reference[] origNodes = new Reference[nodes.size()];
                    Reference[] workingCopies = new Reference[nodes.size()];
                    int iIndex = 0;
                    for (NodeRef node : nodes) {
                        NodeRef origNode = AuthoringWebService.this.cociService.cancelCheckout(node);
                        origNodes[iIndex] = Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, origNode);
                        workingCopies[iIndex] = Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, node);
                        ++iIndex;
                    }
                    CancelCheckoutResult result = new CancelCheckoutResult();
                    result.setOriginals(origNodes);
                    result.setWorkingCopies(workingCopies);
                    return result;
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new AuthoringFault(0, e.getMessage());
        }
    }

    @Override
    public Reference[] lock(final Predicate items, final boolean lockChildren, final LockTypeEnum lockType) throws RemoteException, AuthoringFault {
        try {
            return (Reference[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Reference[]>(){

                public Reference[] execute() {
                    List<NodeRef> nodes = Utils.resolvePredicate(items, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    Reference[] result = new Reference[nodes.size()];
                    int iIndex = 0;
                    for (NodeRef node : nodes) {
                        LockType convertedLockType = AuthoringWebService.this.convertToLockType(lockType);
                        AuthoringWebService.this.lockService.lock(node, convertedLockType, 0, lockChildren);
                        result[iIndex] = Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, node);
                        ++iIndex;
                    }
                    return result;
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new AuthoringFault(0, e.getMessage());
        }
    }

    private LockType convertToLockType(LockTypeEnum lockTypeEnum) {
        LockType lockType = null;
        lockType = lockTypeEnum.equals(LockTypeEnum.write) ? LockType.WRITE_LOCK : LockType.READ_ONLY_LOCK;
        return lockType;
    }

    @Override
    public Reference[] unlock(final Predicate items, final boolean unlockChildren) throws RemoteException, AuthoringFault {
        try {
            return (Reference[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Reference[]>(){

                public Reference[] execute() {
                    List<NodeRef> nodes = Utils.resolvePredicate(items, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    Reference[] result = new Reference[nodes.size()];
                    int iIndex = 0;
                    for (NodeRef node : nodes) {
                        AuthoringWebService.this.lockService.unlock(node, unlockChildren);
                        result[iIndex] = Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, node);
                        ++iIndex;
                    }
                    return result;
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new AuthoringFault(0, e.getMessage());
        }
    }

    @Override
    public LockStatus[] getLockStatus(final Predicate items) throws RemoteException, AuthoringFault {
        try {
            return (LockStatus[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<LockStatus[]>(){

                public LockStatus[] execute() {
                    List<NodeRef> nodes = Utils.resolvePredicate(items, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    LockStatus[] result = new LockStatus[nodes.size()];
                    int iIndex = 0;
                    for (NodeRef node : nodes) {
                        String lockOwner = (String)((Object)AuthoringWebService.this.nodeService.getProperty(node, ContentModel.PROP_LOCK_OWNER));
                        LockTypeEnum lockTypeEnum = AuthoringWebService.this.convertFromLockType(AuthoringWebService.this.lockService.getLockType(node));
                        LockStatus lockStatus = new LockStatus();
                        lockStatus.setLockOwner(lockOwner);
                        lockStatus.setLockType(lockTypeEnum);
                        lockStatus.setNode(Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, node));
                        result[iIndex] = lockStatus;
                        ++iIndex;
                    }
                    return result;
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            e.printStackTrace();
            throw new AuthoringFault(0, e.getMessage());
        }
    }

    private LockTypeEnum convertFromLockType(LockType lockType) {
        LockTypeEnum result = null;
        if (lockType != null) {
            switch (lockType) {
                case WRITE_LOCK: {
                    result = LockTypeEnum.write;
                    break;
                }
                case READ_ONLY_LOCK: {
                    result = LockTypeEnum.read;
                }
            }
        }
        return result;
    }

    @Override
    public VersionResult createVersion(final Predicate items, final NamedValue[] comments, final boolean versionChildren) throws RemoteException, AuthoringFault {
        try {
            return (VersionResult)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<VersionResult>(){

                public VersionResult execute() {
                    List<NodeRef> nodes = Utils.resolvePredicate(items, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    Map mapComments = AuthoringWebService.this.convertCommnets(comments);
                    ArrayList<Reference> versionedReferences = new ArrayList<Reference>(nodes.size());
                    ArrayList<Version> webServiceVersions = new ArrayList<Version>(nodes.size());
                    for (NodeRef node : nodes) {
                        Collection versions = AuthoringWebService.this.versionService.createVersion(node, mapComments, versionChildren);
                        for (org.alfresco.service.cmr.version.Version version : versions) {
                            versionedReferences.add(Utils.convertToReference(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, version.getVersionedNodeRef()));
                            webServiceVersions.add(Utils.convertToVersion(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, version));
                        }
                    }
                    VersionResult result = new VersionResult();
                    result.setNodes(versionedReferences.toArray(new Reference[versionedReferences.size()]));
                    result.setVersions(webServiceVersions.toArray(new Version[webServiceVersions.size()]));
                    return result;
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            e.printStackTrace();
            throw new AuthoringFault(0, e.getMessage());
        }
    }

    @Override
    public org.alfresco.repo.webservice.types.VersionHistory getVersionHistory(final Reference node) throws RemoteException, AuthoringFault {
        try {
            return (org.alfresco.repo.webservice.types.VersionHistory)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<org.alfresco.repo.webservice.types.VersionHistory>(){

                public org.alfresco.repo.webservice.types.VersionHistory execute() {
                    VersionHistory versionHistory = AuthoringWebService.this.versionService.getVersionHistory(Utils.convertToNodeRef(node, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService));
                    org.alfresco.repo.webservice.types.VersionHistory webServiceVersionHistory = new org.alfresco.repo.webservice.types.VersionHistory();
                    if (versionHistory != null) {
                        Collection versions = versionHistory.getAllVersions();
                        Version[] webServiceVersions = new Version[versions.size()];
                        int iIndex = 0;
                        for (org.alfresco.service.cmr.version.Version version : versions) {
                            webServiceVersions[iIndex] = Utils.convertToVersion(AuthoringWebService.this.nodeService, AuthoringWebService.this.namespaceService, version);
                            ++iIndex;
                        }
                        webServiceVersionHistory.setVersions(webServiceVersions);
                    }
                    return webServiceVersionHistory;
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new AuthoringFault(0, e.getMessage());
        }
    }

    @Override
    public void revertVersion(final Reference node, final String versionLabel) throws RemoteException, AuthoringFault {
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() {
                    org.alfresco.service.cmr.version.Version version;
                    NodeRef nodeRef = Utils.convertToNodeRef(node, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    VersionHistory versionHistory = AuthoringWebService.this.versionService.getVersionHistory(nodeRef);
                    if (versionHistory != null) {
                        version = versionHistory.getVersion(versionLabel);
                        if (version == null) {
                            throw new RuntimeException("The node could not be reverted because the version label is invalid.");
                        }
                    } else {
                        throw new RuntimeException("A unversioned node cannot be reverted.");
                    }
                    AuthoringWebService.this.versionService.revert(nodeRef, version);
                    return null;
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new AuthoringFault(0, e.getMessage());
        }
    }

    @Override
    public org.alfresco.repo.webservice.types.VersionHistory deleteAllVersions(final Reference node) throws RemoteException, AuthoringFault {
        try {
            return (org.alfresco.repo.webservice.types.VersionHistory)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<org.alfresco.repo.webservice.types.VersionHistory>(){

                public org.alfresco.repo.webservice.types.VersionHistory execute() {
                    NodeRef nodeRef = Utils.convertToNodeRef(node, AuthoringWebService.this.nodeService, AuthoringWebService.this.searchService, AuthoringWebService.this.namespaceService);
                    AuthoringWebService.this.versionService.deleteVersionHistory(nodeRef);
                    return new org.alfresco.repo.webservice.types.VersionHistory();
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new AuthoringFault(0, e.getMessage());
        }
    }
}

