/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.repository;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.webservice.AbstractQuery;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.repo.webservice.types.ResultSet;
import org.alfresco.repo.webservice.types.ResultSetRow;
import org.alfresco.repo.webservice.types.ResultSetRowNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildAssociationQuery
extends AbstractQuery<ResultSet> {
    private static final long serialVersionUID = -4965097420552826582L;
    private Reference node;

    public ChildAssociationQuery(Reference node) {
        this.node = node;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ChildAssociationQuery").append("[ node=").append(this.node.getUuid()).append("]");
        return sb.toString();
    }

    @Override
    public ResultSet execute(ServiceRegistry serviceRegistry) {
        SearchService searchService = serviceRegistry.getSearchService();
        NodeService nodeService = serviceRegistry.getNodeService();
        DictionaryService dictionaryService = serviceRegistry.getDictionaryService();
        NamespaceService namespaceService = serviceRegistry.getNamespaceService();
        NodeRef nodeRef = Utils.convertToNodeRef(this.node, nodeService, searchService, namespaceService);
        List assocRefs = nodeService.getChildAssocs(nodeRef);
        int totalRows = assocRefs.size();
        ResultSet results = new ResultSet();
        ResultSetRow[] rows = new ResultSetRow[totalRows];
        int index = 0;
        for (ChildAssociationRef assocRef : assocRefs) {
            NodeRef childNodeRef = assocRef.getChildRef();
            ResultSetRowNode rowNode = this.createResultSetRowNode(childNodeRef, nodeService);
            Map props = nodeService.getProperties(childNodeRef);
            NamedValue[] columns = new NamedValue[props.size() + 5];
            int col = 0;
            for (QName propName : props.keySet()) {
                columns[col] = Utils.createNamedValue(dictionaryService, propName, (Serializable)props.get(propName));
                ++col;
            }
            columns[col] = new NamedValue("associationType", Boolean.FALSE, assocRef.getTypeQName().toString(), null);
            columns[++col] = new NamedValue("associationName", Boolean.FALSE, assocRef.getQName().toString(), null);
            columns[++col] = new NamedValue("isPrimary", Boolean.FALSE, Boolean.toString(assocRef.isPrimary()), null);
            columns[++col] = new NamedValue("nthSibling", Boolean.FALSE, Integer.toString(assocRef.getNthSibling()), null);
            columns[++col] = Utils.createNamedValue(dictionaryService, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"path"), (Serializable)((Object)nodeService.getPath(childNodeRef).toString()));
            ResultSetRow row = new ResultSetRow();
            row.setRowIndex(index);
            row.setNode(rowNode);
            row.setColumns(columns);
            rows[index] = row;
            ++index;
        }
        results.setRows(rows);
        results.setTotalRowCount(totalRows);
        return results;
    }
}

