/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.util.Util;

public class SimpleToken
extends AuthToken {
    @Property
    private String auth_value = null;

    public SimpleToken() {
    }

    public SimpleToken(String authvalue) {
        this.auth_value = authvalue;
    }

    public String getName() {
        return "org.jgroups.auth.SimpleToken";
    }

    public String getAuthValue() {
        return this.auth_value;
    }

    public void setAuthValue(String auth_value) {
        this.auth_value = auth_value;
    }

    public boolean authenticate(AuthToken token, Message msg) {
        if (token != null && token instanceof SimpleToken) {
            SimpleToken serverToken = (SimpleToken)token;
            if (this.auth_value != null && serverToken.auth_value != null && this.auth_value.equalsIgnoreCase(serverToken.auth_value)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("SimpleToken match");
                }
                return true;
            }
            return false;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("Invalid AuthToken instance - wrong type or null");
        }
        return false;
    }

    public void writeTo(DataOutputStream out) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SimpleToken writeTo()");
        }
        Util.writeString(this.auth_value, out);
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SimpleToken readFrom()");
        }
        this.auth_value = Util.readString(in);
    }
}

