/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.annotations.Unsupported;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

@Unsupported
public class ReplicatedHashtable
extends Hashtable
implements MessageListener,
MembershipListener {
    transient Channel channel;
    transient PullPushAdapter adapter;
    final transient Vector notifs;
    final transient Vector members;
    final transient List state_transfer_listeners;
    transient boolean state_transfer_running;
    private transient boolean send_message;
    protected final transient Log log;

    public ReplicatedHashtable(String groupname, ChannelFactory factory, StateTransferListener l, String properties, long state_timeout) {
        block3: {
            this.adapter = null;
            this.notifs = new Vector();
            this.members = new Vector();
            this.state_transfer_listeners = new ArrayList();
            this.state_transfer_running = false;
            this.send_message = false;
            this.log = LogFactory.getLog(this.getClass());
            if (l != null) {
                this.addStateTransferListener(l);
            }
            try {
                this.channel = factory != null ? factory.createChannel((Object)properties) : new JChannel(properties);
                this.channel.connect(groupname);
                this.adapter = new PullPushAdapter(this.channel, this, this);
                this.adapter.setListener(this);
                this.getInitState(this.channel, state_timeout);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error("exception=" + e);
            }
        }
    }

    private void getInitState(Channel channel, long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        try {
            this.notifyStateTransferStarted();
            boolean rc = channel.getState(null, state_timeout);
            if (rc) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("state was retrieved successfully");
                }
            } else {
                if (this.log.isInfoEnabled()) {
                    this.log.info("state could not be retrieved (first member)");
                }
                this.notifyStateTransferCompleted(false);
            }
        }
        catch (ChannelClosedException ex) {
            this.notifyStateTransferCompleted(false);
            throw ex;
        }
        catch (ChannelNotConnectedException ex2) {
            this.notifyStateTransferCompleted(false);
            throw ex2;
        }
    }

    public ReplicatedHashtable(String groupname, ChannelFactory factory, String properties, long state_timeout) {
        this(groupname, factory, null, properties, state_timeout);
    }

    public ReplicatedHashtable(JChannel channel, long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        this(channel, null, state_timeout);
    }

    public ReplicatedHashtable(JChannel channel, StateTransferListener l, long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        this.adapter = null;
        this.notifs = new Vector();
        this.members = new Vector();
        this.state_transfer_listeners = new ArrayList();
        this.state_transfer_running = false;
        this.send_message = false;
        this.log = LogFactory.getLog(this.getClass());
        this.channel = channel;
        this.adapter = new PullPushAdapter(channel, this, this);
        this.adapter.setListener(this);
        if (l != null) {
            this.addStateTransferListener(l);
        }
        this.getInitState(channel, state_timeout);
    }

    public boolean stateTransferRunning() {
        return this.state_transfer_running;
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getAddress() : null;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void addNotifier(Notification n) {
        if (!this.notifs.contains(n)) {
            this.notifs.addElement(n);
        }
    }

    public final void addStateTransferListener(StateTransferListener l) {
        if (l != null && !this.state_transfer_listeners.contains(l)) {
            this.state_transfer_listeners.add(l);
        }
    }

    public void removeStateTransferListener(StateTransferListener l) {
        if (l != null) {
            this.state_transfer_listeners.remove(l);
        }
    }

    public Object put(Object key, Object value) {
        Object prev_val = null;
        prev_val = this.get(key);
        if (this.send_message) {
            try {
                Message msg = new Message(null, null, new Request(1, key, value));
                this.channel.send(msg);
            }
            catch (Exception e) {}
        } else {
            super.put(key, value);
        }
        return prev_val;
    }

    public void putAll(Map m) {
        if (this.send_message) {
            try {
                Message msg = new Message(null, null, new Request(4, null, m));
                this.channel.send(msg);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("exception=" + e);
                }
            }
        } else {
            super.putAll(m);
        }
    }

    public void clear() {
        if (this.send_message) {
            try {
                Message msg = new Message(null, null, new Request(3, null, null));
                this.channel.send(msg);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("exception=" + e);
                }
            }
        } else {
            super.clear();
        }
    }

    public Object remove(Object key) {
        Object retval = null;
        retval = this.get(key);
        if (this.send_message) {
            try {
                Message msg = new Message(null, null, new Request(2, key, null));
                this.channel.send(msg);
            }
            catch (Exception e) {}
        } else {
            super.remove(key);
        }
        return retval;
    }

    Object _put(Object key, Object value) {
        Object retval = super.put(key, value);
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entrySet(key, value);
        }
        return retval;
    }

    void _clear() {
        super.clear();
    }

    Object _remove(Object key) {
        Object retval = super.remove(key);
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entryRemoved(key);
        }
        return retval;
    }

    public void _putAll(Map m) {
        if (m == null) {
            return;
        }
        for (Map.Entry entry : m.entrySet()) {
            super.put(entry.getKey(), entry.getValue());
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsSet(m);
        }
    }

    public void receive(Message msg) {
        Request req = null;
        if (msg == null) {
            return;
        }
        req = (Request)msg.getObject();
        if (req == null) {
            return;
        }
        switch (req.req_type) {
            case 1: {
                if (req.key == null || req.val == null) break;
                this._put(req.key, req.val);
                break;
            }
            case 2: {
                if (req.key == null) break;
                this._remove(req.key);
                break;
            }
            case 3: {
                this._clear();
                break;
            }
            case 4: {
                if (req.val == null) break;
                this._putAll((Map)req.val);
                break;
            }
        }
    }

    public byte[] getState() {
        Hashtable copy = new Hashtable();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = this.get(key);
            copy.put(key, val);
        }
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception marshalling state: " + ex);
            }
            return null;
        }
    }

    public void setState(byte[] new_state) {
        Hashtable new_copy;
        try {
            new_copy = (Hashtable)Util.objectFromByteBuffer(new_state);
            if (new_copy == null) {
                this.notifyStateTransferCompleted(true);
                return;
            }
        }
        catch (Throwable ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception unmarshalling state: " + ex);
            }
            this.notifyStateTransferCompleted(false);
            return;
        }
        this._clear();
        Enumeration e = new_copy.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this._put(key, new_copy.get(key));
        }
        this.notifyStateTransferCompleted(true);
    }

    public void viewAccepted(View new_view) {
        Vector<Address> new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            for (int i = 0; i < new_mbrs.size(); ++i) {
                this.members.addElement(new_mbrs.elementAt(i));
            }
        }
        this.send_message = this.members.size() > 1;
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        int i;
        if (this.notifs.size() == 0 || old_mbrs == null || new_mbrs == null || old_mbrs.size() == 0 || new_mbrs.size() == 0) {
            return;
        }
        Vector joined = new Vector();
        for (i = 0; i < new_mbrs.size(); ++i) {
            mbr = new_mbrs.elementAt(i);
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector left = new Vector();
        for (i = 0; i < old_mbrs.size(); ++i) {
            mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        for (i = 0; i < this.notifs.size(); ++i) {
            Notification n = (Notification)this.notifs.elementAt(i);
            n.viewChange(joined, left);
        }
    }

    void notifyStateTransferStarted() {
        this.state_transfer_running = true;
        for (StateTransferListener listener : this.state_transfer_listeners) {
            try {
                listener.stateTransferStarted();
            }
            catch (Throwable throwable) {}
        }
    }

    void notifyStateTransferCompleted(boolean success) {
        this.state_transfer_running = false;
        for (StateTransferListener listener : this.state_transfer_listeners) {
            try {
                listener.stateTransferCompleted(success);
            }
            catch (Throwable t) {}
        }
    }

    private static class Request
    implements Serializable {
        static final int PUT = 1;
        static final int REMOVE = 2;
        static final int CLEAR = 3;
        static final int PUT_ALL = 4;
        int req_type = 0;
        Object key = null;
        Object val = null;

        Request(int req_type, Object key, Object val) {
            this.req_type = req_type;
            this.key = key;
            this.val = val;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.type2String(this.req_type));
            if (this.key != null) {
                sb.append("\nkey=" + this.key);
            }
            if (this.val != null) {
                sb.append("\nval=" + this.val);
            }
            return sb.toString();
        }

        String type2String(int t) {
            switch (t) {
                case 1: {
                    return "PUT";
                }
                case 2: {
                    return "REMOVE";
                }
                case 3: {
                    return "CLEAR";
                }
                case 4: {
                    return "PUT_ALL";
                }
            }
            return "<unknown>";
        }
    }

    public static interface StateTransferListener {
        public void stateTransferStarted();

        public void stateTransferCompleted(boolean var1);
    }

    public static interface Notification {
        public void entrySet(Object var1, Object var2);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);

        public void contentsSet(Map var1);
    }
}

