/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jgroups.logging.Log;

public class Log4JLogImpl
implements Log {
    private final Logger logger;

    public Log4JLogImpl(String category) {
        this.logger = Logger.getLogger((String)category);
    }

    public Log4JLogImpl(Class category) {
        this.logger = Logger.getLogger((Class)category);
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)Level.FATAL);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void debug(String msg) {
        this.logger.debug((Object)msg);
    }

    public void debug(String msg, Throwable throwable) {
        this.logger.debug((Object)msg, throwable);
    }

    public void error(String msg) {
        this.logger.error((Object)msg);
    }

    public void error(String msg, Throwable throwable) {
        this.logger.error((Object)msg, throwable);
    }

    public void fatal(String msg) {
        this.logger.fatal((Object)msg);
    }

    public void fatal(String msg, Throwable throwable) {
        this.logger.fatal((Object)msg, throwable);
    }

    public void info(String msg) {
        this.logger.info((Object)msg);
    }

    public void info(String msg, Throwable throwable) {
        this.logger.info((Object)msg, throwable);
    }

    public void trace(Object msg) {
        this.logger.trace(msg);
    }

    public void trace(Object msg, Throwable throwable) {
        this.logger.trace(msg, throwable);
    }

    public void trace(String msg) {
        this.logger.trace((Object)msg);
    }

    public void trace(String msg, Throwable throwable) {
        this.logger.trace((Object)msg, throwable);
    }

    public void warn(String msg) {
        this.logger.warn((Object)msg);
    }

    public void warn(String msg, Throwable throwable) {
        this.logger.warn((Object)msg, throwable);
    }

    public String getLevel() {
        Level level = this.logger.getLevel();
        return level != null ? level.toString() : "off";
    }

    public void setLevel(String level) {
        Level new_level = Log4JLogImpl.strToLevel(level);
        if (new_level != null) {
            this.logger.setLevel(new_level);
        }
    }

    private static Level strToLevel(String level) {
        if (level == null) {
            return null;
        }
        if ((level = level.toLowerCase().trim()).equals("fatal")) {
            return Level.FATAL;
        }
        if (level.equals("error")) {
            return Level.ERROR;
        }
        if (level.equals("warn")) {
            return Level.WARN;
        }
        if (level.equals("warning")) {
            return Level.WARN;
        }
        if (level.equals("info")) {
            return Level.INFO;
        }
        if (level.equals("debug")) {
            return Level.DEBUG;
        }
        if (level.equals("trace")) {
            return Level.TRACE;
        }
        return null;
    }
}

