/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;

@Unsupported
public class DUPL
extends Protocol {
    @Property
    @ManagedAttribute(description="Number of copies of each incoming message (0=no copies)", writable=true)
    protected int incoming_copies = 1;
    @Property
    @ManagedAttribute(description="Number of copies of each outgoing message (0=no copies)", writable=true)
    protected int outgoing_copies = 1;
    @Property
    @ManagedAttribute(description="Whether or not to copy unicast messages", writable=true)
    protected boolean copy_unicast_msgs = true;
    @Property
    @ManagedAttribute(description="Whether or not to copy multicast messages", writable=true)
    protected boolean copy_multicast_msgs = true;

    public DUPL() {
    }

    public DUPL(boolean copy_multicast_msgs, boolean copy_unicast_msgs, int incoming_copies, int outgoing_copies) {
        this.copy_multicast_msgs = copy_multicast_msgs;
        this.copy_unicast_msgs = copy_unicast_msgs;
        this.incoming_copies = incoming_copies;
        this.outgoing_copies = outgoing_copies;
    }

    public String getName() {
        return "DUPL";
    }

    public Object down(Event evt) {
        boolean copy;
        boolean bl = copy = (this.copy_multicast_msgs || this.copy_unicast_msgs) && this.outgoing_copies > 0;
        if (!copy) {
            return this.down_prot.down(evt);
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                this.copy(msg, this.outgoing_copies, Direction.DOWN);
            }
        }
        return this.down_prot.down(evt);
    }

    public Object up(Event evt) {
        boolean copy;
        boolean bl = copy = (this.copy_multicast_msgs || this.copy_unicast_msgs) && this.incoming_copies > 0;
        if (!copy) {
            return this.up_prot.up(evt);
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                this.copy(msg, this.incoming_copies, Direction.UP);
            }
        }
        return this.up_prot.up(evt);
    }

    private void copy(Message msg, int num_copies, Direction direction) {
        boolean multicast;
        Address dest = msg.getDest();
        boolean bl = multicast = dest == null || dest.isMulticastAddress();
        if (multicast && this.copy_multicast_msgs || !multicast && this.copy_unicast_msgs) {
            block4: for (int i = 0; i < num_copies; ++i) {
                Message copy = msg.copy(true);
                switch (direction) {
                    case UP: {
                        this.up_prot.up(new Event(1, copy));
                        continue block4;
                    }
                    case DOWN: {
                        this.down_prot.down(new Event(1, copy));
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        UP,
        DOWN;

    }
}

