/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.PING;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayInputStream;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPING
extends PING
implements Runnable {
    private static final boolean can_bind_to_mcast_addr = Util.checkForLinux() || Util.checkForSolaris() || Util.checkForMax() || Util.checkForHp();
    @ManagedAttribute(description="Bind address for multicast socket", writable=true)
    @Property(converter=PropertyConverters.BindAddress.class, description="Bind address for multicast socket")
    InetAddress bind_addr = null;
    @Property(description="Time to live for discovery packets. Default is 8")
    @ManagedAttribute(description="Time to live for discovery packets", writable=true)
    int ip_ttl = 8;
    @ManagedAttribute(description="Multicast address for discovery packets", writable=true)
    InetAddress mcast_addr = null;
    @Property(description="Multicast port for discovery packets. Default is 7555")
    @ManagedAttribute(description="Multicast port for discovery packets", writable=true)
    int mcast_port = 7555;
    @Property(name="bind_to_all_interfaces", deprecatedMessage="bind_to_all_interfaces has been deprecated; use receive_on_all_interfaces instead", description="If true, the transport should use all available interfaces to receive multicast messages. Default is false")
    boolean receive_on_all_interfaces = false;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="List of interfaces to receive multicasts on")
    List<NetworkInterface> receive_interfaces = null;
    @Property(description="Whether send messages are sent on all interfaces. Default is false")
    boolean send_on_all_interfaces = false;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="List of interfaces to send multicasts on")
    List<NetworkInterface> send_interfaces = null;
    private MulticastSocket mcast_sock = null;
    private MulticastSocket[] mcast_send_sockets = null;
    private volatile Thread receiver = null;
    private final ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(128);
    private final byte[] receive_buf = new byte[1024];

    @Override
    public String getName() {
        return "MPING";
    }

    public InetAddress getBindAddr() {
        return this.bind_addr;
    }

    public void setBindAddr(InetAddress bind_addr) {
        this.bind_addr = bind_addr;
    }

    @ManagedAttribute(description="Receive interfaces")
    public List<NetworkInterface> getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    @ManagedAttribute(description="Send interfaces")
    public List<NetworkInterface> getSendInterfaces() {
        return this.send_interfaces;
    }

    @ManagedAttribute
    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    @ManagedAttribute
    public boolean isSendOnAllInterfaces() {
        return this.send_on_all_interfaces;
    }

    public int getTTL() {
        return this.ip_ttl;
    }

    public void setTTL(int ip_ttl) {
        this.ip_ttl = ip_ttl;
    }

    public InetAddress getMcastAddr() {
        return this.mcast_addr;
    }

    public void setMcastAddr(InetAddress mcast_addr) {
        this.mcast_addr = mcast_addr;
    }

    @Property(name="mcast_addr")
    public void setMulticastAddress(String addr) throws UnknownHostException {
        this.mcast_addr = InetAddress.getByName(addr);
    }

    public int getMcastPort() {
        return this.mcast_port;
    }

    public void setMcastPort(int mcast_port) {
        this.mcast_port = mcast_port;
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 56) {
            if (this.bind_addr == null) {
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
            return this.up_prot.up(evt);
        }
        return super.up(evt);
    }

    @Override
    public void init() throws Exception {
        super.init();
        String str = Util.getProperty(new String[]{"jgroups.mping.mcast_addr"}, null, "mcast_addr", false, null);
        if (str != null) {
            this.mcast_addr = InetAddress.getByName(str);
        }
        if ((str = Util.getProperty(new String[]{"jgroups.mping.mcast_port"}, null, "mcast_port", false, null)) != null) {
            this.mcast_port = Integer.parseInt(str);
        }
        if ((str = Util.getProperty(new String[]{"jgroups.mping.ip_ttl"}, null, "ip_ttl", false, null)) != null) {
            this.ip_ttl = Integer.parseInt(str);
        }
        if (this.mcast_addr == null) {
            this.mcast_addr = InetAddress.getByName("230.5.6.7");
        }
    }

    @Override
    public void start() throws Exception {
        List<NetworkInterface> interfaces;
        this.mcast_sock = can_bind_to_mcast_addr ? Util.createMulticastSocket(this.mcast_addr, this.mcast_port, this.log) : new MulticastSocket(this.mcast_port);
        this.mcast_sock.setTimeToLive(this.ip_ttl);
        if (this.receive_on_all_interfaces || this.receive_interfaces != null && !this.receive_interfaces.isEmpty()) {
            interfaces = this.receive_interfaces != null ? this.receive_interfaces : Util.getAllAvailableInterfaces();
            this.bindToInterfaces(interfaces, this.mcast_sock, this.mcast_addr);
        } else {
            if (this.bind_addr != null) {
                this.mcast_sock.setInterface(this.bind_addr);
            }
            this.mcast_sock.joinGroup(this.mcast_addr);
        }
        if (this.send_on_all_interfaces || this.send_interfaces != null && !this.send_interfaces.isEmpty()) {
            interfaces = this.send_interfaces != null ? this.send_interfaces : Util.getAllAvailableInterfaces();
            this.mcast_send_sockets = new MulticastSocket[interfaces.size()];
            int index = 0;
            for (NetworkInterface intf : interfaces) {
                this.mcast_send_sockets[index] = new MulticastSocket();
                this.mcast_send_sockets[index].setNetworkInterface(intf);
                this.mcast_send_sockets[index].setTimeToLive(this.ip_ttl);
                ++index;
            }
        }
        this.startReceiver();
        super.start();
    }

    private void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s, InetAddress mcast_addr) throws IOException {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(mcast_addr, this.mcast_port);
        for (NetworkInterface i : interfaces) {
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            if (!en2.hasMoreElements()) continue;
            InetAddress addr = en2.nextElement();
            s.joinGroup(tmp_mcast_addr, i);
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("joined " + tmp_mcast_addr + " on " + i.getName() + " (" + addr + ")");
        }
    }

    private void startReceiver() {
        if (this.receiver == null || !this.receiver.isAlive()) {
            this.receiver = new Thread(Util.getGlobalThreadGroup(), this, "ReceiverThread");
            this.receiver.setDaemon(true);
            this.receiver.start();
            if (this.log.isTraceEnabled()) {
                this.log.trace("receiver thread started");
            }
        }
    }

    @Override
    public void stop() {
        Util.close(this.mcast_sock);
        this.mcast_sock = null;
        this.receiver = null;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void sendMcastDiscoveryRequest(Message msg) {
        DataOutputStream out = null;
        try {
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            this.out_stream.reset();
            out = new DataOutputStream(this.out_stream);
            msg.writeTo(out);
            out.flush();
            Buffer buf = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
            DatagramPacket packet = new DatagramPacket(buf.getBuf(), buf.getOffset(), buf.getLength(), this.mcast_addr, this.mcast_port);
            this.discovery_reception.reset();
            if (this.mcast_send_sockets != null) {
                for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                    MulticastSocket s = this.mcast_send_sockets[i];
                    try {
                        s.send(packet);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.error("failed sending packet on socket " + s);
                    }
                }
            } else if (this.mcast_sock != null) {
                this.mcast_sock.send(packet);
            }
            this.waitForDiscoveryRequestReception();
            Util.close(out);
        }
        catch (IOException ex) {
            this.log.error("failed sending discovery request", ex);
        }
        finally {
            Util.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        DatagramPacket packet = new DatagramPacket(this.receive_buf, this.receive_buf.length);
        ExposedByteArrayInputStream inp_stream = null;
        DataInputStream inp = null;
        while (this.mcast_sock != null && this.receiver != null && Thread.currentThread().equals(this.receiver)) {
            packet.setData(this.receive_buf, 0, this.receive_buf.length);
            try {
                this.mcast_sock.receive(packet);
                byte[] data = packet.getData();
                inp_stream = new ExposedByteArrayInputStream(data, 0, data.length);
                inp = new DataInputStream(inp_stream);
                Message msg = new Message();
                msg.readFrom(inp);
                this.up(new Event(1, msg));
            }
            catch (SocketException socketEx) {
                Util.close(inp);
                break;
            }
            catch (Throwable ex) {
                this.log.error("failed receiving packet (from " + packet.getSocketAddress() + ")", ex);
                {
                    catch (Throwable throwable) {
                        Util.close(inp);
                        throw throwable;
                    }
                }
                Util.close(inp);
                continue;
            }
            Util.close(inp);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiver thread terminated");
        }
    }
}

