/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;

@Unsupported
public class PERF_TP
extends Protocol {
    private Address local_addr = null;
    static volatile PERF_TP instance = null;
    long stop;
    long start;
    long num_msgs = 0L;
    long expected_msgs = 0L;
    boolean done = false;

    public static PERF_TP getInstance() {
        return instance;
    }

    public PERF_TP() {
        if (instance == null) {
            instance = this;
        }
    }

    public String toString() {
        return "Protocol PERF_TP (local address: " + this.local_addr + ')';
    }

    public boolean done() {
        return this.done;
    }

    public long getNumMessages() {
        return this.num_msgs;
    }

    public void setExpectedMessages(long m) {
        this.expected_msgs = m;
        this.num_msgs = 0L;
        this.done = false;
        this.start = System.currentTimeMillis();
    }

    public void reset() {
        this.start = 0L;
        this.stop = 0L;
        this.expected_msgs = 0L;
        this.num_msgs = 0L;
        this.done = false;
    }

    public long getTotalTime() {
        return this.stop - this.start;
    }

    public String getName() {
        return "PERF_TP";
    }

    public void init() throws Exception {
        this.local_addr = new IpAddress("localhost", 10000);
    }

    public void start() throws Exception {
        this.up_prot.up(new Event(8, this.local_addr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                if (this.done) break;
                Message msg = (Message)evt.getArg();
                Address dest_addr = msg.getDest();
                if (dest_addr == null) {
                    ++this.num_msgs;
                }
                if (this.num_msgs < this.expected_msgs) break;
                this.stop = System.currentTimeMillis();
                PERF_TP pERF_TP = this;
                synchronized (pERF_TP) {
                    this.done = true;
                    this.notifyAll();
                }
                if (!this.log.isInfoEnabled()) break;
                this.log.info("all done (num_msgs=" + this.num_msgs + ", expected_msgs=" + this.expected_msgs);
                break;
            }
            case 2: {
                return null;
            }
        }
        if (this.getDownProtocol() != null) {
            return this.down_prot.down(evt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                if (this.done) {
                    if (!this.log.isWarnEnabled()) break;
                    this.log.warn("all done (discarding msg)");
                    break;
                }
                Message msg = (Message)evt.getArg();
                Address dest_addr = msg.getDest();
                if (dest_addr == null) {
                    ++this.num_msgs;
                }
                if (this.num_msgs >= this.expected_msgs) {
                    this.stop = System.currentTimeMillis();
                    PERF_TP pERF_TP = this;
                    synchronized (pERF_TP) {
                        this.done = true;
                        this.notifyAll();
                    }
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info("all done (num_msgs=" + this.num_msgs + ", expected_msgs=" + this.expected_msgs);
                    break;
                }
                return this.up_prot.up(evt);
            }
        }
        return this.up_prot.up(evt);
    }
}

