/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class TCPGOSSIP
extends Discovery {
    private static final String name = "TCPGOSSIP";
    @Property(description="Rate of continious refresh registering of underlying gossip client with gossip server. Default is 20000 msec")
    long gossip_refresh_rate = 20000L;
    @Property(description="Max time for socket creation. Default is 1000 msec")
    int sock_conn_timeout = 1000;
    @Property(description="Max time in milliseconds to block on a read. 0 blocks forever")
    int sock_read_timeout = 3000;
    List<InetSocketAddress> initial_hosts = null;
    List<RouterStub> stubs = new ArrayList<RouterStub>();

    public String getName() {
        return name;
    }

    public void init() throws Exception {
        super.init();
        if (this.initial_hosts == null || this.initial_hosts.isEmpty()) {
            throw new IllegalArgumentException("initial_hosts must contain the address of at least one GossipRouter");
        }
        if (this.timeout <= (long)this.sock_conn_timeout) {
            throw new IllegalArgumentException("timeout (" + this.timeout + ") must be greater than sock_conn_timeout (" + this.sock_conn_timeout + ")");
        }
    }

    @Property
    public void setInitialHosts(String hosts) throws UnknownHostException {
        this.initial_hosts = Util.parseCommaDelimetedHosts2(hosts, 1);
    }

    public void stop() {
        super.stop();
        for (RouterStub stub : this.stubs) {
            try {
                stub.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public void handleConnect() {
        if (this.group_addr == null || this.local_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("group_addr or local_addr is null, cannot register with GossipRouter(s)");
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace("registering " + this.local_addr + " under " + this.group_addr + " with GossipRouter");
            }
            this.stubs.clear();
            for (InetSocketAddress host : this.initial_hosts) {
                this.stubs.add(new RouterStub(host.getHostName(), host.getPort(), null, this.local_addr));
            }
            for (RouterStub stub : this.stubs) {
                try {
                    stub.connect(this.group_addr);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void handleDisconnect() {
        for (RouterStub stub : this.stubs) {
            try {
                stub.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public void sendGetMembersRequest(String cluster_name, Promise promise) throws Exception {
        ArrayList<Address> tmp_mbrs = new ArrayList<Address>();
        if (this.group_addr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("[FIND_INITIAL_MBRS]: group_addr is null, cannot get mbrship");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("fetching members from GossipRouter(s)");
        }
        for (RouterStub stub : this.stubs) {
            try {
                tmp_mbrs.addAll(stub.getMembers(this.group_addr, this.sock_conn_timeout));
            }
            catch (Exception e) {}
        }
        if (tmp_mbrs.isEmpty()) {
            if (this.log.isErrorEnabled()) {
                this.log.error("[FIND_INITIAL_MBRS]: gossip client found no members");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("consolidated mbrs from GossipRouter(s) are " + tmp_mbrs);
        }
        PingHeader hdr = new PingHeader(1, cluster_name);
        Message msg = new Message(null);
        msg.setFlag((byte)1);
        msg.putHeader(name, hdr);
        for (Address mbr_addr : tmp_mbrs) {
            Message copy = msg.copy();
            copy.setDest(mbr_addr);
            if (this.log.isTraceEnabled()) {
                this.log.trace("[FIND_INITIAL_MBRS] sending PING request to " + copy.getDest());
            }
            this.down_prot.down(new Event(1, copy));
        }
    }
}

