/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.stack.AckReceiverWindow;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="Reliable unicast layer")
@DeprecatedProperty(names={"immediate_ack", "use_gms", "enabled_mbrs_timeout", "eager_lock_release"})
public class UNICAST
extends Protocol
implements AckSenderWindow.RetransmitCommand,
AgeOutCache.Handler<Address> {
    private static final String name = "UNICAST";
    private static final long DEFAULT_FIRST_SEQNO = 1L;
    @Property(description="Whether to loop back messages sent to self. Default is false")
    private boolean loopback = false;
    private long[] timeout = new long[]{400L, 800L, 1600L, 3200L};
    private long num_msgs_sent = 0L;
    private long num_msgs_received = 0L;
    private long num_bytes_sent = 0L;
    private long num_bytes_received = 0L;
    private long num_acks_sent = 0L;
    private long num_acks_received = 0L;
    private long num_xmit_requests_received = 0L;
    private final Vector<Address> members = new Vector(11);
    private final HashMap<Address, Entry> connections = new HashMap(11);
    private Address local_addr = null;
    private TimeScheduler timer = null;
    private boolean started = false;
    private final AtomicInteger undelivered_msgs = new AtomicInteger(0);
    private long last_conn_id = 0L;
    @Property(description="Max number of milliseconds we try to retransmit a message to any given member. After that, the connection is removed. Any new connection to that member will start with seqno #1 again. 0 disables this")
    protected long max_retransmit_time = 60000L;
    private AgeOutCache<Address> cache = null;

    @ManagedAttribute
    public int getUndeliveredMessages() {
        return this.undelivered_msgs.get();
    }

    @Override
    public String getName() {
        return name;
    }

    public long[] getTimeout() {
        return this.timeout;
    }

    @Property(name="timeout", converter=PropertyConverters.LongArray.class)
    public void setTimeout(long[] val) {
        if (val != null) {
            this.timeout = val;
        }
    }

    @ManagedAttribute
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getMembers() {
        return this.members != null ? this.members.toString() : "[]";
    }

    @ManagedOperation
    public String printConnections() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, Entry> entry : this.connections.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @ManagedAttribute
    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    @ManagedAttribute
    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    @ManagedAttribute
    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    @ManagedAttribute
    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    @ManagedAttribute
    public long getNumAcksSent() {
        return this.num_acks_sent;
    }

    @ManagedAttribute
    public long getNumAcksReceived() {
        return this.num_acks_received;
    }

    @ManagedAttribute
    public long getNumberOfRetransmitRequestsReceived() {
        return this.num_xmit_requests_received;
    }

    @ManagedAttribute(writable=true)
    public long getMaxRetransmitTime() {
        return this.max_retransmit_time;
    }

    public void setMaxRetransmitTime(long max_retransmit_time) {
        this.max_retransmit_time = max_retransmit_time;
        if (this.cache != null && max_retransmit_time > 0L) {
            this.cache.setTimeout(max_retransmit_time);
        }
    }

    @ManagedAttribute
    public int getAgeOutCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    @ManagedOperation
    public String printAgeOutCache() {
        return this.cache != null ? this.cache.toString() : "n/a";
    }

    public AgeOutCache getAgeOutCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    public int getNumberOfUnackedMessages() {
        int num = 0;
        HashMap<Address, Entry> hashMap = this.connections;
        synchronized (hashMap) {
            for (Entry entry : this.connections.values()) {
                if (entry.sent_msgs == null) continue;
                num += entry.sent_msgs.size();
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public String printUnackedMessages() {
        StringBuilder sb = new StringBuilder();
        HashMap<Address, Entry> hashMap = this.connections;
        synchronized (hashMap) {
            for (Map.Entry<Address, Entry> entry : this.connections.entrySet()) {
                Address member = entry.getKey();
                Entry e = entry.getValue();
                sb.append(member).append(": ");
                if (e.sent_msgs == null) continue;
                sb.append(e.sent_msgs.toString()).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    public int getNumberOfMessagesInReceiveWindows() {
        int num = 0;
        HashMap<Address, Entry> hashMap = this.connections;
        synchronized (hashMap) {
            for (Entry entry : this.connections.values()) {
                if (entry.received_msgs == null) continue;
                num += entry.received_msgs.size();
            }
        }
        return num;
    }

    @Override
    public void resetStats() {
        this.num_acks_received = 0L;
        this.num_acks_sent = 0L;
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_xmit_requests_received = 0L;
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> m = super.dumpStats();
        m.put("unacked_msgs", this.printUnackedMessages());
        m.put("num_msgs_sent", this.num_msgs_sent);
        m.put("num_msgs_received", this.num_msgs_received);
        m.put("num_bytes_sent", this.num_bytes_sent);
        m.put("num_bytes_received", this.num_bytes_received);
        m.put("num_acks_sent", this.num_acks_sent);
        m.put("num_acks_received", this.num_acks_received);
        m.put("num_xmit_requests_received", this.num_xmit_requests_received);
        m.put("num_unacked_msgs", this.getNumberOfUnackedMessages());
        m.put("num_msgs_in_recv_windows", this.getNumberOfMessagesInReceiveWindows());
        return m;
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.max_retransmit_time > 0L) {
            this.cache = new AgeOutCache(this.timer, this.max_retransmit_time, this);
        }
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
        this.removeAllConnections();
        this.undelivered_msgs.set(0);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                UnicastHeader hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress() || (hdr = (UnicastHeader)msg.getHeader(name)) == null) break;
                Address src = msg.getSrc();
                switch (hdr.type) {
                    case 0: {
                        this.handleDataReceived(src, hdr.seqno, hdr.conn_id, hdr.first, msg);
                        return null;
                    }
                    case 1: {
                        this.handleAckReceived(src, hdr.seqno);
                        break;
                    }
                    case 2: {
                        this.handleResendingOfFirstMessage(src);
                        break;
                    }
                    default: {
                        this.log.error("UnicastHeader type " + hdr.type + " not known !");
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Entry entry;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress()) break;
                if (!this.started) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("discarded message as start() has not yet been called, message: " + msg);
                    }
                    return null;
                }
                if (this.loopback && this.local_addr != null && this.local_addr.equals(dst)) {
                    msg.setSrc(this.local_addr);
                    this.up_prot.up(evt);
                    ++this.num_msgs_sent;
                    this.num_bytes_sent += (long)msg.getLength();
                    return null;
                }
                HashMap<Address, Entry> hashMap = this.connections;
                synchronized (hashMap) {
                    entry = this.connections.get(dst);
                    if (entry == null) {
                        entry = new Entry();
                        this.connections.put(dst, entry);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": created connection to " + dst);
                        }
                        if (this.cache != null && !this.members.contains(dst)) {
                            this.cache.add(dst);
                        }
                    }
                }
                long seqno = -2L;
                Entry entry2 = entry;
                synchronized (entry2) {
                    try {
                        seqno = entry.sent_msgs_seqno;
                        if (seqno == 1L) {
                            entry.send_conn_id = this.getNewConnectionId();
                        }
                        if (entry.sent_msgs == null) {
                            entry.sent_msgs = new AckSenderWindow(this, new StaticInterval(this.timeout), this.timer, this.local_addr);
                        }
                        UnicastHeader hdr = new UnicastHeader(0, seqno, entry.send_conn_id, seqno == 1L);
                        msg.putHeader(name, hdr);
                        if (this.log.isTraceEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(this.local_addr).append(" --> DATA(").append(dst).append(": #").append(seqno).append(", conn_id=").append(entry.send_conn_id);
                            if (hdr.first) {
                                sb.append(", first");
                            }
                            sb.append(')');
                            this.log.trace(sb);
                        }
                        entry.sent_msgs.add(seqno, msg);
                        ++entry.sent_msgs_seqno;
                    }
                    catch (Throwable t) {
                        entry.sent_msgs.ack(seqno);
                        throw new RuntimeException("failure adding msg " + msg + " to the retransmit table", t);
                    }
                }
                try {
                    this.send(msg, evt);
                }
                catch (Throwable t) {
                    this.log.warn("failed sending the message", t);
                }
                return null;
            }
            case 6: {
                View view = (View)evt.getArg();
                Vector<Address> new_members = view.getMembers();
                HashSet<Address> non_members = new HashSet<Address>(this.connections.keySet());
                Vector<Address> vector = this.members;
                synchronized (vector) {
                    this.members.clear();
                    if (new_members != null) {
                        this.members.addAll(new_members);
                    }
                    non_members.removeAll(this.members);
                    if (this.cache != null) {
                        this.cache.removeAll(this.members);
                    }
                }
                if (non_members.isEmpty()) break;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("removing non members " + non_members);
                }
                for (Address non_mbr : non_members) {
                    this.removeConnection(non_mbr);
                }
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    private void send(Message msg, Event evt) {
        this.down_prot.down(evt);
        ++this.num_msgs_sent;
        this.num_bytes_sent += (long)msg.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConnection(Address mbr) {
        Entry entry;
        HashMap<Address, Entry> hashMap = this.connections;
        synchronized (hashMap) {
            entry = this.connections.remove(mbr);
        }
        if (entry != null) {
            entry.reset();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Trashes all connections to other nodes. This is only used for testing")
    public void removeAllConnections() {
        HashMap<Address, Entry> hashMap = this.connections;
        synchronized (hashMap) {
            for (Entry entry : this.connections.values()) {
                entry.reset();
            }
            this.connections.clear();
        }
    }

    @Override
    public void retransmit(long seqno, Message msg) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " --> XMIT(" + msg.getDest() + ": #" + seqno + ')');
        }
        this.down_prot.down(new Event(1, msg));
        ++this.num_xmit_requests_received;
    }

    @Override
    public void expired(Address key) {
        if (key != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("removing connection to " + key + " because it expired");
            }
            this.removeConnection(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDataReceived(Address sender, long seqno, long conn_id, boolean first, Message msg) {
        AckReceiverWindow win;
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(" <-- DATA(").append(sender).append(": #").append(seqno);
            if (conn_id != 0L) {
                sb.append(", conn_id=").append(conn_id);
            }
            if (first) {
                sb.append(", first");
            }
            sb.append(')');
            this.log.trace(sb);
        }
        HashMap<Address, Entry> hashMap = this.connections;
        synchronized (hashMap) {
            Entry entry = this.connections.get(sender);
            AckReceiverWindow ackReceiverWindow = win = entry != null ? entry.received_msgs : null;
            if (first) {
                if (entry == null || win == null) {
                    win = this.createReceiverWindow(sender, entry, seqno, conn_id);
                } else if (conn_id != entry.recv_conn_id) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.local_addr + ": conn_id=" + conn_id + " != " + entry.recv_conn_id + "; resetting receiver window");
                    }
                    win = this.createReceiverWindow(sender, entry, seqno, conn_id);
                }
            } else if (win == null || entry.recv_conn_id != conn_id) {
                this.sendRequestForFirstSeqno(sender);
                return;
            }
        }
        boolean added = win.add(seqno, msg);
        ++this.num_msgs_received;
        this.num_bytes_received += (long)msg.getLength();
        if (added && !msg.isFlagSet((byte)1)) {
            this.undelivered_msgs.incrementAndGet();
        }
        if (win.smallerThanNextToRemove(seqno)) {
            this.sendAck(msg.getSrc(), seqno);
        }
        if (msg.isFlagSet((byte)1)) {
            Message oob_msg;
            if (added) {
                this.up_prot.up(new Event(1, msg));
            }
            if ((oob_msg = win.removeOOBMessage()) != null) {
                this.sendAckForMessage(oob_msg);
            }
            if (!win.hasMessagesToRemove() || this.undelivered_msgs.get() <= 0) {
                return;
            }
        }
        if (!added && !win.hasMessagesToRemove()) {
            return;
        }
        AtomicBoolean processing = win.getProcessing();
        if (!processing.compareAndSet(false, true)) {
            return;
        }
        boolean released_processing = false;
        int num_regular_msgs_removed = 0;
        try {
            while (true) {
                Message m;
                if ((m = win.remove(processing)) == null) {
                    released_processing = true;
                    return;
                }
                if (m.isFlagSet((byte)1)) continue;
                ++num_regular_msgs_removed;
                this.sendAckForMessage(m);
                this.up_prot.up(new Event(1, m));
            }
        }
        finally {
            this.undelivered_msgs.addAndGet(-num_regular_msgs_removed);
            if (!released_processing) {
                processing.set(false);
            }
        }
    }

    private AckReceiverWindow createReceiverWindow(Address sender, Entry entry, long seqno, long conn_id) {
        if (entry == null) {
            entry = new Entry();
            this.connections.put(sender, entry);
        }
        if (entry.received_msgs != null) {
            entry.received_msgs.reset();
        }
        entry.received_msgs = new AckReceiverWindow(seqno);
        entry.recv_conn_id = conn_id;
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": created receiver window for " + sender + " at seqno=#" + seqno + " for conn-id=" + conn_id);
        }
        return entry.received_msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAckReceived(Address sender, long seqno) {
        Entry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(" <-- ACK(").append(sender).append(": #").append(seqno).append(')'));
        }
        HashMap<Address, Entry> hashMap = this.connections;
        synchronized (hashMap) {
            entry = this.connections.get(sender);
        }
        if (entry == null || entry.sent_msgs == null) {
            return;
        }
        AckSenderWindow win = entry.sent_msgs;
        win.ack(seqno);
        ++this.num_acks_received;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResendingOfFirstMessage(Address sender) {
        Message rsp;
        Entry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " <-- SEND_FIRST_SEQNO(" + sender + ")");
        }
        HashMap<Address, Entry> hashMap = this.connections;
        synchronized (hashMap) {
            AckSenderWindow sender_win;
            entry = this.connections.get(sender);
            AckSenderWindow ackSenderWindow = sender_win = entry != null ? entry.sent_msgs : null;
            if (sender_win == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(this.local_addr + ": sender window for " + sender + " not found");
                }
                return;
            }
            rsp = sender_win.getLowestMessage();
        }
        if (rsp == null) {
            return;
        }
        Message copy = rsp.copy();
        UnicastHeader hdr = (UnicastHeader)copy.getHeader(name);
        UnicastHeader newhdr = new UnicastHeader(hdr.type, hdr.seqno, entry.send_conn_id, true);
        copy.putHeader(name, newhdr);
        this.down_prot.down(new Event(1, copy));
    }

    private void sendAck(Address dst, long seqno) {
        Message ack = new Message(dst);
        ack.setFlag((byte)1);
        ack.putHeader(name, new UnicastHeader(1, seqno));
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(" --> ACK(").append(dst).append(": #").append(seqno).append(')'));
        }
        this.down_prot.down(new Event(1, ack));
        ++this.num_acks_sent;
    }

    private void sendAckForMessage(Message msg) {
        Address sender;
        UnicastHeader hdr = msg != null ? (UnicastHeader)msg.getHeader(name) : null;
        Address address = sender = msg != null ? msg.getSrc() : null;
        if (hdr != null && sender != null) {
            this.sendAck(sender, hdr.seqno);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNewConnectionId() {
        long retval = System.currentTimeMillis();
        UNICAST uNICAST = this;
        synchronized (uNICAST) {
            if (this.last_conn_id == retval) {
                ++retval;
            }
            this.last_conn_id = retval;
            return retval;
        }
    }

    private void sendRequestForFirstSeqno(Address dest) {
        Message msg = new Message(dest);
        msg.setFlag((byte)1);
        UnicastHeader hdr = new UnicastHeader(2, 0L);
        msg.putHeader(name, hdr);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " --> SEND_FIRST_SEQNO(" + dest + ")");
        }
        this.down_prot.down(new Event(1, msg));
    }

    private static final class Entry {
        AckReceiverWindow received_msgs = null;
        long recv_conn_id = 0L;
        AckSenderWindow sent_msgs = null;
        long sent_msgs_seqno = 1L;
        long send_conn_id = 0L;

        private Entry() {
        }

        void reset() {
            if (this.sent_msgs != null) {
                this.sent_msgs.reset();
            }
            if (this.received_msgs != null) {
                this.received_msgs.reset();
            }
            this.sent_msgs_seqno = 1L;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.sent_msgs != null) {
                sb.append("sent_msgs=").append(this.sent_msgs).append('\n');
            }
            if (this.received_msgs != null) {
                sb.append("received_msgs=").append(this.received_msgs).append('\n');
            }
            sb.append("send_conn_id=" + this.send_conn_id + ", recv_conn_id=" + this.recv_conn_id + "\n");
            return sb.toString();
        }
    }

    public static class UnicastHeader
    extends Header
    implements Streamable {
        public static final byte DATA = 0;
        public static final byte ACK = 1;
        public static final byte SEND_FIRST_SEQNO = 2;
        byte type = 0;
        long seqno = 0L;
        long conn_id = 0L;
        boolean first = false;
        static final int serialized_size = 18;
        private static final long serialVersionUID = -8983745221189309298L;

        public UnicastHeader() {
        }

        public UnicastHeader(byte type, long seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        public UnicastHeader(byte type, long seqno, long conn_id) {
            this(type, seqno);
            this.conn_id = conn_id;
        }

        public UnicastHeader(byte type, long seqno, long conn_id, boolean first) {
            this(type, seqno, conn_id);
            this.first = first;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[UNICAST: ").append(UnicastHeader.type2Str(this.type)).append(", seqno=").append(this.seqno);
            if (this.conn_id != 0L) {
                sb.append(", conn_id=").append(this.conn_id);
            }
            if (this.first) {
                sb.append(", first");
            }
            sb.append(']');
            return sb.toString();
        }

        public static String type2Str(byte t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "ACK";
                }
                case 2: {
                    return "SEND_FIRST_SEQNO";
                }
            }
            return "<unknown>";
        }

        public final int size() {
            return 18;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
            out.writeLong(this.conn_id);
            out.writeBoolean(this.first);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.seqno = in.readLong();
            this.conn_id = in.readLong();
            this.first = in.readBoolean();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.seqno);
            out.writeLong(this.conn_id);
            out.writeBoolean(this.first);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.seqno = in.readLong();
            this.conn_id = in.readLong();
            this.first = in.readBoolean();
        }
    }
}

