/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jgroups.Event;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverter;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurator
implements ProtocolStack.ProtocolStackFactory {
    protected static final Log log = LogFactory.getLog(Configurator.class);
    private final ProtocolStack stack;

    public Configurator() {
        this.stack = null;
    }

    public Configurator(ProtocolStack protocolStack) {
        this.stack = protocolStack;
    }

    @Override
    public Protocol setupProtocolStack() throws Exception {
        return this.setupProtocolStack(this.stack.getSetupString(), this.stack);
    }

    @Override
    public Protocol setupProtocolStack(ProtocolStack copySource) throws Exception {
        Vector<Protocol> protocols = copySource.copyProtocols(this.stack);
        Collections.reverse(protocols);
        return this.connectProtocols(protocols);
    }

    private Protocol setupProtocolStack(String configuration, ProtocolStack st) throws Exception {
        Vector<ProtocolConfiguration> protocol_configs = this.parseConfigurations(configuration);
        Vector<Protocol> protocols = this.createProtocols(protocol_configs, st);
        if (protocols == null) {
            return null;
        }
        return this.connectProtocols(protocols);
    }

    public static Protocol createProtocol(String prot_spec, ProtocolStack stack) throws Exception {
        if (prot_spec == null) {
            throw new Exception("Configurator.createProtocol(): prot_spec is null");
        }
        ProtocolConfiguration config = new ProtocolConfiguration(prot_spec);
        Protocol prot = config.createLayer(stack);
        prot.init();
        return prot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Protocol connectProtocols(Vector<Protocol> protocol_list) {
        Protocol current_layer = null;
        Protocol next_layer = null;
        for (int i = 0; i < protocol_list.size(); ++i) {
            ConcurrentMap<String, Protocol> up_prots;
            TP transport;
            current_layer = protocol_list.elementAt(i);
            if (i + 1 >= protocol_list.size()) break;
            next_layer = protocol_list.elementAt(i + 1);
            next_layer.setDownProtocol(current_layer);
            current_layer.setUpProtocol(next_layer);
            if (!(current_layer instanceof TP) || !(transport = (TP)current_layer).isSingleton()) continue;
            ConcurrentMap<String, Protocol> concurrentMap = up_prots = transport.getUpProtocols();
            synchronized (concurrentMap) {
                String key;
                while (up_prots.containsKey(key = "dummy-" + System.currentTimeMillis())) {
                }
                up_prots.put(key, next_layer);
            }
            current_layer.setUpProtocol(null);
        }
        return current_layer;
    }

    private Vector<String> parseProtocols(String config_str) throws IOException {
        Vector<String> retval = new Vector<String>();
        PushbackReader reader = new PushbackReader(new StringReader(config_str));
        boolean running = true;
        block0: while (running) {
            String protocol_name = Configurator.readWord(reader);
            StringBuilder sb = new StringBuilder();
            sb.append(protocol_name);
            int ch = Configurator.read(reader);
            if (ch == -1) {
                retval.add(sb.toString());
                break;
            }
            if (ch == 58) {
                retval.add(sb.toString());
                continue;
            }
            if (ch == 40) {
                reader.unread(ch);
                String attrs = Configurator.readUntil(reader, ')');
                sb.append(attrs);
                retval.add(sb.toString());
            } else {
                retval.add(sb.toString());
            }
            while ((ch = Configurator.read(reader)) != 58) {
                if (ch != -1) continue;
                running = false;
                continue block0;
            }
        }
        reader.close();
        return retval;
    }

    private static int read(Reader reader) throws IOException {
        int ch = -1;
        while ((ch = reader.read()) != -1) {
            if (Character.isWhitespace(ch)) continue;
            return ch;
        }
        return ch;
    }

    public Vector<ProtocolConfiguration> parseConfigurations(String configuration) throws Exception {
        Vector<ProtocolConfiguration> retval = new Vector<ProtocolConfiguration>();
        Vector<String> protocol_string = this.parseProtocols(configuration);
        if (protocol_string == null) {
            return null;
        }
        for (String component_string : protocol_string) {
            retval.addElement(new ProtocolConfiguration(component_string));
        }
        return retval;
    }

    private static String readUntil(Reader reader, char c) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = Configurator.read(reader)) != -1) {
            sb.append((char)ch);
            if (ch != c) continue;
            break;
        }
        return sb.toString();
    }

    private static String readWord(PushbackReader reader) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = Configurator.read(reader)) != -1) {
            if (Character.isLetterOrDigit(ch) || ch == 95 || ch == 46 || ch == 36) {
                sb.append((char)ch);
                continue;
            }
            reader.unread(ch);
            break;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<Protocol> createProtocols(Vector<ProtocolConfiguration> protocol_configs, ProtocolStack stack) throws Exception {
        Vector<Protocol> retval = new Vector<Protocol>();
        for (int i = 0; i < protocol_configs.size(); ++i) {
            Protocol layer;
            ProtocolConfiguration protocol_config = protocol_configs.elementAt(i);
            String singleton_name = protocol_config.getProperties().getProperty("singleton_name");
            if (singleton_name != null && singleton_name.trim().length() > 0) {
                ProtocolStack protocolStack = stack;
                synchronized (protocolStack) {
                    if (i > 0) {
                        throw new IllegalArgumentException("Property 'singleton_name' can only be used in a transport protocol (was used in " + protocol_config.getProtocolName() + ")");
                    }
                    ConcurrentMap<String, Tuple<TP, ProtocolStack.RefCounter>> singleton_transports = ProtocolStack.getSingletonTransports();
                    Tuple val = (Tuple)singleton_transports.get(singleton_name);
                    Protocol protocol = layer = val != null ? (TP)val.getVal1() : null;
                    if (layer != null) {
                        retval.add(layer);
                    } else {
                        layer = protocol_config.createLayer(stack);
                        if (layer == null) {
                            return null;
                        }
                        singleton_transports.put(singleton_name, new Tuple<TP, ProtocolStack.RefCounter>((TP)layer, new ProtocolStack.RefCounter(0, 0)));
                        retval.addElement(layer);
                    }
                    continue;
                }
            }
            layer = protocol_config.createLayer(stack);
            if (layer == null) {
                return null;
            }
            retval.addElement(layer);
        }
        Configurator.sanityCheck(retval);
        return retval;
    }

    public static void sanityCheck(Vector<Protocol> protocols) throws Exception {
        Vector<String> names = new Vector<String>();
        Vector<ProtocolReq> req_list = new Vector<ProtocolReq>();
        for (int i = 0; i < protocols.size(); ++i) {
            Protocol prot = protocols.elementAt(i);
            String name = prot.getName();
            for (int j = 0; j < names.size(); ++j) {
                if (!name.equals(names.elementAt(j))) continue;
                throw new Exception("Configurator.sanityCheck(): protocol name " + name + " has been used more than once; protocol names have to be unique !");
            }
            names.addElement(name);
        }
        for (Protocol p : protocols) {
            req_list.add(new ProtocolReq(p));
        }
        for (ProtocolReq pr : req_list) {
            for (Integer evt_type : pr.up_reqs) {
                if (Configurator.providesDownServices(req_list, evt_type)) continue;
                throw new Exception("Configurator.sanityCheck(): event " + Event.type2String(evt_type) + " is required by " + pr.name + ", but not provided by any of the layers above");
            }
            for (Integer evt_type : pr.down_reqs) {
                if (Configurator.providesUpServices(req_list, evt_type)) continue;
                throw new Exception("Configurator.sanityCheck(): event " + Event.type2String(evt_type) + " is required by " + pr.name + ", but not provided by any of the layers above");
            }
        }
    }

    static boolean providesUpServices(Vector<ProtocolReq> req_list, int evt_type) {
        for (ProtocolReq pr : req_list) {
            if (!pr.providesUpService(evt_type)) continue;
            return true;
        }
        return false;
    }

    static boolean providesDownServices(Vector<ProtocolReq> req_list, int evt_type) {
        for (ProtocolReq pr : req_list) {
            if (!pr.providesDownService(evt_type)) continue;
            return true;
        }
        return false;
    }

    public static void resolveAndInvokePropertyMethods(Object obj, Properties props) throws Exception {
        Method[] methods;
        for (Method method : methods = obj.getClass().getMethods()) {
            String methodName = method.getName();
            if (!method.isAnnotationPresent(Property.class) || !Configurator.isSetPropertyMethod(method)) continue;
            Property annotation = method.getAnnotation(Property.class);
            String propertyName = annotation.name().length() > 0 ? annotation.name() : methodName.substring(3);
            String prop = props.getProperty(propertyName = Configurator.renameFromJavaCodingConvention(propertyName));
            if (prop == null) continue;
            PropertyConverter propertyConverter = (PropertyConverter)annotation.converter().newInstance();
            if (propertyConverter == null) {
                String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
                throw new Exception("Could not find property converter for field " + propertyName + " in " + name);
            }
            Object converted = null;
            try {
                converted = propertyConverter.convert(method.getParameterTypes()[0], props, prop);
                method.invoke(obj, converted);
            }
            catch (Exception e) {
                String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
                throw new Exception("Could not assign property " + propertyName + " in " + name + ", method is " + methodName + ", converted value is " + converted, e);
            }
            finally {
                props.remove(propertyName);
            }
        }
    }

    public static boolean isSetPropertyMethod(Method method) {
        return method.getName().startsWith("set") && method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1;
    }

    public static void resolveAndAssignFields(Object obj, Properties props) throws Exception {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                String propertyValue;
                if (!field.isAnnotationPresent(Property.class)) continue;
                Property annotation = field.getAnnotation(Property.class);
                String propertyName = field.getName();
                if (props.containsKey(annotation.name())) {
                    boolean isDeprecated;
                    propertyName = annotation.name();
                    boolean bl = isDeprecated = annotation.deprecatedMessage().length() > 0;
                    if (isDeprecated && log.isWarnEnabled()) {
                        log.warn(annotation.deprecatedMessage());
                    }
                }
                if ((propertyValue = props.getProperty(propertyName)) == null && annotation.converter().equals(PropertyConverters.Default.class)) continue;
                PropertyConverter propertyConverter = (PropertyConverter)annotation.converter().newInstance();
                if (propertyConverter == null) {
                    String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
                    throw new Exception("Could not find property converter for field " + propertyName + " in " + name);
                }
                Object converted = null;
                try {
                    converted = propertyConverter.convert(field.getType(), props, propertyValue);
                    if (converted == null) continue;
                    Configurator.setField(field, obj, converted);
                }
                catch (Exception e) {
                    String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
                    throw new Exception("Property assignment of " + propertyName + " in " + name + " with original property value " + propertyValue + " and converted to " + converted + " could not be assigned. Exception is " + e, e);
                }
                finally {
                    props.remove(propertyName);
                }
            }
        }
    }

    public static void removeDeprecatedProperties(Object obj, Properties props) throws Exception {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            String[] deprecatedProperties;
            if (!clazz.isAnnotationPresent(DeprecatedProperty.class)) continue;
            DeprecatedProperty declaredAnnotation = clazz.getAnnotation(DeprecatedProperty.class);
            for (String propertyName : deprecatedProperties = declaredAnnotation.names()) {
                String propertyValue = props.getProperty(propertyName);
                if (propertyValue == null) continue;
                if (log.isWarnEnabled()) {
                    String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
                    log.warn(name + " property " + propertyName + " was deprecated and is ignored");
                }
                props.remove(propertyName);
            }
        }
    }

    public static void setField(Field field, Object target, Object value) {
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
    }

    public static Object getField(Field field, Object target) {
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
        try {
            return field.get(target);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not get field " + field, iae);
        }
    }

    public static String renameFromJavaCodingConvention(String fieldName) {
        Pattern p = Pattern.compile("[A-Z]");
        Matcher m = p.matcher(fieldName.substring(1));
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "_" + fieldName.substring(m.end(), m.end() + 1).toLowerCase());
        }
        m.appendTail(sb);
        sb.insert(0, fieldName.substring(0, 1).toLowerCase());
        return sb.toString();
    }

    public static class ProtocolConfiguration {
        private final String protocol_name;
        private final String properties_str;
        private final Properties properties = new Properties();
        private static final String protocol_prefix = "org.jgroups.protocols";

        public ProtocolConfiguration(String config_str) throws Exception {
            int index = config_str.indexOf(40);
            int end_index = config_str.lastIndexOf(41);
            if (index == -1) {
                this.protocol_name = config_str;
                this.properties_str = "";
            } else {
                if (end_index == -1) {
                    throw new Exception("Configurator.ProtocolConfiguration(): closing ')' not found in " + config_str + ": properties cannot be set !");
                }
                this.properties_str = config_str.substring(index + 1, end_index);
                this.protocol_name = config_str.substring(0, index);
            }
            if (this.properties_str.length() > 0) {
                String[] components;
                for (String property : components = this.properties_str.split(";")) {
                    index = property.indexOf(61);
                    if (index == -1) {
                        throw new Exception("Configurator.ProtocolConfiguration(): '=' not found in " + property + " of " + this.protocol_name);
                    }
                    String name = property.substring(0, index);
                    String value = property.substring(index + 1, property.length());
                    this.properties.put(name, value);
                }
            }
        }

        public String getProtocolName() {
            return this.protocol_name;
        }

        public Properties getProperties() {
            return this.properties;
        }

        private Protocol createLayer(ProtocolStack prot_stack) throws Exception {
            Protocol retval = null;
            if (this.protocol_name == null) {
                return null;
            }
            String defaultProtocolName = "org.jgroups.protocols." + this.protocol_name;
            Class clazz = null;
            try {
                clazz = Util.loadClass(defaultProtocolName, this.getClass());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (clazz == null) {
                try {
                    clazz = Util.loadClass(this.protocol_name, this.getClass());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (clazz == null) {
                    throw new Exception("unable to load class for protocol " + this.protocol_name + " (either as an absolute - " + this.protocol_name + " - or relative - " + defaultProtocolName + " - package name)!");
                }
            }
            try {
                retval = (Protocol)clazz.newInstance();
                if (retval == null) {
                    throw new Exception("creation of instance for protocol " + this.protocol_name + "failed !");
                }
                retval.setProtocolStack(prot_stack);
                Configurator.removeDeprecatedProperties(retval, this.properties);
                Configurator.resolveAndAssignFields(retval, this.properties);
                Configurator.resolveAndInvokePropertyMethods(retval, this.properties);
                List<Object> additional_objects = retval.getConfigurableObjects();
                if (additional_objects != null && !additional_objects.isEmpty()) {
                    for (Object obj : additional_objects) {
                        Configurator.resolveAndAssignFields(obj, this.properties);
                        Configurator.resolveAndInvokePropertyMethods(obj, this.properties);
                    }
                }
                if (!this.properties.isEmpty()) {
                    throw new IllegalArgumentException("the following properties in " + this.protocol_name + " are not recognized: " + this.properties);
                }
            }
            catch (InstantiationException inst_ex) {
                log.error("an instance of " + this.protocol_name + " could not be created. Please check that it implements" + " interface Protocol and that is has a public empty constructor !");
                throw inst_ex;
            }
            return retval;
        }

        public String toString() {
            StringBuilder retval = new StringBuilder();
            retval.append("Protocol: ");
            if (this.protocol_name == null) {
                retval.append("<unknown>");
            } else {
                retval.append(this.protocol_name);
            }
            if (this.properties != null) {
                retval.append("(" + this.properties + ')');
            }
            return retval.toString();
        }
    }

    private static class ProtocolReq {
        final Vector<Integer> up_reqs = new Vector();
        final Vector<Integer> down_reqs = new Vector();
        final Vector<Integer> up_provides = new Vector();
        final Vector<Integer> down_provides = new Vector();
        final String name;

        ProtocolReq(Protocol p) {
            this.name = p.getName();
            if (p.requiredUpServices() != null) {
                this.up_reqs.addAll(p.requiredUpServices());
            }
            if (p.requiredDownServices() != null) {
                this.down_reqs.addAll(p.requiredDownServices());
            }
            if (p.providedUpServices() != null) {
                this.up_provides.addAll(p.providedUpServices());
            }
            if (p.providedDownServices() != null) {
                this.down_provides.addAll(p.providedDownServices());
            }
        }

        boolean providesUpService(int evt_type) {
            for (Integer type : this.up_provides) {
                if (type != evt_type) continue;
                return true;
            }
            return false;
        }

        boolean providesDownService(int evt_type) {
            for (Integer type : this.down_provides) {
                if (type != evt_type) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append('\n' + this.name + ':');
            if (!this.up_reqs.isEmpty()) {
                ret.append("\nRequires from above: " + this.printUpReqs());
            }
            if (!this.down_reqs.isEmpty()) {
                ret.append("\nRequires from below: " + this.printDownReqs());
            }
            if (!this.up_provides.isEmpty()) {
                ret.append("\nProvides to above: " + this.printUpProvides());
            }
            if (!this.down_provides.isEmpty()) {
                ret.append("\nProvides to below: ").append(this.printDownProvides());
            }
            return ret.toString();
        }

        String printUpReqs() {
            StringBuilder ret = new StringBuilder("[");
            for (Integer type : this.up_reqs) {
                ret.append(Event.type2String(type) + ' ');
            }
            return ret.toString() + ']';
        }

        String printDownReqs() {
            StringBuilder ret = new StringBuilder("[");
            for (Integer type : this.down_reqs) {
                ret.append(Event.type2String(type) + ' ');
            }
            return ret.toString() + ']';
        }

        String printUpProvides() {
            StringBuilder ret = new StringBuilder("[");
            for (Integer type : this.up_provides) {
                ret.append(Event.type2String(type) + ' ');
            }
            return ret.toString() + ']';
        }

        String printDownProvides() {
            StringBuilder ret = new StringBuilder("[");
            for (Integer type : this.down_provides) {
                ret.append(Event.type2String(type) + ' ');
            }
            return ret.toString() + ']';
        }
    }
}

