/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.error;

import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.springframework.extensions.surf.util.I18NUtil;

public class AlfrescoRuntimeExceptionTest
extends TestCase {
    private static final String BASE_RESOURCE_NAME = "org.alfresco.i18n.testMessages";
    private static final String PARAM_VALUE = "television";
    private static final String MSG_PARAMS = "msg_params";
    private static final String MSG_ERROR = "msg_error";
    private static final String VALUE_ERROR = "This is an error message. \n  This is on a new line.";
    private static final String VALUE_FR_ERROR = "C'est un message d'erreur. \n  C'est sur une nouvelle ligne.";
    private static final String VALUE_PARAMS = "What no television?";
    private static final String VALUE_FR_PARAMS = "Que non television?";
    private static final String NON_I18NED_MSG = "This is a non i18ned error message.";

    protected void setUp() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        I18NUtil.setLocale((Locale)Locale.getDefault());
    }

    public void testI18NBehaviour() {
        String baseResourceAsProperty = BASE_RESOURCE_NAME.replace('.', '/') + ".properties";
        URL baseResourceURL = AlfrescoRuntimeExceptionTest.class.getClassLoader().getResource(baseResourceAsProperty);
        AlfrescoRuntimeExceptionTest.assertNotNull((Object)baseResourceURL);
        baseResourceAsProperty = BASE_RESOURCE_NAME.replace('.', '/') + "_fr_FR" + ".properties";
        baseResourceURL = AlfrescoRuntimeExceptionTest.class.getClassLoader().getResource(baseResourceAsProperty);
        AlfrescoRuntimeExceptionTest.assertNotNull((Object)baseResourceURL);
        ResourceBundle properties = ResourceBundle.getBundle(BASE_RESOURCE_NAME);
        AlfrescoRuntimeExceptionTest.assertNotNull((Object)properties);
        properties = ResourceBundle.getBundle(BASE_RESOURCE_NAME, new Locale("fr", "FR"));
        AlfrescoRuntimeExceptionTest.assertNotNull((Object)properties);
        I18NUtil.registerResourceBundle((String)BASE_RESOURCE_NAME);
        AlfrescoRuntimeException exception1 = new AlfrescoRuntimeException(MSG_PARAMS, new Object[]{PARAM_VALUE});
        AlfrescoRuntimeExceptionTest.assertTrue((boolean)exception1.getMessage().contains(VALUE_PARAMS));
        AlfrescoRuntimeException exception3 = new AlfrescoRuntimeException(MSG_ERROR);
        AlfrescoRuntimeExceptionTest.assertTrue((boolean)exception3.getMessage().contains(VALUE_ERROR));
        I18NUtil.setLocale((Locale)new Locale("fr", "FR"));
        AlfrescoRuntimeException exception2 = new AlfrescoRuntimeException(MSG_PARAMS, new Object[]{PARAM_VALUE});
        AlfrescoRuntimeExceptionTest.assertTrue((boolean)exception2.getMessage().contains(VALUE_FR_PARAMS));
        AlfrescoRuntimeException exception4 = new AlfrescoRuntimeException(MSG_ERROR);
        AlfrescoRuntimeExceptionTest.assertTrue((boolean)exception4.getMessage().contains(VALUE_FR_ERROR));
        AlfrescoRuntimeException exception5 = new AlfrescoRuntimeException(NON_I18NED_MSG);
        AlfrescoRuntimeExceptionTest.assertTrue((boolean)exception5.getMessage().contains(NON_I18NED_MSG));
    }

    public void testMakeRuntimeException() {
        Exception e = new RuntimeException("sfsfs");
        RuntimeException ee = AlfrescoRuntimeException.makeRuntimeException(e, "Test", new Object[0]);
        AlfrescoRuntimeExceptionTest.assertTrue((String)"Exception should not have been changed", (ee == e ? 1 : 0) != 0);
        e = new Exception();
        ee = AlfrescoRuntimeException.makeRuntimeException(e, "Test", new Object[0]);
        AlfrescoRuntimeExceptionTest.assertTrue((String)"Expected an AlfrescoRuntimeException instance", (boolean)(ee instanceof AlfrescoRuntimeException));
    }
}

