/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class HierarchicalSqlMapClientFactoryBeanTest
extends TestCase {
    private static final String QUERY_OBJECT = Object.class.getName();
    private static final String QUERY_ABSTRACTCOLLECTION = AbstractCollection.class.getName();
    private static final String QUERY_ABSTRACTLIST = AbstractList.class.getName();
    private static final String QUERY_TREESET = TreeSet.class.getName();
    private static Log logger = LogFactory.getLog(HierarchicalSqlMapClientFactoryBeanTest.class);
    private ClassPathXmlApplicationContext ctx;
    private TestDAO testDao;

    public void setUp() throws Exception {
        this.testDao = new TestDAO();
        this.testDao.setId(5L);
        this.testDao.setPropOne("prop-one");
        this.testDao.setPropTwo("prop-two");
    }

    public void tearDown() throws Exception {
        try {
            if (this.ctx != null) {
                this.ctx.close();
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to neatly close application context", e);
        }
    }

    private SqlMapClient getSqlMapClient(Class dialectClass) throws Exception {
        System.setProperty("hierarchy-test.dialect", dialectClass.getName());
        if (this.ctx != null) {
            try {
                this.ctx.close();
                this.ctx = null;
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to neatly close application context", e);
            }
        }
        this.ctx = new ClassPathXmlApplicationContext("ibatis/hierarchy-test/hierarchy-test-context.xml");
        return (SqlMapClient)this.ctx.getBean("sqlMapClient");
    }

    public void testContextStartup() throws Exception {
        this.getSqlMapClient(TreeSet.class);
        this.getSqlMapClient(HashSet.class);
        this.getSqlMapClient(ArrayList.class);
        this.getSqlMapClient(AbstractCollection.class);
        try {
            this.getSqlMapClient(Collection.class);
            HierarchicalSqlMapClientFactoryBeanTest.fail((String)"Failed to detect incompatible class hierarchy");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testHierarchyTreeSet() throws Exception {
        ExtendedSqlMapClient sqlMapClient = (ExtendedSqlMapClient)this.getSqlMapClient(TreeSet.class);
        MappedStatement stmt = sqlMapClient.getMappedStatement(QUERY_TREESET);
        HierarchicalSqlMapClientFactoryBeanTest.assertNotNull((String)("Query missing for " + QUERY_TREESET + " using " + TreeSet.class), (Object)stmt);
        try {
            sqlMapClient.getMappedStatement(QUERY_ABSTRACTCOLLECTION);
            HierarchicalSqlMapClientFactoryBeanTest.fail((String)("Query not missing for " + QUERY_ABSTRACTCOLLECTION + " using " + TreeSet.class));
        }
        catch (SqlMapException sqlMapException) {
            // empty catch block
        }
    }

    public void testHierarchyHashSet() throws Exception {
        ExtendedSqlMapClient sqlMapClient = (ExtendedSqlMapClient)this.getSqlMapClient(HashSet.class);
        MappedStatement stmt = sqlMapClient.getMappedStatement(QUERY_ABSTRACTCOLLECTION);
        HierarchicalSqlMapClientFactoryBeanTest.assertNotNull((String)("Query missing for " + QUERY_ABSTRACTCOLLECTION + " using " + HashSet.class), (Object)stmt);
        try {
            sqlMapClient.getMappedStatement(QUERY_OBJECT);
            HierarchicalSqlMapClientFactoryBeanTest.fail((String)("Query not missing for " + QUERY_OBJECT + " using " + HashSet.class));
        }
        catch (SqlMapException sqlMapException) {
            // empty catch block
        }
    }

    public void testHierarchyArrayList() throws Exception {
        ExtendedSqlMapClient sqlMapClient = (ExtendedSqlMapClient)this.getSqlMapClient(ArrayList.class);
        MappedStatement stmt = sqlMapClient.getMappedStatement(QUERY_ABSTRACTLIST);
        HierarchicalSqlMapClientFactoryBeanTest.assertNotNull((String)("Query missing for " + QUERY_ABSTRACTLIST + " using " + ArrayList.class), (Object)stmt);
        try {
            sqlMapClient.getMappedStatement(QUERY_ABSTRACTCOLLECTION);
            HierarchicalSqlMapClientFactoryBeanTest.fail((String)("Query not missing for " + QUERY_ABSTRACTCOLLECTION + " using " + ArrayList.class));
        }
        catch (SqlMapException sqlMapException) {
            // empty catch block
        }
    }

    public void testHierarchyAbstractCollection() throws Exception {
        ExtendedSqlMapClient sqlMapClient = (ExtendedSqlMapClient)this.getSqlMapClient(AbstractCollection.class);
        MappedStatement stmt = sqlMapClient.getMappedStatement(QUERY_ABSTRACTCOLLECTION);
        HierarchicalSqlMapClientFactoryBeanTest.assertNotNull((String)("Query missing for " + QUERY_ABSTRACTCOLLECTION + " using " + AbstractCollection.class), (Object)stmt);
        try {
            sqlMapClient.getMappedStatement(QUERY_OBJECT);
            HierarchicalSqlMapClientFactoryBeanTest.fail((String)("Query not missing for " + QUERY_OBJECT + " using " + AbstractCollection.class));
        }
        catch (SqlMapException sqlMapException) {
            // empty catch block
        }
    }

    public static class TestDAO {
        private Long id;
        private String propOne;
        private String propTwo;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getPropOne() {
            return this.propOne;
        }

        public void setPropOne(String propOne) {
            this.propOne = propOne;
        }

        public String getPropTwo() {
            return this.propTwo;
        }

        public void setPropTwo(String propTwo) {
            this.propTwo = propTwo;
        }
    }
}

